/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends GuiScreen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private static final Function<Waypoint, String> NAME_VALUE = new Function<Waypoint, String>(){

        @Override
        public String apply(Waypoint w) {
            return w.getName();
        }
    };
    private static final Function<Waypoint, Integer> X_VALUE = new Function<Waypoint, Integer>(){

        @Override
        public Integer apply(Waypoint w) {
            return w.getX();
        }
    };
    private static final Function<Waypoint, Integer> Y_VALUE = new Function<Waypoint, Integer>(){

        @Override
        public Integer apply(Waypoint w) {
            return w.getY();
        }
    };
    private static final Function<Waypoint, Integer> Z_VALUE = new Function<Waypoint, Integer>(){

        @Override
        public Integer apply(Waypoint w) {
            return w.getZ();
        }
    };
    private static final Function<Waypoint, Integer> YAW_VALUE = new Function<Waypoint, Integer>(){

        @Override
        public Integer apply(Waypoint w) {
            return w.getYaw();
        }
    };
    private static final Function<Waypoint, Boolean> ROTATION_VALUE = new Function<Waypoint, Boolean>(){

        @Override
        public Boolean apply(Waypoint w) {
            return w.isRotation();
        }
    };
    private static final Function<Waypoint, String> INITIAL_VALUE = new Function<Waypoint, String>(){

        @Override
        public String apply(Waypoint w) {
            return w.getSymbol();
        }
    };
    private static final Function<Waypoint, Boolean> DISABLED_VALUE = new Function<Waypoint, Boolean>(){

        @Override
        public Boolean apply(Waypoint w) {
            return w.isDisabled();
        }
    };
    private static final Function<Waypoint, Integer> COLOR_VALUE = new Function<Waypoint, Integer>(){

        @Override
        public Integer apply(Waypoint w) {
            return w.getColor();
        }
    };
    private GuiButton multiplyButton;
    private GuiButton divideButton;
    private GuiTextField nameTextField;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField initialTextField;
    private String nameText;
    private String xText;
    private String yText;
    private String zText;
    private String yaw;
    private String initial;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private int color;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private boolean waypointDisabled;
    private MySuperTinyButton disableButton;
    private NumericFieldValidator fieldValidator;
    private boolean keepNameText;
    private boolean keepXTextField;
    private boolean keepYTextField;
    private boolean keepZTextField;
    private boolean keepYawTextField;
    private boolean keepInitialTextField;
    private boolean keepDisabledValue;
    private boolean adding;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private boolean defaultKeepYawTextField;
    private boolean defaultKeepDisabledValue;
    private GuiButton defaultYawButton;
    private GuiButton defaultDisabledButton;
    private int multiplyDefaultValueBy8Counter;

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, par1GuiScreen, point == null ? new ArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, point == null || point.getColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this.parentGuiScreen = par1GuiScreen;
        this.waypointsEdited = waypointsEdited;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, defaultParentContainer);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(defaultParentContainer), this.waypointsManager, defaultWorld.getFullId());
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.nameText = "";
        this.dropDowns = new ArrayList();
        this.initial = "";
        this.yaw = "";
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.adding = adding;
        if (waypointsEdited.isEmpty()) {
            this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
        } else if (this.differentValues(COLOR_VALUE)) {
            this.color = 0;
        } else {
            this.color = waypointsEdited.get(0).getColor();
            if (this.color == -1) {
                this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
            }
        }
        String string = this.screenTitle = adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (waypointsEdited.isEmpty()) {
            boolean divideBy8 = this.waypointsManager.divideBy8(this.worlds.getCurrentKeys()[0]);
            Minecraft minecraft = Minecraft.func_71410_x();
            this.xText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70165_t) * (divideBy8 ? 8 : 1);
            this.yText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70121_D.field_72338_b);
            this.zText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70161_v) * (divideBy8 ? 8 : 1);
        } else {
            this.xText = "";
            this.yText = "";
            this.zText = "";
            this.keepNameText = this.differentValues(NAME_VALUE);
            this.keepXTextField = this.differentValues(X_VALUE);
            this.keepYTextField = this.differentValues(Y_VALUE);
            this.keepZTextField = this.differentValues(Z_VALUE);
            this.keepYawTextField = this.differentValues(ROTATION_VALUE) || GuiWaypoints.allWaypointsAre(waypointsEdited, 3) && this.differentValues(YAW_VALUE);
            this.defaultKeepYawTextField = this.keepYawTextField;
            this.keepInitialTextField = this.differentValues(INITIAL_VALUE);
            this.defaultKeepDisabledValue = this.keepDisabledValue = this.differentValues(DISABLED_VALUE);
            Waypoint firstWaypoint = waypointsEdited.get(0);
            if (!this.keepNameText) {
                this.nameText = firstWaypoint.getLocalizedName();
            }
            if (!this.keepXTextField) {
                this.xText = firstWaypoint.getX() + "";
            }
            if (!this.keepYTextField) {
                this.yText = firstWaypoint.getY() + "";
            }
            if (!this.keepZTextField) {
                this.zText = firstWaypoint.getZ() + "";
            }
            if (!this.keepYawTextField && firstWaypoint.isRotation()) {
                this.yaw = firstWaypoint.getYaw() + "";
            }
            if (!this.keepInitialTextField) {
                this.initial = firstWaypoint.getSymbol() + "";
            }
            if (!this.keepDisabledValue) {
                this.waypointDisabled = firstWaypoint.isDisabled();
            }
        }
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
    }

    private <T> boolean differentValues(Function<Waypoint, T> s) {
        if (this.waypointsEdited.isEmpty()) {
            return false;
        }
        Waypoint testWaypoint = this.waypointsEdited.get(0);
        for (Waypoint w : this.waypointsEdited) {
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.differentValues(COLOR_VALUE);
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_73866_w_() {
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.multiplyButton = new MySuperTinyButton(203, this.field_146294_l / 2 - 165, 121, I18n.func_135052_a((String)"* 8", (Object[])new Object[0]));
        this.field_146292_n.add(this.multiplyButton);
        this.divideButton = new MySuperTinyButton(204, this.field_146294_l / 2 - 165, 147, I18n.func_135052_a((String)"/ 8", (Object[])new Object[0]));
        this.field_146292_n.add(this.divideButton);
        this.nameTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 100, 104, 200, 20);
        this.xTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 109, 134, 50, 20);
        this.yTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 53, 134, 50, 20);
        this.zTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 + 3, 134, 50, 20);
        this.yawTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 + 59, 134, 50, 20);
        this.initialTextField = new GuiTextField(this.field_146289_q, this.field_146294_l / 2 - 25, 164, 50, 20);
        this.nameTextField.func_146180_a(this.nameText);
        this.xTextField.func_146180_a(this.xText);
        this.yTextField.func_146180_a(this.yText);
        this.zTextField.func_146180_a(this.zText);
        this.yawTextField.func_146180_a(this.yaw);
        this.initialTextField.func_146180_a(this.initial);
        String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(205, this.field_146294_l / 2 + 31, 164, enabledisable[this.waypointDisabled ? 1 : 0]);
        this.field_146292_n.add(this.disableButton);
        if (this.defaultKeepYawTextField) {
            this.defaultYawButton = new GuiButton(206, this.field_146294_l / 2 + 111, 134, 20, 20, "-");
            this.field_146292_n.add(this.defaultYawButton);
            boolean bl = this.defaultYawButton.field_146124_l = !this.keepYawTextField;
        }
        if (this.defaultKeepDisabledValue) {
            this.defaultDisabledButton = new GuiButton(207, this.field_146294_l / 2 + 81, 164, 20, 20, "-");
            this.field_146292_n.add(this.defaultDisabledButton);
            this.defaultDisabledButton.field_146124_l = !this.keepDisabledValue;
        }
        this.dropDowns.clear();
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.field_146294_l / 2 - 60, 82, 120, this.color, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.nameTextField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    private void updateMultiplyButtons() {
        this.multiplyButton.field_146124_l = this.multiplyDefaultValueBy8Counter < 1;
        this.divideButton.field_146124_l = this.multiplyDefaultValueBy8Counter > -1;
    }

    private int applyDefaultMultiplier(int x) {
        block3: {
            block2: {
                if (this.multiplyDefaultValueBy8Counter <= 0) break block2;
                for (int i = 0; i < this.multiplyDefaultValueBy8Counter; ++i) {
                    x *= 8;
                }
                break block3;
            }
            if (this.multiplyDefaultValueBy8Counter >= 0) break block3;
            for (int i = 0; i < -this.multiplyDefaultValueBy8Counter; ++i) {
                x = (int)Math.floor((double)x * 0.125);
            }
        }
        return x;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.nameTextField.func_146206_l()) {
            if (par2 == 15) {
                this.nameTextField.func_146195_b(false);
                this.xTextField.func_146195_b(true);
            }
            this.nameTextField.func_146201_a(par1, par2);
            if (this.initial.length() == 0 && this.nameTextField.func_146179_b().length() > 0 && !this.keepInitialTextField) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1));
            }
        } else if (this.xTextField.func_146206_l()) {
            if (par2 == 15) {
                this.xTextField.func_146195_b(false);
                this.yTextField.func_146195_b(true);
            }
            this.xTextField.func_146201_a(par1, par2);
        } else if (this.yTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yTextField.func_146195_b(false);
                this.zTextField.func_146195_b(true);
            }
            this.yTextField.func_146201_a(par1, par2);
        } else if (this.zTextField.func_146206_l()) {
            if (par2 == 15) {
                this.zTextField.func_146195_b(false);
                this.yawTextField.func_146195_b(true);
            }
            this.zTextField.func_146201_a(par1, par2);
        } else if (this.yawTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yawTextField.func_146195_b(false);
                this.initialTextField.func_146195_b(true);
            }
            this.yawTextField.func_146201_a(par1, par2);
            this.fieldValidator.validate(this.yawTextField);
            this.keepYawTextField = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.field_146124_l = true;
            }
        } else if (this.initialTextField.func_146206_l()) {
            if (par2 == 15) {
                this.initialTextField.func_146195_b(false);
                this.nameTextField.func_146195_b(true);
            }
            if (par2 != 57) {
                this.initialTextField.func_146201_a(par1, par2);
            }
        }
        if (par2 == 28 || par2 == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.checkFields();
        this.updateConfirmButton();
        super.func_73869_a(par1, par2);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = !(!this.keepNameText && this.nameTextField.func_146179_b().length() <= 0 || !this.keepInitialTextField && this.initial.length() <= 0 || !this.keepXTextField && this.xTextField.func_146179_b().length() <= 0 || !this.keepYTextField && this.yTextField.func_146179_b().length() <= 0 || !this.keepZTextField && this.zTextField.func_146179_b().length() <= 0);
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        this.nameText = this.nameTextField.func_146179_b();
        this.xText = this.xTextField.func_146179_b();
        this.yText = this.yTextField.func_146179_b();
        this.zText = this.zTextField.func_146179_b();
        this.yaw = this.yawTextField.func_146179_b();
        this.initial = this.initialTextField.func_146179_b();
        this.initial = this.initial.toUpperCase();
        if (this.initial.length() > 1) {
            this.initial = this.initial.substring(0, 1);
            this.initialTextField.func_146180_a(this.initial);
        }
        if (this.yaw.length() > 4) {
            this.yaw = this.yaw.substring(0, 4);
            this.yawTextField.func_146180_a(this.yaw);
        }
        if (this.waypointsEdited.size() > 1) {
            this.keepNameText = this.nameText.isEmpty();
            this.keepXTextField = this.xText.isEmpty();
            this.keepYTextField = this.yText.isEmpty();
            this.keepZTextField = this.zText.isEmpty();
            this.keepInitialTextField = this.initial.isEmpty();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
        this.xTextField.func_146192_a(par1, par2, par3);
        this.yTextField.func_146192_a(par1, par2, par3);
        this.zTextField.func_146192_a(par1, par2, par3);
        this.yawTextField.func_146192_a(par1, par2, par3);
        this.initialTextField.func_146192_a(par1, par2, par3);
    }

    public void func_146286_b(int p_146286_1_, int p_146286_2_, int p_146286_3_) {
        if (p_146286_3_ != -1) {
            for (GuiDropDown d : this.dropDowns) {
                d.mouseReleased(p_146286_1_, p_146286_2_, p_146286_3_, this.field_146295_m);
            }
        }
        super.func_146286_b(p_146286_1_, p_146286_2_, p_146286_3_);
    }

    private void setFieldText(GuiTextField field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void func_73876_c() {
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            String[] enabledisable;
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MySmallButton) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                boolean creatingAWaypoint;
                int x = this.keepXTextField || this.xTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.xTextField.func_146179_b());
                int y = this.keepYTextField || this.yTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.yTextField.func_146179_b());
                int z = this.keepZTextField || this.zTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.zTextField.func_146179_b());
                String name = this.nameTextField.func_146179_b();
                boolean bl = creatingAWaypoint = this.adding && this.waypointsEdited.isEmpty();
                if (creatingAWaypoint) {
                    Waypoint created = new Waypoint(x, y, z, name, this.initial, this.color);
                    this.waypointsEdited.add(created);
                } else {
                    for (Waypoint w : this.waypointsEdited) {
                        if (!this.keepNameText) {
                            w.setName(name);
                        }
                        if (!this.keepXTextField) {
                            w.setX(x);
                        }
                        if (!this.keepYTextField) {
                            w.setY(y);
                        }
                        if (!this.keepZTextField) {
                            w.setZ(z);
                        }
                        if (!this.keepInitialTextField) {
                            w.setSymbol(this.initial);
                        }
                        if (this.colorDD.size() > ModSettings.ENCHANT_COLOR_NAMES.length) {
                            if (this.color == 0) continue;
                            w.setColor(this.color - 1);
                            continue;
                        }
                        w.setColor(this.color);
                    }
                }
                boolean yawIsUsable = this.yaw.length() > 0 && !this.yaw.equals("-");
                int yawInt = yawIsUsable ? Integer.parseInt(this.yaw) : 0;
                for (Waypoint w : this.waypointsEdited) {
                    w.setX(this.applyDefaultMultiplier(w.getX()));
                    w.setZ(this.applyDefaultMultiplier(w.getZ()));
                    if (!this.keepDisabledValue) {
                        w.setDisabled(this.waypointDisabled);
                    }
                    if (this.keepYawTextField) continue;
                    w.setRotation(yawIsUsable);
                    if (!yawIsUsable) continue;
                    w.setYaw(yawInt);
                }
                WaypointWorld sourceWorld = this.defaultWorld;
                WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
                String[] destinationWorldKeys = this.worlds.getCurrentKeys();
                String destinationSetKey = this.sets.getCurrentSetKey();
                WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
                WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
                if (this.adding || sourceSet != destinationSet) {
                    destinationSet.getList().addAll(0, this.waypointsEdited);
                }
                if (sourceSet != destinationSet) {
                    sourceSet.getList().removeAll(this.waypointsEdited);
                }
                try {
                    this.modMain.getSettings().saveWaypoints(sourceWorld);
                    if (destinationWorld != sourceWorld) {
                        this.modMain.getSettings().saveWaypoints(destinationWorld);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 202) {
                this.color = (this.color + 1) % (ModSettings.ENCHANT_COLORS.length - 1);
            }
            if (par1GuiButton.field_146127_k == 203) {
                ++this.multiplyDefaultValueBy8Counter;
                this.updateMultiplyButtons();
            } else if (par1GuiButton.field_146127_k == 204) {
                --this.multiplyDefaultValueBy8Counter;
                this.updateMultiplyButtons();
            }
            if (par1GuiButton.field_146127_k == 205) {
                this.waypointDisabled = !this.waypointDisabled;
                enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                this.disableButton.field_146126_j = this.waypointDisabled ? enabledisable[1] : enabledisable[0];
                this.keepDisabledValue = false;
                if (this.defaultDisabledButton != null) {
                    this.defaultDisabledButton.field_146124_l = true;
                }
            }
            if (par1GuiButton.field_146127_k == 206) {
                this.keepYawTextField = this.defaultKeepYawTextField;
                this.yaw = "";
                this.yawTextField.func_146180_a(this.yaw);
                par1GuiButton.field_146124_l = false;
            }
            if (par1GuiButton.field_146127_k == 207) {
                this.keepDisabledValue = this.defaultKeepDisabledValue;
                this.waypointDisabled = false;
                enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                this.disableButton.field_146126_j = this.waypointDisabled ? enabledisable[1] : enabledisable[0];
                par1GuiButton.field_146124_l = false;
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public List getButtons() {
        return this.field_146292_n;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        if (!this.nameTextField.func_146206_l() && this.keepNameText) {
            this.setFieldText(this.nameTextField, this.namePlaceholder);
        }
        if (!this.xTextField.func_146206_l()) {
            if (this.keepXTextField) {
                this.setFieldText(this.xTextField, this.xPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yTextField.func_146206_l() && this.keepYTextField) {
            this.setFieldText(this.yTextField, this.yPlaceholder);
        }
        if (!this.zTextField.func_146206_l()) {
            if (this.keepZTextField) {
                this.setFieldText(this.zTextField, this.zPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yawTextField.func_146206_l() && this.yaw.isEmpty()) {
            if (this.keepYawTextField) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                this.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
        }
        if (!this.initialTextField.func_146206_l() && this.initial.isEmpty()) {
            if (this.keepInitialTextField) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                this.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
        }
        this.nameTextField.func_146194_f();
        this.xTextField.func_146194_f();
        this.yTextField.func_146194_f();
        this.zTextField.func_146194_f();
        this.yawTextField.func_146194_f();
        this.initialTextField.func_146194_f();
        this.setFieldText(this.nameTextField, this.nameText);
        this.setFieldText(this.xTextField, this.xText);
        this.setFieldText(this.yTextField, this.yText);
        this.setFieldText(this.zTextField, this.zText);
        this.setFieldText(this.yawTextField, this.yaw);
        this.setFieldText(this.initialTextField, this.initial);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(par1, par2, this.field_146295_m);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(par1, par2, this.field_146295_m);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return;
            }
        }
    }

    @Override
    public void onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.color = selected;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
    }
}

