/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
    }

    public void render(float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints() && this.waypointsManager.getWaypoints() != null) {
            EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partial;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partial;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partial;
            Tessellator tessellator = Tessellator.field_78398_a;
            boolean divideBy8 = this.waypointsManager.divideBy8(this.waypointsManager.getCurrentContainerID());
            if (this.waypointsManager.renderAllSets) {
                HashMap<String, WaypointSet> sets = this.waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, (Entity)entity, tessellator, divideBy8);
                }
            } else {
                this.renderWaypointsList(this.waypointsManager.getWaypoints().getList(), d3, d4, d5, (Entity)entity, tessellator, divideBy8);
            }
            if (ServerWaypointStorage.working() && this.waypointsManager.getServerWaypoints() != null) {
                this.renderWaypointsList(this.waypointsManager.getServerWaypoints(), d3, d4, d5, (Entity)entity, tessellator, divideBy8);
            }
            RenderHelper.func_74518_a();
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
        }
    }

    private void renderWaypointsList(List<Waypoint> list, double d3, double d4, double d5, Entity entity, Tessellator tessellator, boolean divideBy8) {
        float cameraAngleYaw = MathHelper.func_76142_g((float)entity.field_70177_z);
        Vec3 lookVector = entity.func_70040_Z();
        int lookVectorMultiplier = Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? -1 : 1;
        double eyesX = d3;
        double eyesY = d4;
        double eyesZ = d5;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O > 0) {
            eyesX -= 4.0 * lookVector.field_72450_a * (double)lookVectorMultiplier;
            eyesY -= 4.0 * lookVector.field_72448_b * (double)lookVectorMultiplier;
            eyesZ -= 4.0 * lookVector.field_72449_c * (double)lookVectorMultiplier;
        }
        for (int i = 0; i < list.size(); ++i) {
            this.renderWaypointIngame(cameraAngleYaw, lookVector, lookVectorMultiplier, eyesX, eyesY, eyesZ, list.get(i), 12.0, d3, d4, d5, entity, tessellator, divideBy8);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, Vec3 lookVector, int lookVectorMultiplier, double eyesX, double eyesY, double eyesZ, Waypoint w, double radius, double d3, double d4, double d5, Entity entity, Tessellator tessellator, boolean divideBy8) {
        if (w.isDisabled() || w.getType() == 1 && !this.modMain.getSettings().getDeathpoints()) {
            return;
        }
        double wpRenderX = (double)w.getX(divideBy8) + 0.5;
        double wpRenderY = (double)w.getY() + 1.0;
        double wpRenderZ = (double)w.getZ(divideBy8) + 0.5;
        float offX = (float)(wpRenderX - d3);
        float offY = (float)(wpRenderY - d4);
        float offZ = (float)(wpRenderZ - d5);
        float fromEyesX = (float)(wpRenderX - eyesX);
        float fromEyesY = (float)(wpRenderY - eyesY);
        float fromEyesZ = (float)(wpRenderZ - eyesZ);
        if (((double)fromEyesX * lookVector.field_72450_a + (double)fromEyesY * lookVector.field_72448_b + (double)fromEyesZ * lookVector.field_72449_c) * (double)lookVectorMultiplier < 0.0) {
            return;
        }
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        double correctDistance = Math.sqrt(offX * offX + (offY - 1.0f) * (offY - 1.0f) + offZ * offZ);
        w.setLastDistance(distance);
        if (this.modMain.getSettings().waypointsDistance != 0.0f && distance > (double)this.modMain.getSettings().waypointsDistance || this.modMain.getSettings().waypointsDistanceMin != 0.0f && distance < (double)this.modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (this.modMain.getSettings().keepWaypointNames) {
            textSize = 1.6f;
        }
        if (distance > radius) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                float zoomer = (float)(maxDistance / distance);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(distance / radius);
            }
        }
        if (correctDistance > 20.0 || this.modMain.getSettings().alwaysShowDistance) {
            textSize = 1.6f;
            if (this.modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)this.modMain.getSettings().lookingAtAngle;
                if (this.modMain.getSettings().lookingAtAngleVertical != 180) {
                    float cameraAnglePitch = entity.field_70125_A;
                    float verticalAngle = (float)Math.toDegrees(Math.asin((double)(-offY) / (distance == 0.0 ? 1.0E-5 : distance)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)this.modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (this.modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!this.modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        GL11.glTranslatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(renderManager.field_78732_j * (float)(Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? -1 : 1)), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glScalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawIconInWorld(w, this.modMain.getSettings(), tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        int t;
        GL11.glScalef((float)settings.waypointsScale, (float)settings.waypointsScale, (float)1.0f);
        if (w.getType() == 0) {
            int c = ModSettings.COLORS[w.getColor()];
            int l = c >> 16 & 0xFF;
            int i1 = c >> 8 & 0xFF;
            int j1 = c & 0xFF;
            GL11.glDisable((int)3553);
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            tessellator.func_78382_b();
            tessellator.func_78370_a(l, i1, j1, (int)(133.3f * ((float)settings.waypointOpacityIngame / 100.0f)));
            tessellator.func_78377_a(-5.0, -9.0, 0.0);
            tessellator.func_78377_a(-5.0, 0.0, 0.0);
            tessellator.func_78377_a(4.0, 0.0, 0.0);
            tessellator.func_78377_a(4.0, -9.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, 0x20FFFFFF);
            fontrenderer.func_78276_b(w.getSymbol(), -s, -8, -1);
        } else if (w.getType() == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            tessellator.func_78382_b();
            tessellator.func_78370_a(256, 256, 256, (int)(250.0f * ((float)settings.waypointOpacityIngame / 100.0f)));
            tessellator.func_78374_a(-5.0, -9.0, 0.0, 0.0, (double)(78.0f * f1));
            tessellator.func_78374_a(-5.0, 0.0, 0.0, 0.0, (double)(87.0f * f1));
            tessellator.func_78374_a(4.0, 0.0, 0.0, (double)(9.0f * f), (double)(87.0f * f1));
            tessellator.func_78374_a(4.0, -9.0, 0.0, (double)(9.0f * f), (double)(78.0f * f1));
            tessellator.func_78381_a();
            if (!showDistance) {
                name = w.getLocalizedName();
                if (!settings.keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        if (Minecraft.func_71410_x().func_152349_b()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            t = fontrenderer.func_78256_a(distance) / 2;
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78370_a(0, 0, 0, 70);
            tessellator.func_78377_a((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78377_a((double)t, (double)(showingName ? 10 : 0), 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), 0x20FFFFFF);
            fontrenderer.func_78276_b(distance, -t, 1 + (showingName ? 10 : 0), -1);
        }
        if (showingName) {
            t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_78276_b(name, -t, 1, 0x20FFFFFF);
            fontrenderer.func_78276_b(name, -t, 1, -1);
        }
    }
}

