/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp.interfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.IInterfaceLoader;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.Preset;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.pvp.BetterPVP;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.notifications.Notification;
import xaero.pvp.notifications.NotificationHandler;

public class BPVPInterfaceLoader
implements IInterfaceLoader {
    private BetterPVP modMain;
    private Minecraft mc = Minecraft.func_71410_x();
    private RenderItem itemRenderer = this.mc.func_175599_af();
    public static Random rand = new Random();
    public static long arrowWas = 0L;

    public BPVPInterfaceLoader(BetterPVP modMain) {
        this.modMain = modMain;
    }

    @Override
    public void loadPresets(InterfaceManager interfaces) {
        interfaces.addPreset(new Preset("gui.xaero_preset_fancy", new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 36}, {0, 0}, {0, 0}, {0, 128}}, new boolean[][]{{true, false, false}, {true, false, true}, {true, false, true}, {true, false, false}, {false, true, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_classic", new int[][]{{0, 0}, {0, 10000}, {0, 10000}, {0, 0}, {0, 0}, {0, 10000}, {0, 186}}, new boolean[][]{{false, true, false}, {false, true, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_social", new int[][]{{0, 0}, {0, 0}, {0, 10000}, {0, 41}, {0, 0}, {0, 10000}, {0, 78}}, new boolean[][]{{true, false, false}, {true, false, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, false}}));
    }

    @Override
    public void load(IXaeroMinimap main, InterfaceManager interfaces) {
        interfaces.add(new Interface(interfaces, "gui.xaero_potion_status", interfaces.getNextId(), 120, 165, 182, 36, ModOptions.SHOW_EFFECTS){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                if (!((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70651_bq().isEmpty()) {
                    BPVPInterfaceLoader.this.displayDebuffEffects(this, width, height);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_armour_status", interfaces.getNextId(), 150, 136, 400, 41, ModOptions.SHOW_ARMOR){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                GL11.glEnable((int)3008);
                if (!this.isCentered()) {
                    BPVPInterfaceLoader.this.drawClassicArmour(this.getX(), this.getY(), this.getW(), this.getH(), width, height, this.shouldFlip(width));
                } else {
                    BPVPInterfaceLoader.this.drawCenteredArmour(this.getX(), this.getY(), this.getW(), this.getH(), width, height);
                }
                RenderHelper.func_74518_a();
                GlStateManager.func_179097_i();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_xp_setting", interfaces.getNextId(), 50, 86, ModOptions.XP){
            private int lastXPCheck;
            public long xpDelay;
            {
                this.lastXPCheck = 0;
                this.xpDelay = 0L;
            }

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                EntityPlayerSP player = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g;
                NotificationHandler nh = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.notifications;
                if (System.currentTimeMillis() - this.xpDelay >= 1000L) {
                    this.xpDelay = System.currentTimeMillis();
                    int totalXP = player.field_71067_cb;
                    if (this.lastXPCheck != totalXP) {
                        String xp = (totalXP - this.lastXPCheck > 0 ? "\u00a7e+" : "\u00a7e") + (totalXP - this.lastXPCheck) + " XP";
                        nh.notifications.add(new Notification(xp, 5000, this.getX() + this.getW() / 2 - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(xp) / 2, this.getY() + 39));
                        this.lastXPCheck = totalXP;
                    }
                }
                ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.notifications.drawNotifications();
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_notifications", interfaces.getNextId(), 200, 42, ModOptions.NOTIFICATIONS){

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                ArrayList<Integer> notifications = new ArrayList<Integer>();
                if ((float)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_71024_bL().func_75116_a() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHunger) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHunger()) {
                    notifications.add(0);
                }
                if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110143_aJ() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHealth) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHP()) {
                    notifications.add(1);
                }
                if (BPVPInterfaceLoader.this.tntIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationTNT()) {
                    notifications.add(2);
                }
                if (BPVPInterfaceLoader.this.arrowIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationArrow()) {
                    notifications.add(3);
                }
                if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70086_ai() <= 30 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowAir && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationAir()) {
                    notifications.add(4);
                }
                int between = 32 - 4 * notifications.size();
                int unitSize = 32 + between;
                int length = notifications.size() * unitSize;
                int drawY = this.getY() + (this.getH() - 32) / 2;
                GL11.glEnable((int)3008);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (length > 0) {
                    BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
                    if (BPVPInterfaceHandler.blinking) {
                        GlStateManager.func_179131_c((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                    }
                    for (int i = 0; i < notifications.size(); ++i) {
                        int n = (Integer)notifications.get(i);
                        int drawX = this.getX() + this.getW() / 2 - length / 2 + i * unitSize + between / 2;
                        ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71456_v.func_73729_b(drawX, drawY, 17, n * 32, 32, 32);
                    }
                    BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new MinimapInterface(this.modMain, interfaces.getNextId(), interfaces));
        interfaces.add(new Interface(interfaces, "gui.xaero_entity_info", interfaces.getNextId(), 148, 70, ModOptions.ENTITY_INFO){
            EntityLivingBase e;
            long lastFind;
            {
                this.e = null;
                this.lastFind = 0L;
            }

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                long time = System.currentTimeMillis();
                MovingObjectPosition objectMouseOver = null;
                if (BPVPInterfaceLoader.this.mc.func_71401_C() != null) {
                    Entity playerServerSide = BPVPInterfaceLoader.this.mc.func_71401_C().func_175576_a(((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110124_au());
                    if (playerServerSide != null) {
                        objectMouseOver = BPVPInterfaceLoader.this.getMouseOver(playerServerSide.field_70170_p, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoDistance, partial);
                    }
                } else {
                    objectMouseOver = BPVPInterfaceLoader.this.getMouseOver((World)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71441_e, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoDistance, partial);
                }
                if (objectMouseOver != null && objectMouseOver.field_72308_g != null && objectMouseOver.field_72308_g instanceof EntityLivingBase) {
                    this.e = (EntityLivingBase)objectMouseOver.field_72308_g;
                    this.lastFind = time;
                }
                if (this.e != null && !this.e.func_98034_c((EntityPlayer)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g) && time - this.lastFind <= (long)(1000 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoStay)) {
                    try {
                        int healthOff;
                        boolean vertFlipped = this.getY() + this.getH() / 2 > height / 2;
                        boolean flip = this.shouldFlip(width);
                        float resize = 1.0f;
                        if (this.e.field_70130_N > resize) {
                            resize = this.e.field_70130_N;
                        }
                        if (this.e.field_70131_O > resize * 2.0f) {
                            resize = this.e.field_70131_O / 2.0f;
                        }
                        int n = healthOff = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel ? 55 : 5;
                        if (BPVPInterfaceLoader.this.mc.func_71401_C() != null && ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoEffects) {
                            int effectsOffset = (int)BPVPInterfaceLoader.this.drawPotionEffects(this.e, this.getX() + (flip ? this.getW() - 3 : 3), this.getY() + (vertFlipped ? this.getH() - 5 : 5), vertFlipped ? this.getY() + this.getH() : height - this.getY(), flip, vertFlipped, scale);
                            if (healthOff == 5 && effectsOffset != -1) {
                                healthOff = 8 + effectsOffset;
                            }
                        }
                        boolean armourDrawn = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowArmour && BPVPInterfaceLoader.this.drawArmourBar(this.e, this.getX() + (flip ? this.getW() - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0), flip, vertFlipped);
                        BPVPInterfaceLoader.this.drawHealthBar(this.e, this.getX() + (flip ? this.getW() - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0) + (armourDrawn ? 10 : 0) * (vertFlipped ? -1 : 1), flip, vertFlipped);
                        if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel) {
                            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-500.0f);
                            GlStateManager.func_179126_j();
                            BPVPInterfaceLoader.this.drawEntityOnScreen(this.getX() + (flip ? this.getW() - 25 : 25), this.getY() + 35, (int)(30.0f / resize), this.e, flip);
                            GlStateManager.func_179097_i();
                            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                        }
                        String name = this.e.func_70005_c_();
                        int xCoord = this.getX() + (flip ? this.getW() - healthOff - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(name) : healthOff);
                        ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_175063_a(name, (float)xCoord, (float)(this.getY() + 5 + (vertFlipped ? 52 : 0)), 0xFFFFFF);
                    }
                    catch (Exception e) {
                        System.out.println("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums!!!");
                        e.printStackTrace();
                    }
                }
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_item_tooltip", interfaces.getNextId(), 150, 50, ModOptions.ITEM_TOOLTIP){
            private GuiScreenAccess screenInstance;
            private ItemStack previousStack;
            private long itemSwitchTime;
            {
                this.screenInstance = new GuiScreenAccess();
            }

            @Override
            public void drawInterface(int width, int height, int scale, float partial) {
                ItemStack currentStack = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.field_71071_by.func_70448_g();
                if (currentStack != this.previousStack) {
                    this.itemSwitchTime = System.currentTimeMillis();
                    this.previousStack = currentStack;
                }
                if (currentStack != null && (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71462_r instanceof GuiEditMode || System.currentTimeMillis() - this.itemSwitchTime <= (long)(BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipTime() * 1000 / 2))) {
                    List textLines = currentStack.func_82840_a((EntityPlayer)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71474_y.field_82882_x);
                    for (int i = 0; i < textLines.size(); ++i) {
                        if (i == 0) {
                            textLines.set(i, currentStack.func_77953_t().field_77937_e + (String)textLines.get(i));
                            continue;
                        }
                        textLines.set(i, EnumChatFormatting.GRAY + (String)textLines.get(i));
                    }
                    if (textLines.size() >= BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipMinLines()) {
                        int border = 5;
                        int renderX = this.getX() + border;
                        int renderY = this.getY() + border;
                        int renderW = this.getW() - 2 * border;
                        int renderH = this.getH() - 2 * border;
                        int screenWidth = width;
                        int screenHeight = height;
                        if (this.isCentered() || this.isFromRight() && !this.isFlipped() || !this.isFromRight() && this.isFlipped()) {
                            int tooltipTextWidth = 0;
                            for (String textLine : textLines) {
                                int textLineWidth = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(textLine);
                                if (textLineWidth <= tooltipTextWidth) continue;
                                tooltipTextWidth = textLineWidth;
                            }
                            int tooltipWidth = tooltipTextWidth + 8;
                            if (this.isCentered()) {
                                renderX += (renderW - tooltipWidth) / 2;
                            } else {
                                screenWidth = renderX + renderW;
                                renderX += renderW - tooltipWidth;
                            }
                        }
                        if (this.isFromBottom()) {
                            int tooltipHeight = 16;
                            if (textLines.size() > 1) {
                                tooltipHeight += 2 + (textLines.size() - 1) * 10;
                            }
                            screenHeight = renderY + renderH + 2;
                            renderY += renderH - tooltipHeight;
                        }
                        this.screenInstance.func_146280_a(BPVPInterfaceLoader.this.mc, screenWidth, screenHeight);
                        this.screenInstance.drawHoveringText(textLines, renderX - 8, renderY + 16, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p);
                        RenderHelper.func_74518_a();
                    }
                }
                super.drawInterface(width, height, scale, partial);
            }
        });
    }

    public MovingObjectPosition getMouseOver(World world, double reach, float p_78473_1_) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null && world != null) {
            List list;
            MovingObjectPosition objectMouseOver = entity.func_174822_a(reach, p_78473_1_);
            Vec3 playerEyes = entity.func_174824_e(p_78473_1_);
            double d2 = reach;
            if (objectMouseOver != null) {
                d2 = objectMouseOver.field_72307_f.func_72438_d(playerEyes);
            }
            Vec3 lookVector = entity.func_70676_i(p_78473_1_);
            Vec3 farthestPoint = playerEyes.func_72441_c(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2);
            Entity pointedEntity = null;
            Vec3 entityHitPoint = null;
            float f1 = 1.0f;
            try {
                list = world.func_72839_b(entity, entity.func_174813_aQ().func_72321_a(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2).func_72314_b((double)f1, (double)f1, (double)f1));
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_145782_y() == entity.func_145782_y()) continue;
                float f2 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(playerEyes, farthestPoint);
                if (axisalignedbb.func_72318_a(playerEyes)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    entityHitPoint = movingobjectposition == null ? playerEyes : movingobjectposition.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = playerEyes.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1 == entity.field_70154_o && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    entityHitPoint = movingobjectposition.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                entityHitPoint = movingobjectposition.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < reach || objectMouseOver == null)) {
                objectMouseOver = new MovingObjectPosition(pointedEntity, entityHitPoint);
            }
            return objectMouseOver;
        }
        return null;
    }

    public double drawPotionEffects(EntityLivingBase e, int x, int y, int h, boolean flip, boolean vertFlipped, int scale) {
        ArrayList effects = new ArrayList(e.func_70651_bq());
        if (effects.isEmpty()) {
            return -1.0;
        }
        int place = 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179147_l();
        double pixelSize = (double)this.modMain.getBPVPSettings().entityInfoEffectsScale / (double)scale * (double)this.modMain.getBPVPSettings().getMinimapScale();
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        for (PotionEffect pe : effects) {
            Potion p;
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            GlStateManager.func_179109_b((float)(flip ? (float)(-18 - 25 * column) : (float)(25 * column)), (float)(vertFlipped ? (float)(-18 - 25 * row) : (float)(25 * row)), (float)0.0f);
            if (pe == null || (p = Potion.field_76425_a[pe.func_76456_a()]) == null) continue;
            if (p.func_76400_d()) {
                this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                int iconIndex = p.func_76392_e();
                if (pe.func_76459_b() <= 200 && !BPVPInterfaceHandler.blinking) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                this.mc.field_71456_v.func_73729_b(0, 0, 0 + iconIndex % 8 * 18, 198 + iconIndex / 8 * 18, 18, 18);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        return effectSize * (double)(1 + effects.size() / perColumn) - 7.0 * pixelSize;
    }

    public boolean drawArmourBar(EntityLivingBase e, int x, int y, boolean flip, boolean vertFlipped) {
        this.mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        int k2 = e.func_70658_aO();
        if (k2 > 0) {
            if (this.modMain.getBPVPSettings().entityInfoArmourNumbers) {
                this.mc.field_71456_v.func_73729_b(x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                this.mc.field_71466_p.func_175063_a(k2 + "/20", (float)(x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(k2 + "/20") : 11)), (float)y, 0xFFFFFF);
            } else {
                for (int i3 = 0; i3 < 10; ++i3) {
                    int j3 = x + (flip ? -8 - i3 * 8 : i3 * 8);
                    if (i3 * 2 + 1 < k2) {
                        this.mc.field_71456_v.func_73729_b(j3, y, 34, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 == k2) {
                        this.mc.field_71456_v.func_73729_b(j3, y, 25, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 <= k2) continue;
                    this.mc.field_71456_v.func_73729_b(j3, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(EntityLivingBase e, int x, int y, boolean flip, boolean vertFlipped) {
        float f1;
        int health = MathHelper.func_76123_f((float)e.func_110143_aJ());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IAttributeInstance iattributeinstance = e.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float maxHealth = (float)iattributeinstance.func_111126_e();
        if (this.modMain.getBPVPSettings().entityInfoHealthNumbers) {
            String text = health + "/" + (int)maxHealth;
            this.mc.field_71466_p.func_175063_a(text, (float)(x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(text) : 11)), (float)y, 0xFFFFFF);
            health = 2;
            maxHealth = 2.0f;
        }
        this.mc.func_110434_K().func_110577_a(GuiIngame.field_110324_m);
        float f = Math.min((float)(this.modMain.getBPVPSettings().entityInfoMaxHearts * 2), maxHealth);
        int i = (int)((float)health * f / maxHealth);
        float f2 = f1 = e.func_110139_bj();
        int l1 = MathHelper.func_76123_f((float)((f + f1) / 2.0f / 10.0f));
        int i2 = Math.max(10 - (l1 - 2), 3);
        int i1 = x;
        int k1 = y;
        int l2 = -1;
        for (int i3 = MathHelper.func_76123_f((float)((f + f1) / 2.0f)) - 1; i3 >= 0; --i3) {
            int j3 = 16;
            int b0 = 1;
            int k3 = MathHelper.func_76123_f((float)((float)(i3 + 1) / 10.0f)) - 1;
            int xcoord = i3 % 10 * 8;
            int l3 = i1 + (flip ? -xcoord - 9 : xcoord);
            int i4 = k1 + k3 * i2 * (vertFlipped ? -1 : 1);
            if ((double)i <= (double)f * 0.4) {
                i4 += rand.nextInt(2);
            }
            if (i3 == l2) {
                i4 -= 2;
            }
            int b1 = 0;
            if (e.field_70170_p.func_72912_H().func_76093_s()) {
                b1 = 5;
            }
            this.drawMyTexturedModalRect(l3, i4, 16 + b0 * 9, 9 * b1, 9, 9, flip);
            if (f2 > 0.0f) {
                if (f2 == f1 && f1 % 2.0f == 1.0f) {
                    this.drawMyTexturedModalRect(l3, i4, j3 + 153, 9 * b1, 9, 9, flip);
                } else {
                    this.drawMyTexturedModalRect(l3, i4, j3 + 144, 9 * b1, 9, 9, flip);
                }
                f2 -= 2.0f;
                continue;
            }
            if (i3 * 2 + 1 < i) {
                this.drawMyTexturedModalRect(l3, i4, j3 + 36, 9 * b1, 9, 9, flip);
            }
            if (i3 * 2 + 1 != i) continue;
            this.drawMyTexturedModalRect(l3, i4, j3 + 45, 9 * b1, 9, 9, flip);
        }
    }

    public void drawMyTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + (flip ? width : 0)) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + (flip ? 0 : width)) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + (flip ? 0 : width)) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + (flip ? width : 0)) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawEntityOnScreen(int p_147046_0_, int p_147046_1_, int p_147046_2_, EntityLivingBase p_147046_5_, boolean flip) {
        double cos;
        if ((p_147046_5_ = (EntityLivingBase)this.mc.field_71441_e.func_73045_a(p_147046_5_.func_145782_y())) == null) {
            return;
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)p_147046_0_, (float)p_147046_1_, (float)50.0f);
        GlStateManager.func_179152_a((float)(-p_147046_2_), (float)p_147046_2_, (float)p_147046_2_);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f2 = p_147046_5_.field_70761_aq;
        float f3 = p_147046_5_.field_70177_z;
        float f6 = p_147046_5_.field_70759_as;
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        float width = p_147046_5_.field_70130_N * (float)p_147046_2_ / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        GlStateManager.func_179114_b((float)((float)(flip ? 0 : 90) - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        p_147046_5_.field_70761_aq = 0.0f;
        p_147046_5_.field_70177_z = 0.0f;
        p_147046_5_.field_70759_as = f6 - f2;
        GlStateManager.func_179109_b((float)0.0f, (float)(-p_147046_5_.field_70131_O / 2.0f), (float)0.0f);
        RenderManager rendermanager = this.mc.func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        boolean hideGUIBU = this.mc.field_71474_y.field_74319_N;
        this.mc.field_71474_y.field_74319_N = true;
        rendermanager.func_147939_a((Entity)p_147046_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        this.mc.field_71474_y.field_74319_N = hideGUIBU;
        rendermanager.func_178633_a(true);
        GlStateManager.func_179084_k();
        p_147046_5_.field_70761_aq = f2;
        p_147046_5_.field_70177_z = f3;
        p_147046_5_.field_70759_as = f6;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public void drawCenteredArmour(int x, int y, int w, int h, int width, int height) {
        int slot;
        for (slot = 2; slot < 4; ++slot) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.field_70460_b[slot], x + w / 2 - 91 - 3, y + 3 + 19 - 19 * (slot - 2), true, false);
        }
        for (slot = 0; slot < 2; ++slot) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.field_70460_b[slot], x + w / 2 + 91 + 3, y + 3 + 19 - 19 * slot, false, false);
        }
        int iconY = y > height / 2 ? y - 16 : y + h;
        boolean bow = this.hasABow();
        if (!(this.mc.field_71439_g.field_71071_by.func_70448_g() == null || this.isArrows(this.mc.field_71439_g.field_71071_by.func_70448_g()) && bow)) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.func_70448_g(), width - 3, iconY, true, this.modMain.getBPVPSettings().showFullAmount);
        }
        if (bow && this.modMain.getBPVPSettings().getArchery()) {
            ItemStack arrow = this.getArrowsStack((EntityPlayer)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            this.drawItemWithEnchants(true, arrow, width - 3, arrowY, true, false);
        }
    }

    public void drawClassicArmour(int x, int y, int w, int h, int width, int height, boolean flip) {
        ItemStack[] items = new ItemStack[5];
        String drawEnchants = null;
        boolean itemUp = y > height / 2;
        items[0] = itemUp ? this.mc.field_71439_g.field_71071_by.func_70448_g() : this.mc.field_71439_g.field_71071_by.field_70460_b[3];
        items[1] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 3 : 2];
        items[2] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 2 : 1];
        items[3] = this.mc.field_71439_g.field_71071_by.field_70460_b[itemUp ? 1 : 0];
        items[4] = itemUp ? this.mc.field_71439_g.field_71071_by.field_70460_b[0] : this.mc.field_71439_g.field_71071_by.func_70448_g();
        int iconX = x + (flip ? w - 3 : 3);
        for (int i = 0; i < items.length; ++i) {
            ItemStack stack = items[i];
            if (stack == null) continue;
            boolean enchanted = stack.func_77948_v();
            drawEnchants = this.drawEnchants(enchanted ? stack.func_77986_q() : null);
            String str = this.getDamageString(stack);
            if (!this.modMain.getBPVPSettings().getShowEnchants()) {
                drawEnchants = null;
            }
            this.drawItemWithName(false, stack, str, drawEnchants, iconX, y + 3 + 19 * i, flip, this.modMain.getBPVPSettings().showFullAmount && (itemUp && i == 0 || !itemUp && i == 4));
        }
        if (this.modMain.getBPVPSettings().getArchery() && this.hasABow()) {
            ItemStack arrow = new ItemStack(Item.func_150899_d((int)262));
            int arrowY = itemUp ? y - 16 : y + h;
            this.drawItemWithName(true, arrow, this.getArrowAmountString(arrow), null, iconX, arrowY, flip, false);
        }
    }

    public void renderArrows(int bow, int iconY, int y, int height, int width) {
        if (this.modMain.getBPVPSettings().getArchery()) {
            ItemStack arrow = this.getArrowsStack((EntityPlayer)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            this.drawItemWithEnchants(true, arrow, bow == 0 ? width - 3 : 3, arrowY, bow == 0, false);
        }
    }

    private ItemStack getArrowsStack(EntityPlayer player) {
        if (this.isArrows(player.func_71045_bC())) {
            return player.func_71045_bC();
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrows(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrows(ItemStack stack) {
        return stack != null && stack.func_77973_b() == Items.field_151032_g;
    }

    public void drawItemWithEnchants(boolean arrows, ItemStack stack, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null) {
            return;
        }
        boolean enchanted = stack.func_77948_v();
        String drawEnchants = this.drawEnchants(enchanted ? stack.func_77986_q() : null);
        String str = !arrows ? this.getDamageString(stack) : this.getArrowAmountString(stack);
        if (!this.modMain.getBPVPSettings().getShowEnchants()) {
            drawEnchants = null;
        }
        this.drawItemWithName(arrows, stack, str, drawEnchants, x, y, flipped, fullSize);
    }

    public void drawItemWithName(boolean arrows, ItemStack stack, String name, String name1, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null) {
            return;
        }
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int stringX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name) : 19);
        int stringY = iconY;
        int enchantX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name1) : 19);
        int enchantY = iconY + 9;
        this.mc.field_71466_p.func_175063_a(name, (float)stringX, (float)stringY, 0xFFFFFF);
        if (name1 != null) {
            this.mc.field_71466_p.func_175063_a(name1, (float)enchantX, (float)enchantY, 0xFFFFFF);
        }
        RenderHelper.func_74520_c();
        this.itemRenderer.field_77023_b -= 1000.0f;
        this.itemRenderer.func_180450_b(stack, iconX, iconY);
        this.itemRenderer.field_77023_b += 1000.0f;
        int size = stack.field_77994_a;
        if (fullSize) {
            size = this.getFullItemAmount(stack.func_77973_b());
        }
        if (size <= 1 || arrows) {
            size = -1;
        }
        this.itemRenderer.func_180453_a(this.mc.field_71466_p, stack, iconX, iconY, size != -1 ? "" + size : "");
        RenderHelper.func_74518_a();
    }

    public boolean tntIsAround() {
        for (int i = 0; i < this.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            if (!(this.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityTNTPrimed) && (!(this.mc.field_71439_g.field_70170_p.field_72996_f.get(i) instanceof EntityCreeper) || ((EntityCreeper)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i)).func_70832_p() != 1)) continue;
            Entity e = (Entity)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e.field_70165_t - this.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v > -5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean arrowIsAround() {
        if (System.currentTimeMillis() - arrowWas < 5000L) {
            return true;
        }
        for (int i = 0; i < this.mc.field_71439_g.field_70170_p.field_72996_f.size(); ++i) {
            Entity e = (Entity)this.mc.field_71439_g.field_70170_p.field_72996_f.get(i);
            if (!(e instanceof EntityArrow) || e.field_70142_S == e.field_70165_t && e.field_70137_T == e.field_70163_u && e.field_70136_U == e.field_70161_v || ((EntityArrow)e).field_70250_c == this.mc.field_71439_g || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t < 5.0) || !(e.field_70165_t - this.mc.field_71439_g.field_70165_t > -5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u < 5.0) || !(e.field_70163_u - this.mc.field_71439_g.field_70163_u > -5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v < 5.0) || !(e.field_70161_v - this.mc.field_71439_g.field_70161_v > -5.0)) continue;
            arrowWas = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public int getFullItemAmount(Item item) {
        int toReturn = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || stack.func_77973_b() != item) continue;
            toReturn += stack.field_77994_a;
        }
        return toReturn;
    }

    public String getArrowAmountString(ItemStack used) {
        String toReturn = null;
        int arrows = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (!this.isArrows(stack)) continue;
            arrows += stack.field_77994_a;
        }
        toReturn = used.field_77994_a + "/" + arrows;
        return toReturn;
    }

    public boolean hasABow() {
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.mc.field_71439_g.field_71071_by.field_70462_a[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemBow)) continue;
            return true;
        }
        return false;
    }

    public void displayDebuffEffects(Interface in, int width, int height) {
        block17: {
            Collection var4;
            int var1 = in.getX();
            int var2 = in.getY();
            int w = in.getW();
            int h = in.getH();
            boolean flippedVer = in.isFlipped();
            boolean flippedHor = in.shouldFlip(width);
            if (flippedVer) {
                var2 = var2 + h - 30;
            }
            if ((var4 = this.mc.field_71439_g.func_70651_bq()).isEmpty()) break block17;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            if (!in.isCentered()) {
                int var5 = 25;
                if (var4.size() > 6) {
                    var5 = 135 / (var4.size() - 1);
                }
                for (PotionEffect var7 : this.mc.field_71439_g.func_70651_bq()) {
                    int duration = var7.func_76459_b();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    Potion var8 = Potion.field_76425_a[var7.func_76456_a()];
                    this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                    if (var8.func_76400_d()) {
                        int var9 = var8.func_76392_e();
                        this.mc.field_71456_v.func_73729_b(flippedHor ? var1 + w - 24 : var1 + 6, var2 + 7, 0 + var9 % 8 * 18, 198 + var9 / 8 * 18, 18, 18);
                    }
                    String potionName = I18n.func_135052_a((String)var8.func_76393_a(), (Object[])new Object[0]);
                    if (var7.func_76458_c() == 1) {
                        potionName = potionName + " II";
                    } else if (var7.func_76458_c() == 2) {
                        potionName = potionName + " III";
                    } else if (var7.func_76458_c() == 3) {
                        potionName = potionName + " IV";
                    }
                    String durationString = Potion.func_76389_a((PotionEffect)var7);
                    if (!this.modMain.getBPVPSettings().getShowEffectNames()) {
                        potionName = durationString;
                        durationString = "";
                    }
                    this.mc.field_71466_p.func_175063_a(potionName, flippedHor ? (float)(var1 + w - 28 - this.mc.field_71466_p.func_78256_a(potionName)) : (float)(var1 + 10 + 18), (float)(var2 + 6), 0xFFFFFF);
                    this.mc.field_71466_p.func_175063_a(durationString, flippedHor ? (float)(var1 + w - 28 - this.mc.field_71466_p.func_78256_a(durationString)) : (float)(var1 + 10 + 18), (float)(var2 + 6 + 10), 0xFFFFFF);
                    var2 += flippedVer ? -var5 : var5;
                }
            } else {
                int var5 = 27;
                int defaultEffectAmount = 182 / var5;
                if (var4.size() > defaultEffectAmount) {
                    var5 = 182 / var4.size();
                }
                int totalSize = var4.size() * var5;
                int currentX = var1 + w / 2 - totalSize / 2 + (var5 - 18) / 2;
                int currentY = in.getY() + 7;
                for (PotionEffect var7 : this.mc.field_71439_g.func_70651_bq()) {
                    int duration = var7.func_76459_b();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    Potion var8 = Potion.field_76425_a[var7.func_76456_a()];
                    this.mc.func_110434_K().func_110577_a(BPVPInterfaceHandler.invtextures);
                    if (var8.func_76400_d()) {
                        int var9 = var8.func_76392_e();
                        this.mc.field_71456_v.func_73729_b(currentX, currentY, 0 + var9 % 8 * 18, 198 + var9 / 8 * 18, 18, 18);
                    }
                    String var10 = Potion.func_76389_a((PotionEffect)var7);
                    this.mc.field_71466_p.func_175063_a(var10, (float)(currentX + 10 - this.mc.field_71466_p.func_78256_a(var10) / 2), (float)(currentY + 15), 0xFFFFFF);
                    currentX += var5;
                }
            }
        }
    }

    public String getDamageString(ItemStack stack) {
        String toReturn = stack.func_77973_b().func_77653_i(stack);
        try {
            if (((ItemFood)stack.func_77973_b()).func_150905_g(stack) > 0) {
                return I18n.func_135052_a((String)"gui.xaero_restores", (Object[])new Object[0]) + " " + (double)((ItemFood)stack.func_77973_b()).func_150905_g(stack) / 2.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stack.func_77958_k() == 0) {
            return toReturn;
        }
        int percent = (stack.func_77958_k() - stack.func_77952_i()) * 100 / stack.func_77958_k();
        if (this.modMain.getBPVPSettings().durability == 0) {
            toReturn = percent + "%";
        } else if (this.modMain.getBPVPSettings().durability == 1) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1);
        } else if (this.modMain.getBPVPSettings().durability == 2) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1) + " (" + percent + "%)";
        }
        if (percent <= 5) {
            toReturn = "\u00a7d" + toReturn;
        } else if (percent <= 25) {
            toReturn = "\u00a7c" + toReturn;
        } else if (percent <= 50) {
            toReturn = "\u00a76" + toReturn;
        } else if (percent <= 75) {
            toReturn = "\u00a7e" + toReturn;
        }
        return toReturn;
    }

    private String drawEnchants(NBTTagList etl) {
        if (etl == null) {
            return null;
        }
        String s = "";
        int count = etl.func_74745_c();
        for (int i = 0; i < count; ++i) {
            short short1 = etl.func_150305_b(i).func_74765_d("id");
            short short2 = etl.func_150305_b(i).func_74765_d("lvl");
            String e = "";
            if (Enchantment.func_180306_c((int)short1) != null) {
                e = Enchantment.func_180306_c((int)short1).func_77316_c((int)short2);
            }
            e = this.translateEchant(e, count);
            s = s + e + ", ";
        }
        if (s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return "\u00a7" + ModSettings.ENCHANT_COLORS[this.modMain.getBPVPSettings().enchantColor] + s;
    }

    private String translateEchant(String s, int count) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (count <= 1) {
            return s;
        }
        String[] words = s.split(" ");
        s = "";
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            s = s + (i == words.length - 1 ? " " + s1 : (s1.length() > 0 ? s1.substring(0, 1).toUpperCase() : ""));
        }
        return s;
    }

    public static class GuiScreenAccess
    extends GuiScreen {
        public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
            super.drawHoveringText(textLines, x, y, font);
        }
    }
}

