/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.patreon.Patreon4;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_212866_a_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SChunkDataPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SChangeBlockPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SMultiBlockChangePacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179844_a()[0].func_180090_a().func_177958_n() >> 4, packetIn.func_179844_a()[0].func_180090_a().func_177952_p() >> 4);
    }

    public static void onSpawn(SWorldSpawnChangedPacket packetIn) {
        modMain.getEvents().handlePlayerSetSpawn((World)Minecraft.func_71410_x().field_71441_e, packetIn.func_240832_b_());
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayerEntity player) {
        return Patreon4.getPlayerCape(modMain.getFileLayoutID(), player);
    }

    public static Boolean isWearing(PlayerEntity player, PlayerModelPart part) {
        if (part != PlayerModelPart.CAPE || !(player instanceof AbstractClientPlayerEntity)) {
            return null;
        }
        return Patreon4.isWearingCape(modMain.getFileLayoutID(), (AbstractClientPlayerEntity)player);
    }

    public static void onPlayNetHandler(ClientPlayNetHandler netHandler) {
        XaeroMinimapSession minimapSession = modMain.createSession();
        try {
            minimapSession.init();
            ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
            Minecraft.func_71410_x().field_71441_e.func_72882_A();
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPlayNetHandler netHandler) {
        try {
            ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession().cleanup();
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    static {
        chunkCleanField = null;
    }
}

