/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.WaypointEditForm;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends Screen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private Screen parentGuiScreen;
    protected String screenTitle;
    private Button leftButton;
    private Button rightButton;
    private Button modeSwitchButton;
    private Button resetButton;
    private TextFieldWidget nameTextField;
    private TextFieldWidget xTextField;
    private TextFieldWidget yTextField;
    private TextFieldWidget zTextField;
    private TextFieldWidget yawTextField;
    private TextFieldWidget initialTextField;
    private WaypointEditForm mutualForm;
    private ArrayList<WaypointEditForm> editForms;
    private int selectedWaypointIndex;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private MySuperTinyButton disableButton;
    private MySuperTinyButton globalButton;
    private NumericFieldValidator fieldValidator;
    private boolean adding;
    private boolean prefilled;
    private boolean startPrefilled;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private Button defaultYawButton;
    private Button defaultDisabledButton;
    private Button defaultGlobalButton;
    private int multiplyDefaultValueBy8Counter;
    private boolean censorCoordsIfNeeded;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;
    private BiFunction<String, Integer, String> censoredTextFormatter;

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, waypointsManager, par1GuiScreen, point == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, point == null || point.getActualColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager waypointsManager, Screen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        super((ITextComponent)new StringTextComponent(""));
        this.parentGuiScreen = par1GuiScreen;
        this.waypointsEdited = waypointsEdited;
        this.modMain = modMain;
        this.waypointsManager = waypointsManager;
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.frozenAutoContainerID = waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = waypointsManager.getAutoWorldID();
        this.containers = new GuiWaypointContainers(modMain, waypointsManager, defaultParentContainer, this.frozenAutoContainerID);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(waypointsManager.getWorldContainer(defaultParentContainer), waypointsManager, defaultWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.dropDowns = new ArrayList();
        this.prefilled = !waypointsEdited.isEmpty();
        this.startPrefilled = this.prefilled;
        this.createForms();
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.adding = adding;
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
        this.censorCoordsIfNeeded = true;
        this.censoredTextFormatter = (p_195610_0_, p_195610_1_) -> {
            if (!this.censorCoordsIfNeeded) {
                return p_195610_0_;
            }
            int formatIndex = p_195610_0_.indexOf("\u00a7".charAt(0));
            if (formatIndex == -1) {
                return p_195610_0_.replaceAll(".", "#");
            }
            return p_195610_0_.substring(0, formatIndex).replaceAll(".", "#") + p_195610_0_.substring(formatIndex);
        };
    }

    private void fillFormWaypoint(WaypointEditForm form, Waypoint w) {
        form.name = w.getLocalizedName();
        form.xText = w.getX() + "";
        form.yText = w.getY() + "";
        form.zText = w.getZ() + "";
        form.yawText = w.isRotation() ? w.getYaw() + "" : "";
        form.initial = w.getSymbol() + "";
        form.disabled = w.isDisabled();
        form.color = 1 + (w.getActualColor() == -1 ? (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) : w.getActualColor());
        form.global = w.isGlobal();
    }

    private void fillFormAutomatic(WaypointEditForm form) {
        boolean divideBy8 = this.waypointsManager.divideBy8(this.worlds.getCurrentKeys()[0]);
        Minecraft minecraft = Minecraft.func_71410_x();
        form.xText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226277_ct_()) * (divideBy8 ? 8 : 1);
        form.yText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226278_cu_());
        form.zText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226281_cx_()) * (divideBy8 ? 8 : 1);
        form.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) + 1;
    }

    private void createForms() {
        this.editForms = new ArrayList();
        this.mutualForm = new WaypointEditForm();
        for (int i = 0; i < this.waypointsEdited.size(); ++i) {
            Waypoint w = this.waypointsEdited.get(i);
            WaypointEditForm form = new WaypointEditForm();
            this.fillFormWaypoint(form, w);
            this.editForms.add(form);
        }
        if (!this.startPrefilled) {
            WaypointEditForm createdForm = new WaypointEditForm();
            this.fillFormAutomatic(createdForm);
            this.editForms.add(createdForm);
        }
        this.updateMutual();
    }

    private void resetCurrentForm() {
        if (this.selectedWaypointIndex >= this.waypointsEdited.size()) {
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormAutomatic(freshForm);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        } else {
            Waypoint w = this.waypointsEdited.get(this.selectedWaypointIndex);
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormWaypoint(freshForm, w);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        }
    }

    private void updateMutual() {
        String nameTextMutual = "";
        String initialMutual = "";
        String yawMutual = "";
        String xTextMutual = "";
        String yTextMutual = "";
        String zTextMutual = "";
        boolean waypointDisabledMutual = false;
        boolean waypointGlobalMutual = false;
        int colorMutual = 0;
        colorMutual = this.differentValues(WaypointEditForm::getColor) ? 0 : this.editForms.get((int)0).color;
        xTextMutual = "";
        yTextMutual = "";
        zTextMutual = "";
        this.mutualForm.keepName = this.differentValues(WaypointEditForm::getName);
        this.mutualForm.keepXText = this.differentValues(WaypointEditForm::getxText);
        this.mutualForm.keepYText = this.differentValues(WaypointEditForm::getyText);
        this.mutualForm.keepZText = this.differentValues(WaypointEditForm::getzText);
        this.mutualForm.defaultKeepYawText = this.mutualForm.keepYawText = this.differentValues(WaypointEditForm::getYawText);
        this.mutualForm.keepInitial = this.differentValues(WaypointEditForm::getInitial);
        this.mutualForm.defaultKeepDisabled = this.mutualForm.keepDisabled = this.differentValues(WaypointEditForm::isDisabled);
        this.mutualForm.defaultKeepGlobal = this.mutualForm.keepGlobal = this.differentValues(WaypointEditForm::isGlobal);
        WaypointEditForm firstForm = this.editForms.get(0);
        if (!this.mutualForm.keepName) {
            nameTextMutual = firstForm.name;
        }
        if (!this.mutualForm.keepXText) {
            xTextMutual = firstForm.xText;
        }
        if (!this.mutualForm.keepYText) {
            yTextMutual = firstForm.yText;
        }
        if (!this.mutualForm.keepZText) {
            zTextMutual = firstForm.zText;
        }
        if (!this.mutualForm.keepYawText) {
            yawMutual = firstForm.yawText;
        }
        if (!this.mutualForm.keepInitial) {
            initialMutual = firstForm.initial;
        }
        if (!this.mutualForm.keepDisabled) {
            waypointDisabledMutual = firstForm.disabled;
        }
        if (!this.mutualForm.keepGlobal) {
            waypointGlobalMutual = firstForm.global;
        }
        this.mutualForm.name = nameTextMutual;
        this.mutualForm.xText = xTextMutual;
        this.mutualForm.yText = yTextMutual;
        this.mutualForm.zText = zTextMutual;
        this.mutualForm.yawText = yawMutual;
        this.mutualForm.initial = initialMutual;
        this.mutualForm.disabled = waypointDisabledMutual;
        this.mutualForm.global = waypointGlobalMutual;
        this.mutualForm.color = colorMutual;
    }

    private void confirmMutual() {
        for (int i = 0; i < this.editForms.size(); ++i) {
            WaypointEditForm individualForm = this.editForms.get(i);
            if (!this.mutualForm.keepName) {
                individualForm.name = this.mutualForm.name;
            }
            if (!this.mutualForm.keepXText) {
                individualForm.xText = this.mutualForm.xText;
            }
            if (!this.mutualForm.keepYText) {
                individualForm.yText = this.mutualForm.yText;
            }
            if (!this.mutualForm.keepZText) {
                individualForm.zText = this.mutualForm.zText;
            }
            if (!this.mutualForm.keepYawText) {
                individualForm.yawText = this.mutualForm.yawText;
            }
            if (!this.mutualForm.keepInitial) {
                individualForm.initial = this.mutualForm.initial;
            }
            if (!this.mutualForm.keepDisabled) {
                individualForm.disabled = this.mutualForm.disabled;
            }
            if (!this.mutualForm.keepGlobal) {
                individualForm.global = this.mutualForm.global;
            }
            if (this.mutualForm.color == 0) continue;
            individualForm.color = this.mutualForm.color;
        }
    }

    private boolean differentValues(Function<WaypointEditForm, Object> s) {
        if (this.editForms.size() == 1) {
            return false;
        }
        WaypointEditForm testWaypoint = this.editForms.get(0);
        for (int i = 1; i < this.editForms.size(); ++i) {
            WaypointEditForm w = this.editForms.get(i);
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.getCurrent().color == 0;
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        String string = this.screenTitle = this.adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (this.editForms.size() > 1) {
            this.screenTitle = this.screenTitle + (this.editForms.size() > 1 ? " (" + (this.modMain.getSettings().waypointsMutualEdit ? "" : this.selectedWaypointIndex + 1 + "/") + this.editForms.size() + ")" : "");
        }
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.nameTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 104, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_waypoint_name"));
        this.xTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 109, 134, 50, 20, (ITextComponent)new StringTextComponent("x"));
        this.yTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 53, 134, 50, 20, (ITextComponent)new StringTextComponent("y"));
        this.zTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 3, 134, 50, 20, (ITextComponent)new StringTextComponent("z"));
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.xTextField.func_195607_a(this.censoredTextFormatter);
            this.yTextField.func_195607_a(this.censoredTextFormatter);
            this.zTextField.func_195607_a(this.censoredTextFormatter);
        }
        this.yawTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 59, 134, 50, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_yaw"));
        this.initialTextField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 25, 164, 50, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_initial"));
        this.field_230705_e_.add(this.nameTextField);
        this.field_230705_e_.add(this.xTextField);
        this.field_230705_e_.add(this.yTextField);
        this.field_230705_e_.add(this.zTextField);
        this.field_230705_e_.add(this.yawTextField);
        this.field_230705_e_.add(this.initialTextField);
        this.func_230480_a_((Widget)new MySmallButton(0, this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            WaypointEditForm waypointForm;
            Waypoint w;
            int i;
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.confirmMutual();
            }
            boolean creatingAWaypoint = this.adding && this.waypointsEdited.size() < this.editForms.size();
            for (i = 0; i < this.waypointsEdited.size(); ++i) {
                w = this.waypointsEdited.get(i);
                waypointForm = this.editForms.get(i);
                String nameString = waypointForm.name;
                String xString = waypointForm.xText;
                String yString = waypointForm.yText;
                String zString = waypointForm.zText;
                String initialString = waypointForm.initial;
                int colorInt = waypointForm.color;
                if (w.getType() != 1 || !nameString.equals(I18n.func_135052_a((String)"gui.xaero_deathpoint", (Object[])new Object[0]))) {
                    w.setName(nameString);
                    if (w.getType() == 1) {
                        w.setType(0);
                    }
                }
                int x = xString.equals("-") ? 0 : Integer.parseInt(xString);
                int y = yString.equals("-") ? 0 : Integer.parseInt(yString);
                int z = zString.equals("-") ? 0 : Integer.parseInt(zString);
                w.setX(x);
                w.setY(y);
                w.setZ(z);
                w.setSymbol(initialString);
                w.setColor(colorInt - 1);
            }
            if (creatingAWaypoint) {
                for (i = this.waypointsEdited.size(); i < this.editForms.size(); ++i) {
                    WaypointEditForm createdForm = this.editForms.get(i);
                    String nameString = createdForm.name;
                    String xString = createdForm.xText;
                    String yString = createdForm.yText;
                    String zString = createdForm.zText;
                    String initialString = createdForm.initial;
                    int colorInt = createdForm.color;
                    int x = xString.equals("-") ? 0 : Integer.parseInt(xString);
                    int y = yString.equals("-") ? 0 : Integer.parseInt(yString);
                    int z = zString.equals("-") ? 0 : Integer.parseInt(zString);
                    Waypoint created = new Waypoint(x, y, z, nameString, initialString, colorInt - 1);
                    this.waypointsEdited.add(created);
                }
            }
            for (i = 0; i < this.waypointsEdited.size(); ++i) {
                w = this.waypointsEdited.get(i);
                waypointForm = this.editForms.get(i);
                String yawText = waypointForm.yawText;
                boolean disableBool = waypointForm.disabled;
                boolean yawIsUsable = yawText.length() > 0 && !yawText.equals("-");
                w.setRotation(yawIsUsable);
                if (yawIsUsable) {
                    w.setYaw(Integer.parseInt(yawText));
                }
                w.setDisabled(disableBool);
                w.setGlobal(waypointForm.global);
            }
            WaypointWorld sourceWorld = this.defaultWorld;
            WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
            String[] destinationWorldKeys = this.worlds.getCurrentKeys();
            String destinationSetKey = this.sets.getCurrentSetKey();
            WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
            WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
            if (this.adding || sourceSet != destinationSet) {
                destinationSet.getList().addAll(0, this.waypointsEdited);
            }
            if (sourceSet != destinationSet) {
                sourceSet.getList().removeAll(this.waypointsEdited);
            }
            try {
                this.modMain.getSettings().saveWaypoints(sourceWorld);
                if (destinationWorld != sourceWorld) {
                    this.modMain.getSettings().saveWaypoints(destinationWorld);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.field_230706_i_.func_147108_a(this.parentGuiScreen);
        }));
        this.func_230480_a_((Widget)new MySmallButton(0, this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.field_230706_i_.func_147108_a(this.parentGuiScreen)));
        this.leftButton = new Button(this.field_230708_k_ / 2 - 203, 104, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
            --this.selectedWaypointIndex;
            if (this.selectedWaypointIndex < 0) {
                this.selectedWaypointIndex = 0;
            }
            boolean restoreFocus = this.func_241217_q_() == b;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            if (restoreFocus) {
                boolean activeBU = this.leftButton.field_230693_o_;
                this.leftButton.field_230693_o_ = true;
                this.func_231035_a_((IGuiEventListener)this.leftButton);
                this.leftButton.func_231049_c__(true);
                this.leftButton.field_230693_o_ = activeBU;
            }
        });
        this.func_230480_a_((Widget)this.leftButton);
        this.rightButton = new Button(this.field_230708_k_ / 2 + 183, 104, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
            ++this.selectedWaypointIndex;
            if (this.selectedWaypointIndex >= this.editForms.size()) {
                this.selectedWaypointIndex = this.editForms.size() - 1;
            }
            boolean restoreFocus = this.func_241217_q_() == b;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            if (restoreFocus) {
                boolean activeBU = this.rightButton.field_230693_o_;
                this.rightButton.field_230693_o_ = true;
                this.func_231035_a_((IGuiEventListener)this.rightButton);
                this.rightButton.func_231049_c__(true);
                this.rightButton.field_230693_o_ = activeBU;
            }
        });
        this.func_230480_a_((Widget)this.rightButton);
        this.modeSwitchButton = new MyTinyButton(this.field_230708_k_ / 2 + 129, 56, null, (ITextComponent)new TranslationTextComponent(this.modMain.getSettings().waypointsMutualEdit ? "gui.xaero_waypoints_edit_mode_all" : "gui.xaero_waypoints_edit_mode_individually"), b -> {
            this.modMain.getSettings().waypointsMutualEdit = !this.modMain.getSettings().waypointsMutualEdit;
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.prefilled = true;
                this.updateMutual();
            } else {
                this.confirmMutual();
            }
            boolean restoreFocus = this.func_241217_q_() == b;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            if (restoreFocus) {
                boolean activeBU = this.modeSwitchButton.field_230693_o_;
                this.modeSwitchButton.field_230693_o_ = true;
                this.func_231035_a_((IGuiEventListener)this.modeSwitchButton);
                this.modeSwitchButton.func_231049_c__(true);
                this.modeSwitchButton.field_230693_o_ = activeBU;
            }
        });
        this.func_230480_a_((Widget)this.modeSwitchButton);
        this.resetButton = new MyTinyButton(this.field_230708_k_ / 2 - 204, 56, null, (ITextComponent)new TranslationTextComponent("gui.xaero_waypoints_edit_reset"), b -> {
            if (this.modMain.getSettings().waypointsMutualEdit) {
                this.createForms();
                boolean restoreFocus = this.func_241217_q_() == b;
                this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.field_230693_o_;
                    this.resetButton.field_230693_o_ = true;
                    this.func_231035_a_((IGuiEventListener)this.resetButton);
                    this.resetButton.func_231049_c__(true);
                    this.resetButton.field_230693_o_ = activeBU;
                }
            } else {
                this.resetCurrentForm();
                boolean restoreFocus = this.func_241217_q_() == b;
                this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.field_230693_o_;
                    this.resetButton.field_230693_o_ = true;
                    this.func_231035_a_((IGuiEventListener)this.resetButton);
                    this.resetButton.func_231049_c__(true);
                    this.resetButton.field_230693_o_ = activeBU;
                }
            }
        });
        this.func_230480_a_((Widget)this.resetButton);
        this.nameTextField.func_146180_a(this.getCurrent().name);
        this.xTextField.func_146180_a(this.getCurrent().xText);
        this.yTextField.func_146180_a(this.getCurrent().yText);
        this.zTextField.func_146180_a(this.getCurrent().zText);
        this.yawTextField.func_146180_a(this.getCurrent().yawText);
        this.initialTextField.func_146180_a(this.getCurrent().initial);
        String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(this.field_230708_k_ / 2 + 31, 164, (ITextComponent)new StringTextComponent(enabledisable[this.getCurrent().disabled ? 1 : 0]), b -> {
            this.getCurrent().disabled = !this.getCurrent().disabled;
            this.disableButton.func_238482_a_((ITextComponent)new StringTextComponent(this.getCurrent().disabled ? enabledisable[1] : enabledisable[0]));
            this.getCurrent().keepDisabled = false;
            if (this.defaultDisabledButton != null) {
                this.defaultDisabledButton.field_230693_o_ = true;
            }
        });
        this.func_230480_a_((Widget)this.disableButton);
        this.globalButton = new MySuperTinyButton(this.field_230708_k_ / 2 - 81, 164, (ITextComponent)new TranslationTextComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"), b -> {
            this.getCurrent().global = !this.getCurrent().global;
            this.globalButton.func_238482_a_((ITextComponent)new TranslationTextComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"));
            this.getCurrent().keepGlobal = false;
            if (this.defaultGlobalButton != null) {
                this.defaultGlobalButton.field_230693_o_ = true;
            }
        });
        this.func_230480_a_((Widget)this.globalButton);
        if (this.getCurrent().defaultKeepYawText) {
            this.defaultYawButton = new Button(this.field_230708_k_ / 2 + 111, 134, 20, 20, (ITextComponent)new StringTextComponent("-"), b -> {
                this.getCurrent().keepYawText = true;
                this.getCurrent().yawText = "";
                this.yawTextField.func_146180_a(this.getCurrent().yawText);
                b.field_230693_o_ = false;
            });
            this.func_230480_a_((Widget)this.defaultYawButton);
            boolean bl = this.defaultYawButton.field_230693_o_ = !this.getCurrent().keepYawText;
        }
        if (this.getCurrent().defaultKeepDisabled) {
            this.defaultDisabledButton = new Button(this.field_230708_k_ / 2 + 81, 164, 20, 20, (ITextComponent)new StringTextComponent("-"), b -> {
                this.getCurrent().keepDisabled = true;
                this.getCurrent().disabled = false;
                this.disableButton.func_238482_a_((ITextComponent)new StringTextComponent(this.getCurrent().disabled ? enabledisable[1] : enabledisable[0]));
                b.field_230693_o_ = false;
            });
            this.func_230480_a_((Widget)this.defaultDisabledButton);
            boolean bl = this.defaultDisabledButton.field_230693_o_ = !this.getCurrent().keepDisabled;
        }
        if (this.getCurrent().defaultKeepGlobal) {
            this.defaultGlobalButton = new Button(this.field_230708_k_ / 2 - 101, 164, 20, 20, (ITextComponent)new StringTextComponent("-"), b -> {
                this.getCurrent().keepGlobal = true;
                this.getCurrent().global = false;
                this.globalButton.func_238482_a_((ITextComponent)new TranslationTextComponent(this.getCurrent().global ? "gui.xaero_waypoints_global" : "gui.xaero_waypoints_local"));
                b.field_230693_o_ = false;
            });
            this.func_230480_a_((Widget)this.defaultGlobalButton);
            boolean bl = this.defaultGlobalButton.field_230693_o_ = !this.getCurrent().keepGlobal;
        }
        if (this.modMain.getSettings().hideWaypointCoordinates) {
            this.func_230480_a_((Widget)new MySuperTinyButton(this.field_230708_k_ / 2 + 115, 134, (ITextComponent)new TranslationTextComponent(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"), b -> {
                this.censorCoordsIfNeeded = !this.censorCoordsIfNeeded;
                b.func_238482_a_((ITextComponent)new TranslationTextComponent(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide"));
            }));
        }
        this.dropDowns.clear();
        int currentColor = this.getCurrent().color;
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.field_230708_k_ / 2 - 60, 82, 120, currentColor == 0 ? 0 : currentColor - 1, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_230708_k_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.field_230708_k_ / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_230708_k_ / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.func_231035_a_((IGuiEventListener)this.nameTextField);
        this.nameTextField.func_146195_b(true);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    private WaypointEditForm getCurrent() {
        return this.modMain.getSettings().waypointsMutualEdit ? this.mutualForm : this.editForms.get(this.selectedWaypointIndex);
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        IGuiEventListener focused = this.func_241217_q_();
        this.preType(focused);
        boolean result = super.func_231046_a_(par1, par2, par3);
        this.postType(focused);
        if (focused instanceof TextFieldWidget && this.canConfirm() && (par1 == 257 || par1 == 335)) {
            ((Widget)this.field_230710_m_.get(0)).func_230982_a_(0.0, 0.0);
        }
        return result;
    }

    public boolean func_231042_a_(char par1, int par2) {
        IGuiEventListener focused = this.func_241217_q_();
        this.preType(focused);
        boolean result = super.func_231042_a_(par1, par2);
        this.postType(focused);
        return result;
    }

    private void preType(IGuiEventListener focused) {
        if (focused == null) {
            return;
        }
    }

    private void postType(IGuiEventListener focused) {
        if (focused == null) {
            return;
        }
        if (this.nameTextField == focused) {
            if (!(this.getCurrent().initial.length() != 0 || this.nameTextField.func_146179_b().length() <= 0 || this.getCurrent().keepInitial && this.modMain.getSettings().waypointsMutualEdit)) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1));
            }
        } else if (this.yawTextField == focused) {
            this.fieldValidator.validate(this.yawTextField);
            this.getCurrent().keepYawText = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.field_230693_o_ = true;
            }
        }
        this.checkFields();
        this.updateConfirmButton();
    }

    public void func_231035_a_(IGuiEventListener l) {
        this.preType(l);
        IGuiEventListener currentFocused = this.func_241217_q_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).func_146195_b(false);
        }
        super.func_231035_a_(l);
    }

    private boolean canConfirm() {
        WaypointEditForm current = this.getCurrent();
        return !(!current.keepName && current.name.length() <= 0 || !current.keepInitial && current.initial.length() <= 0 || !current.keepXText && current.xText.length() <= 0 || !current.keepYText && current.yText.length() <= 0 || !current.keepZText && current.zText.length() <= 0);
    }

    private void updateConfirmButton() {
        ((Button)this.field_230710_m_.get((int)0)).field_230693_o_ = this.modeSwitchButton.field_230693_o_ = this.canConfirm();
        this.leftButton.field_230693_o_ = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex > 0;
        this.rightButton.field_230693_o_ = !this.modMain.getSettings().waypointsMutualEdit && this.canConfirm() && this.selectedWaypointIndex < this.editForms.size() - 1;
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        WaypointEditForm current = this.getCurrent();
        current.name = this.nameTextField.func_146179_b();
        current.xText = this.xTextField.func_146179_b();
        current.yText = this.yTextField.func_146179_b();
        current.zText = this.zTextField.func_146179_b();
        current.yawText = this.yawTextField.func_146179_b();
        current.initial = this.initialTextField.func_146179_b();
        current.initial = current.initial.toUpperCase();
        if (current.initial.length() > 2) {
            current.initial = current.initial.substring(0, 2);
            this.initialTextField.func_146180_a(current.initial);
        }
        if (current.yawText.length() > 4) {
            current.yawText = current.yawText.substring(0, 4);
            this.yawTextField.func_146180_a(current.yawText);
        }
        if (this.prefilled && this.editForms.size() > 1 && this.modMain.getSettings().waypointsMutualEdit) {
            current.keepName = current.name.isEmpty();
            current.keepXText = current.xText.isEmpty();
            current.keepYText = current.yText.isEmpty();
            current.keepZText = current.zText.isEmpty();
            current.keepInitial = current.initial.isEmpty();
        }
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        return super.func_231044_a_(par1, par2, par3);
    }

    public boolean func_231048_c_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_230709_l_);
        }
        return super.func_231048_c_(par1, par2, par3);
    }

    private void setFieldText(TextFieldWidget field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void func_231023_e_() {
        if (this.field_230706_i_.field_71439_g == null) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.func_230446_a_(matrixStack);
        this.func_238471_a_(matrixStack, this.field_230712_o_, this.screenTitle, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        WaypointEditForm current = this.getCurrent();
        if (!this.nameTextField.func_230999_j_() && current.keepName) {
            this.setFieldText(this.nameTextField, this.namePlaceholder);
        }
        if (!this.xTextField.func_230999_j_()) {
            if (current.keepXText) {
                this.setFieldText(this.xTextField, this.xPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yTextField.func_230999_j_() && current.keepYText) {
            this.setFieldText(this.yTextField, this.yPlaceholder);
        }
        if (!this.zTextField.func_230999_j_()) {
            if (current.keepZText) {
                this.setFieldText(this.zTextField, this.zPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yawTextField.func_230999_j_() && this.getCurrent().yawText.isEmpty()) {
            if (current.keepYawText) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                this.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
        }
        if (!this.initialTextField.func_230999_j_() && this.getCurrent().initial.isEmpty()) {
            if (current.keepInitial) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                this.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
        }
        this.nameTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.xTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.yTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.zTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.yawTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.initialTextField.func_230430_a_(matrixStack, par1, par2, par3);
        this.setFieldText(this.nameTextField, this.getCurrent().name);
        this.setFieldText(this.xTextField, this.getCurrent().xText);
        this.setFieldText(this.yTextField, this.getCurrent().yText);
        this.setFieldText(this.zTextField, this.getCurrent().zText);
        this.setFieldText(this.yawTextField, this.getCurrent().yawText);
        this.setFieldText(this.initialTextField, this.getCurrent().initial);
        if (this.dropped) {
            super.func_230430_a_(matrixStack, 0, 0, par3);
        } else {
            super.func_230430_a_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(matrixStack, par1, par2, this.field_230709_l_);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(matrixStack, par1, par2, this.field_230709_l_);
        }
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_230709_l_)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_230709_l_);
                return true;
            }
        }
        return super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, wheel);
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.getCurrent().color = this.colorDD.size() > ModSettings.ENCHANT_COLORS.length ? selected : selected + 1;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_230708_k_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.field_230708_k_ / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_230708_k_ / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
        return true;
    }
}

