/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.misc.Misc;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiDotColors
extends Screen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private Screen parentGuiScreen;
    private ArrayList<GuiDropDown> dropDowns;
    private String[] colorOptions;
    private int mobsColor;
    private int hostileColor;
    private int itemsColor;
    private int otherColor;
    private int playerOption;
    private int teamOption;
    private GuiDropDown mobsColorDD;
    private GuiDropDown hostileColorDD;
    private GuiDropDown itemsColorDD;
    private GuiDropDown otherColorDD;
    private GuiDropDown playerOptionDD;
    private GuiDropDown teamOptionDD;
    private boolean[] displaySettingsChanged;
    private boolean dropped;

    public GuiDotColors(IXaeroMinimap modMain, Screen par1GuiScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_entity_radar"));
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.dropDowns = new ArrayList();
        this.displaySettingsChanged = new boolean[6];
        this.colorOptions = this.createColorOptions();
        this.mobsColor = modMain.getSettings().mobsColor;
        this.hostileColor = modMain.getSettings().hostileColor;
        this.itemsColor = modMain.getSettings().itemsColor;
        this.otherColor = modMain.getSettings().otherColor;
        this.playerOption = modMain.getSettings().playersColor != -1 ? modMain.getSettings().playersColor : this.colorOptions.length;
        this.teamOption = modMain.getSettings().otherTeamColor != -1 ? modMain.getSettings().otherTeamColor + 1 : 0;
    }

    private String getButtonText(ModOptions par1EnumOptions) {
        String s = "";
        int id = this.settingIdForEnum(par1EnumOptions);
        boolean changed = this.displaySettingsChanged[id];
        boolean currentClientSetting = this.modMain.getSettings().getClientBooleanValue(par1EnumOptions);
        boolean clientSetting = changed ? !currentClientSetting : currentClientSetting;
        boolean serverSetting = this.modMain.getSettings().getBooleanValue(par1EnumOptions);
        s = s + ModSettings.getTranslation(clientSetting) + (serverSetting != currentClientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
        return s;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new MySmallButton(200, this.field_230708_k_ / 2 - 155, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm", new Object[0]), b -> {
            this.modMain.getSettings().mobsColor = this.mobsColor;
            this.modMain.getSettings().hostileColor = this.hostileColor;
            this.modMain.getSettings().itemsColor = this.itemsColor;
            this.modMain.getSettings().otherColor = this.otherColor;
            this.modMain.getSettings().playersColor = this.playerOption < this.colorOptions.length ? this.playerOption : -1;
            this.modMain.getSettings().otherTeamColor = this.teamOption > 0 ? this.teamOption - 1 : -1;
            for (int opt = 0; opt < this.displaySettingsChanged.length; ++opt) {
                if (!this.displaySettingsChanged[opt]) continue;
                this.modMain.getSettings().setOptionValue(this.settingEnumForId(opt));
            }
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.field_230706_i_.func_147108_a(this.parentGuiScreen);
        }));
        this.func_230480_a_((Widget)new MySmallButton(201, this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, (ITextComponent)new TranslationTextComponent("gui.xaero_cancel", new Object[0]), b -> this.field_230706_i_.func_147108_a(this.parentGuiScreen)));
        this.dropDowns.clear();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        this.mobsColorDD = new GuiDropDown(this.colorOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 70, 120, this.mobsColor, this);
        this.dropDowns.add(this.mobsColorDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 66, ModOptions.MOBS, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.MOBS)), b -> this.onSettingClicked(b)));
        this.hostileColorDD = new GuiDropDown(this.colorOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 95, 120, this.hostileColor, this);
        this.dropDowns.add(this.hostileColorDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 91, ModOptions.HOSTILE, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.HOSTILE)), b -> this.onSettingClicked(b)));
        this.itemsColorDD = new GuiDropDown(this.colorOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 120, 120, this.itemsColor, this);
        this.dropDowns.add(this.itemsColorDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 116, ModOptions.ITEMS, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.ITEMS)), b -> this.onSettingClicked(b)));
        this.otherColorDD = new GuiDropDown(this.colorOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 145, 120, this.otherColor, this);
        this.dropDowns.add(this.otherColorDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 141, ModOptions.ENTITIES, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.ENTITIES)), b -> this.onSettingClicked(b)));
        this.playerOptionDD = new GuiDropDown(playerOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 20, 120, this.playerOption, this);
        this.dropDowns.add(this.playerOptionDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 16, ModOptions.PLAYERS, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.PLAYERS)), b -> this.onSettingClicked(b)));
        this.teamOptionDD = new GuiDropDown(teamOptions, this.field_230708_k_ / 2 - 60, this.field_230709_l_ / 7 + 45, 120, this.teamOption, this);
        this.dropDowns.add(this.teamOptionDD);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 63, this.field_230709_l_ / 7 + 41, ModOptions.DISPLAY_OTHER_TEAM, (ITextComponent)new StringTextComponent(this.getButtonText(ModOptions.DISPLAY_OTHER_TEAM)), b -> this.onSettingClicked(b)));
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    private ModOptions settingEnumForId(int opt) {
        switch (opt) {
            case 0: {
                return ModOptions.PLAYERS;
            }
            case 1: {
                return ModOptions.DISPLAY_OTHER_TEAM;
            }
            case 2: {
                return ModOptions.MOBS;
            }
            case 3: {
                return ModOptions.HOSTILE;
            }
            case 4: {
                return ModOptions.ITEMS;
            }
        }
        return ModOptions.ENTITIES;
    }

    private int settingIdForEnum(ModOptions opt) {
        if (opt == ModOptions.PLAYERS) {
            return 0;
        }
        if (opt == ModOptions.DISPLAY_OTHER_TEAM) {
            return 1;
        }
        if (opt == ModOptions.MOBS) {
            return 2;
        }
        if (opt == ModOptions.HOSTILE) {
            return 3;
        }
        if (opt == ModOptions.ITEMS) {
            return 4;
        }
        return 5;
    }

    private void onSettingClicked(Button par1GuiButton) {
        boolean changed = this.displaySettingsChanged[this.settingIdForEnum(((MyTinyButton)par1GuiButton).returnModOptions())];
        this.displaySettingsChanged[this.settingIdForEnum((ModOptions)((MyTinyButton)par1GuiButton).returnModOptions())] = !changed;
        par1GuiButton.func_238482_a_((ITextComponent)new StringTextComponent(this.getButtonText(((MyTinyButton)par1GuiButton).returnModOptions())));
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        return super.func_231044_a_(par1, par2, par3);
    }

    public boolean func_231048_c_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_230709_l_);
        }
        return super.func_231048_c_(par1, par2, par3);
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        int k;
        this.func_230446_a_(matrixStack);
        this.func_238472_a_(matrixStack, this.field_230712_o_, (ITextProperties)this.field_230704_d_, this.field_230708_k_ / 2, 20, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_players", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 10, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_other_teams", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 35, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_mobs", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 60, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_hostile", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 85, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_items", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 110, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_other", (Object[])new Object[0]) + ":", this.field_230708_k_ / 2, this.field_230709_l_ / 7 + 135, 0xFFFFFF);
        if (this.dropped) {
            super.func_230430_a_(matrixStack, 0, 0, par3);
        } else {
            super.func_230430_a_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(matrixStack, par1, par2, this.field_230709_l_);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(matrixStack, par1, par2, this.field_230709_l_);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_230709_l_)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_230709_l_);
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, wheel);
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        if (menu == this.mobsColorDD) {
            this.mobsColor = selected;
        } else if (menu == this.hostileColorDD) {
            this.hostileColor = selected;
        } else if (menu == this.itemsColorDD) {
            this.itemsColor = selected;
        } else if (menu == this.otherColorDD) {
            this.otherColor = selected;
        } else if (menu == this.playerOptionDD) {
            this.playerOption = selected;
        } else if (menu == this.teamOptionDD) {
            this.teamOption = selected;
        }
        return true;
    }
}

