/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.api.spigot.ServerWaypoint;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.KeySortableByOther;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.Misc;

public class GuiWaypoints
extends Screen
implements IDropDownCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static boolean distanceDivided;
    private Screen parentScreen;
    private List list;
    private WaypointWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private ArrayList<GuiDropDown> dropDowns;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private WaypointsManager waypointsManager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean dropped;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final String frozenAutoContainerID;
    private final String frozenAutoWorldID;

    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_waypoints"));
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.waypointsManager = minimapSession.getWaypointsManager();
        this.parentScreen = par1GuiScreen;
        this.selectedListSet = new ConcurrentSkipListSet();
        this.dropDowns = new ArrayList();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoContainerID = this.waypointsManager.getAutoContainerID();
        this.frozenAutoWorldID = this.waypointsManager.getAutoWorldID();
        this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
        String currentContainer = this.displayedWorld.getContainer().getRootContainer().getKey();
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer, this.frozenAutoContainerID);
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
        this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.updateSortedList();
        this.list = new List();
        this.sets = new GuiWaypointSets(true, this.displayedWorld);
        this.field_230705_e_.add(this.list);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 129, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_delete", new Object[0]), b -> {
            if (!this.selectedListSet.isEmpty()) {
                Waypoint w;
                this.undrag();
                boolean shouldRestore = true;
                for (int i : this.selectedListSet) {
                    w = this.list.getWaypoint(i);
                    if (w instanceof ServerWaypoint) continue;
                    if (!w.isTemporary()) {
                        shouldRestore = false;
                    }
                    w.setTemporary(true);
                }
                if (shouldRestore) {
                    for (int i : this.selectedListSet) {
                        w = this.list.getWaypoint(i);
                        if (w instanceof ServerWaypoint) continue;
                        w.setTemporary(false);
                    }
                }
                try {
                    this.modMain.getSettings().saveWaypoints(this.displayedWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 29, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done", new Object[0]), b -> this.field_230706_i_.func_147108_a(this.parentScreen)));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 203, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_add_edit", new Object[0]), b -> {
            ArrayList selectedWaypoints = this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.field_230706_i_.func_147108_a((Screen)new GuiAddWaypoint(this.modMain, this.waypointsManager, this, selectedWaypoints, this.displayedWorld.getContainer().getRootContainer().getKey(), this.displayedWorld, selectedWaypoints.isEmpty()));
            this.list.func_241215_a_((List.WaypointEntry)null);
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 120, this.field_230709_l_ - 53, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)"), b -> {
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, this);
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 46, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_disable_enable", new Object[0]), b -> {
            ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList();
            if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                for (Waypoint selected : selectedWaypoints) {
                    this.displayedWorld.getCurrentSet().getList().remove(selected);
                }
                this.selectedListSet.clear();
            } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(false);
                }
            } else {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(true);
                }
            }
            this.updateSortedList();
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 130, 32, (ITextComponent)new TranslationTextComponent("gui.xaero_clear", new Object[0]), b -> {
            String[] worldKeys = this.worlds.getCurrentKeys();
            String name = this.sets.getOptions()[this.sets.getCurrentSet()];
            if (this.shouldDeleteSet()) {
                this.field_230706_i_.func_147108_a((Screen)new GuiDeleteSet(I18n.func_135052_a((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.modMain, this.minimapSession));
            } else {
                this.field_230706_i_.func_147108_a((Screen)new GuiClearSet(I18n.func_135052_a((String)name, (Object[])new Object[0]), worldKeys[0], worldKeys[1], name, this, this.modMain, this.minimapSession));
            }
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 203, 32, (ITextComponent)new TranslationTextComponent("gui.xaero_options", new Object[0]), b -> this.field_230706_i_.func_147108_a((Screen)new GuiWaypointsOptions(this.modMain, this.minimapSession, this, this.displayedWorld, this.frozenAutoContainerID, this.frozenAutoWorldID))));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 37, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_share", new Object[0]), b -> {
            Waypoint selected;
            Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
            if (selected != null) {
                this.minimapSession.getWaypointSharing().shareWaypoint(this, selected, this.displayedWorld);
            }
        }));
        this.dropDowns.clear();
        this.containersDD = new GuiDropDown(this.containers.options, this.field_230708_k_ / 2 - 202, 17, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_230708_k_ / 2 + 2, 17, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_230708_k_ / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint(i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentSet().getList().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    public boolean func_231044_a_(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_230709_l_)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_230709_l_);
                return true;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return true;
        }
        if (par3 == 0) {
            if (par2 >= 58.0 && par2 < (double)(this.field_230709_l_ - 61) && this.displayedWorld.getContainer().getRootContainer().getSortType() == WaypointsSort.NONE) {
                this.draggingFromX = (int)par1;
                this.draggingFromY = (int)par2;
                this.draggingFromSlot = this.list.getEntryAt(par1, par2);
                if (this.draggingFromSlot >= this.displayedWorld.getCurrentSet().getList().size()) {
                    this.draggingFromSlot = -1;
                }
            }
        } else {
            this.list.func_241215_a_((List.WaypointEntry)null);
        }
        if (this.list.func_231044_a_(par1, par2, par3)) {
            return true;
        }
        return super.func_231044_a_(par1, par2, par3);
    }

    public boolean func_231048_c_(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.undrag();
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_230709_l_);
        }
        if (this.list.func_231048_c_(par1, par2, par3)) {
            return true;
        }
        return super.func_231048_c_(par1, par2, par3);
    }

    public boolean func_231045_a_(double par1, double par2, int par3, double par4, double par5) {
        return this.list.func_231045_a_(par1, par2, par3, par4, par5);
    }

    public boolean func_231043_a_(double par1, double par2, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_230709_l_)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_230709_l_);
                return true;
            }
        }
        return this.list.func_231043_a_(par1, par2, wheel);
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (!((Widget)this.field_230710_m_.get((int)4)).field_230693_o_) break;
                for (int i : this.selectedListSet) {
                    this.list.getWaypoint(i).setTemporary(true);
                }
                ((Widget)this.field_230710_m_.get(4)).func_230982_a_(0.0, 0.0);
                break;
            }
            case 84: {
                if (!((Widget)this.field_230710_m_.get((int)3)).field_230693_o_) break;
                ((Widget)this.field_230710_m_.get(3)).func_230982_a_(0.0, 0.0);
            }
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        int k;
        if (this.field_230706_i_.field_71439_g == null) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        this.updateButtons();
        this.list.func_230430_a_(matrixStack, par1, par2, par3);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_world_server", (Object[])new Object[0]), this.field_230708_k_ / 2 - 102, 5, 0xFFFFFF);
        this.func_238471_a_(matrixStack, this.field_230712_o_, I18n.func_135052_a((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), this.field_230708_k_ / 2 + 102, 5, 0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(par1 - this.draggingFromX, 2.0) + Math.pow(par2 - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentSet().getList().size() - 1, this.list.getEntryAt(par1, par2));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentSet().getList().get(this.draggingFromSlot);
                this.list.func_241215_a_((List.WaypointEntry)null);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentSet().getList().set(i, this.displayedWorld.getCurrentSet().getList().get(i + direction));
                }
                this.displayedWorld.getCurrentSet().getList().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
            }
            int fromCenter = this.draggingFromX - this.list.getWidth() / 2;
            this.list.drawWaypointSlot(matrixStack, this.draggingWaypoint, par1 - 108 - fromCenter, par2 - this.list.getItemHeight() / 4);
        }
        if (this.dropped) {
            super.func_230430_a_(matrixStack, 0, 0, par3);
        } else {
            super.func_230430_a_(matrixStack, par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(matrixStack, par1, par2, this.field_230709_l_);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(matrixStack, par1, par2, this.field_230709_l_);
        }
    }

    private void updateButtons() {
        ((Button)this.field_230710_m_.get((int)4)).field_230693_o_ = !this.selectedListSet.isEmpty();
        ((Button)this.field_230710_m_.get((int)0)).field_230693_o_ = ((Button)this.field_230710_m_.get((int)4)).field_230693_o_;
        ((Button)this.field_230710_m_.get((int)7)).field_230693_o_ = this.selectedListSet.size() == 1;
        ((Button)this.field_230710_m_.get((int)3)).field_230693_o_ = this.selectedListSet.size() == 1 && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        ((Button)this.field_230710_m_.get((int)2)).field_230693_o_ = this.selectedListSet.isEmpty() && this.field_230706_i_.field_71439_g != null || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
        ((Button)this.field_230710_m_.get(5)).func_238482_a_((ITextComponent)new TranslationTextComponent(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear", new Object[0]));
        if (!this.selectedListSet.isEmpty() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            ((Button)this.field_230710_m_.get(4)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_delete"));
            ((Button)this.field_230710_m_.get(0)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_restore"));
        } else {
            ((Button)this.field_230710_m_.get(0)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_delete"));
            String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            ((Button)this.field_230710_m_.get(4)).func_238482_a_((ITextComponent)new StringTextComponent(enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1]));
        }
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld();
                    this.waypointsManager.setCustomContainerID(firstWorld.getContainer().getKey());
                    this.waypointsManager.setCustomWorldID(firstWorld.getId());
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId(), this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.worldsDD = new GuiDropDown(this.worlds.options, this.field_230708_k_ / 2 + 2, 17, 200, this.worlds.current, this);
                this.dropDowns.set(1, this.worldsDD);
            } else if (menu == this.worldsDD) {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    String[] keys = this.worlds.getCurrentKeys();
                    this.waypointsManager.setCustomContainerID(keys[0]);
                    this.waypointsManager.setCustomWorldID(keys[1]);
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld(this.frozenAutoContainerID, this.frozenAutoWorldID);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.updateWaypoints();
            this.list.func_241215_a_((List.WaypointEntry)null);
            this.sets = new GuiWaypointSets(true, this.displayedWorld);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_230708_k_ / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
            this.dropDowns.set(2, this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            if (selectedIndex == menu.size() - 1) {
                System.out.println("New waypoint set gui");
                this.field_230706_i_.func_147108_a((Screen)new GuiNewSet(this.modMain, this.minimapSession, this, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrent(this.sets.getCurrentSetKey());
            this.updateSortedList();
            this.waypointsManager.updateWaypoints();
            this.list.func_241215_a_((List.WaypointEntry)null);
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getContainer().getRootContainer().getSortType();
        if (sortType == WaypointsSort.NONE) {
            this.waypointsSorted = this.displayedWorld.getCurrentSet().getList();
            return;
        }
        distanceDivided = this.waypointsManager.divideBy8(this.displayedWorld.getContainer().getKey());
        ArrayList<KeySortableByOther<Waypoint>> sortableKeys = new ArrayList<KeySortableByOther<Waypoint>>();
        for (Waypoint waypoint : this.displayedWorld.getCurrentSet().getList()) {
            sortableKeys.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{sortType == WaypointsSort.NAME ? waypoint.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? waypoint.getSymbol() : Double.valueOf(waypoint.getComparisonDistance(this.field_230706_i_.func_175606_aa(), distanceDivided)))}));
        }
        Collections.sort(sortableKeys);
        this.waypointsSorted = new ArrayList();
        for (KeySortableByOther keySortableByOther : sortableKeys) {
            this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
        }
        if (this.displayedWorld.getContainer().getRootContainer().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    class List
    extends ExtendedList<WaypointEntry> {
        private int createdCount;

        public List() {
            super(GuiWaypoints.this.field_230706_i_, GuiWaypoints.this.field_230708_k_, GuiWaypoints.this.field_230709_l_, 58, Math.max(62, GuiWaypoints.this.field_230709_l_ - 61), 18);
            this.createEntries(this.getWaypointCount());
        }

        protected int getWaypointCount() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size();
            if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null) {
                size += GuiWaypoints.this.waypointsManager.getServerWaypoints().size();
            }
            return size;
        }

        private Waypoint getWaypoint(int slotIndex) {
            int serverWPIndex;
            Waypoint waypoint = null;
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) {
                waypoint = (Waypoint)GuiWaypoints.this.waypointsSorted.get(slotIndex);
            } else if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null && (serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) < GuiWaypoints.this.waypointsManager.getServerWaypoints().size()) {
                waypoint = GuiWaypoints.this.waypointsManager.getServerWaypoints().get(serverWPIndex);
            }
            return waypoint;
        }

        protected boolean func_230957_f_(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected void func_230433_a_(MatrixStack matrixStack) {
            GuiWaypoints.this.func_230446_a_(matrixStack);
        }

        private void createEntries(int count) {
            this.func_230963_j_();
            this.createdCount = count;
            for (int i = 0; i < count; ++i) {
                WaypointEntry entry = new WaypointEntry(i);
                this.func_230513_b_((AbstractList.AbstractListEntry)entry);
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
            int currentCount = this.getWaypointCount();
            if (currentCount != this.createdCount) {
                this.createEntries(currentCount);
                this.func_230932_a_(this.func_230966_l_());
            }
            super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        }

        public boolean func_230971_aw__() {
            if (GuiWaypoints.this.dropped || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return super.func_230971_aw__();
        }

        public void func_241215_a_(WaypointEntry e) {
            if (e == null) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            Waypoint waypoint = this.getWaypoint(e.index);
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = Screen.func_231173_s_();
            if ((currentSize > 1 || currentSize == 1 && (Integer)GuiWaypoints.this.selectedListSet.first() != e.index) && !Screen.func_231172_r_() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = e.index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != e.index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(e.index)) {
                GuiWaypoints.this.selectedListSet.remove(e.index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = e.index;
                GuiWaypoints.this.selectedListSet.add(e.index);
            }
            String narration = "";
            if (waypoint != null) {
                narration = narration + I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{waypoint.getName()}) + (waypoint.isDisabled() ? " " + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : "") + (waypoint.isTemporary() ? " " + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : "") + ", ";
            }
            if (GuiWaypoints.this.selectedListSet.size() != 1) {
                narration = narration + I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{I18n.func_135052_a((String)"gui.xaero_waypoints", (Object[])new Object[0]) + " " + GuiWaypoints.this.selectedListSet.size()});
            }
            NarratorChatListener.field_193643_a.func_216864_a(narration);
            super.func_241215_a_((AbstractList.AbstractListEntry)(GuiWaypoints.this.selectedListSet.isEmpty() ? null : e));
        }

        public int getItemHeight() {
            return this.field_230669_c_;
        }

        public void drawWaypointSlot(MatrixStack matrixStack, Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            GuiWaypoints.this.func_238471_a_(matrixStack, GuiWaypoints.this.field_230712_o_, w.getLocalizedName() + (w.isDisabled() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : "")), p_180791_2_ + 110, p_180791_3_ + 1, 0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                GuiWaypoints.this.func_238471_a_(matrixStack, GuiWaypoints.this.field_230712_o_, "*", rectX - 25, rectY - 3, 0xFFFFFF);
            }
            GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(matrixStack, w, GuiWaypoints.this.modMain.getSettings(), rectX, rectY);
        }

        public int getEntryAt(double x, double y) {
            WaypointEntry entry = (WaypointEntry)this.func_230933_a_(x, y);
            return entry == null ? -1 : entry.index;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class WaypointEntry
        extends ExtendedList.AbstractListEntry<WaypointEntry> {
            private int index;

            public WaypointEntry(int index) {
                this.index = index;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                Waypoint w = List.this.getWaypoint(index);
                if (w == GuiWaypoints.this.draggingWaypoint) {
                    return;
                }
                List.this.drawWaypointSlot(matrixStack, w, p_render_3_, p_render_2_);
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    List.this.func_241215_a_(this);
                    return true;
                }
                return false;
            }
        }
    }
}

