/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.minimap.MinimapInterfaceInstance;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.settings.ModOptions;

public class MinimapInterface
extends Interface {
    private IXaeroMinimap modMain;
    private Minecraft mc = Minecraft.func_71410_x();
    private WaypointsGuiRenderer waypointsGuiRenderer;
    private WaypointsIngameRenderer waypointsIngameRenderer;
    private MinimapFBORenderer minimapFBORenderer;
    private Throwable crashedWith;
    private MinimapSafeModeRenderer minimapSafeModeRenderer;
    protected final int[] minimapSizes;
    protected final int[] bufferSizes;

    public MinimapInterface(IXaeroMinimap modMain, int id, InterfaceManager interfaces) throws IOException {
        super(interfaces, "gui.xaero_minimap", id, 128, 128, ModOptions.MINIMAP);
        this.modMain = modMain;
        this.minimapSizes = new int[]{114, 170, 226, 338};
        this.bufferSizes = new int[]{128, 256, 256, 512};
        this.waypointsGuiRenderer = new WaypointsGuiRenderer(modMain, this.mc);
        this.waypointsIngameRenderer = new WaypointsIngameRenderer(modMain, this.mc);
        this.minimapFBORenderer = new MinimapFBORenderer(modMain, this.mc, this.waypointsGuiRenderer, this);
        this.minimapSafeModeRenderer = new MinimapSafeModeRenderer(modMain, this.mc, this.waypointsGuiRenderer, this);
    }

    public Throwable getCrashedWith() {
        return this.crashedWith;
    }

    public void setCrashedWith(Throwable crashedWith) {
        if (this.crashedWith == null) {
            this.crashedWith = crashedWith;
        }
    }

    public void checkCrashes() {
        if (this.crashedWith != null) {
            Throwable crash = this.crashedWith;
            this.crashedWith = null;
            throw new RuntimeException("Xaero's Minimap has crashed! Please contact the author at planetminecraft.com/member/xaero96 or minecraftforum.net/members/xaero96", crash);
        }
    }

    @Override
    public InterfaceInstance createInterfaceInstance(XaeroMinimapSession minimapSession) {
        return new MinimapInterfaceInstance(this, this.modMain, minimapSession);
    }

    public WaypointsGuiRenderer getWaypointsGuiRenderer() {
        return this.waypointsGuiRenderer;
    }

    public WaypointsIngameRenderer getWaypointsIngameRenderer() {
        return this.waypointsIngameRenderer;
    }

    public MinimapFBORenderer getMinimapFBORenderer() {
        return this.minimapFBORenderer;
    }

    public MinimapSafeModeRenderer getMinimapSafeModeRenderer() {
        return this.minimapSafeModeRenderer;
    }

    public boolean usingFBO() {
        return this.getMinimapFBORenderer().isLoadedFBO() && !this.modMain.getSettings().mapSafeMode;
    }
}

