/*
 * Decompiled with CFR 0.152.
 */
package xaero.patreon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.util.ResourceLocation;
import xaero.patreon.PatreonMod2;

public class Patreon4 {
    public static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    public static boolean loaded = false;
    public static boolean showCapes = true;
    public static int patronPledge = -1;
    public static String updateLocation;
    public static HashMap<String, PatreonMod2> mods;
    private static ArrayList<PatreonMod2> outdatedMods;
    public static File optionsFile;
    public static String rendersCapes;
    private static ResourceLocation cape1;
    private static ResourceLocation cape2;
    private static ResourceLocation cape3;
    private static ResourceLocation cape4;
    private static boolean pauseCapes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon4.loadSettings();
            String s = "http://data.chocolateminecraft.com/Versions/Patreon.txt";
            s = s.replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL(s);
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(900);
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_148256_e().getName())) continue;
                    patronPledge = pledge;
                }
                if (pledge >= 5) {
                    updateLocation = reader.readLine();
                    while ((line = reader.readLine()) != null) {
                        args = line.split("\\t");
                        mods.put(args[0], new PatreonMod2(args[0], args[1], args[2], args[3]));
                    }
                }
                reader.close();
                loaded = true;
            }
            catch (Exception e) {
                patrons.clear();
                mods.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(PatreonMod2 mod) {
        ArrayList<PatreonMod2> arrayList = Patreon4.getOutdatedMods();
        synchronized (arrayList) {
            Patreon4.getOutdatedMods().add(mod);
        }
    }

    public static int getPatronPledge(String name) {
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + showCapes);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadSettings() {
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon4.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                showCapes = args[1].equals("true");
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ResourceLocation getPlayerCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            ResourceLocation cape = null;
            int pledge = Patreon4.getPatronPledge(playerEntity.func_200200_C_().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon4.getPatronPledge(playerEntity.func_200200_C_().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static ArrayList<PatreonMod2> getOutdatedMods() {
        return outdatedMods;
    }

    static {
        mods = new HashMap();
        outdatedMods = new ArrayList();
        optionsFile = new File("./config/xaeropatreon.txt");
        rendersCapes = null;
        cape1 = new ResourceLocation("xaeropatreon", "capes/cape1.png");
        cape2 = new ResourceLocation("xaeropatreon", "capes/cape2.png");
        cape3 = new ResourceLocation("xaeropatreon", "capes/cape3.png");
        cape4 = new ResourceLocation("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
    }
}

