function clientPacketRedirectTransform(methodNode, methodInsnNode){
	var Opcodes=Java.type('org.objectweb.asm.Opcodes')
	var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
	var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
	var instructions = methodNode.instructions
	var patchList = new InsnList()
	patchList.add(new VarInsnNode(Opcodes.ALOAD, 1))
	//INVOKESTATIC xaero/common/core/LaunchPlugin.chunkUpdateCallback (Lnet/minecraft/client/renderer/chunk/ChunkRenderDispatcher$ChunkRender;)V
	patchList.add(methodInsnNode)
	for(var i = 0; i < instructions.size(); i++) {
		var insn = instructions.get(i);
		if(insn.getOpcode() == Opcodes.INVOKESTATIC) {
			if(insn.owner.equals("net/minecraft/network/PacketThreadUtil") && (insn.name.equals("checkThreadAndEnqueue") || insn.name.equals("func_218797_a"))) {
				instructions.insert(insn, patchList);
				break;
			}
		}
	}
}

function addGetter(classNode, fieldName, fieldDesc){
	var Opcodes=Java.type('org.objectweb.asm.Opcodes')
	var MethodNode=Java.type('org.objectweb.asm.tree.MethodNode')
	var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
	var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
	var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode')
	var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
	var LocalVariableNode=Java.type('org.objectweb.asm.tree.LocalVariableNode')
	
	var methods = classNode.methods
	var getterNode = new MethodNode(Opcodes.ACC_PUBLIC, "get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "()" + fieldDesc, null, null)
	var labelNode1 = new LabelNode()
	var labelNode2 = new LabelNode()
	var instructions = getterNode.instructions
	instructions.add(labelNode1)
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 0))
	instructions.add(new FieldInsnNode(Opcodes.GETFIELD, classNode.name, fieldName, fieldDesc))
	instructions.add(new InsnNode(Opcodes.ARETURN))
	instructions.add(labelNode2)
	getterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0))
	getterNode.maxStack = 1
	getterNode.maxLocals = 1
	methods.add(getterNode)
}

function addSetter(classNode, fieldName, fieldDesc){
	var Opcodes=Java.type('org.objectweb.asm.Opcodes')
	var MethodNode=Java.type('org.objectweb.asm.tree.MethodNode')
	var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
	var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
	var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode')
	var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
	var LocalVariableNode=Java.type('org.objectweb.asm.tree.LocalVariableNode')
	
	var methods = classNode.methods
	var setterNode = new MethodNode(Opcodes.ACC_PUBLIC, "set" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "(" + fieldDesc +  ")V", null, null)
	var labelNode1 = new LabelNode()
	var labelNode2 = new LabelNode()
	var instructions = setterNode.instructions
	instructions.add(labelNode1)
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 0))
	instructions.add(new VarInsnNode(Opcodes.ALOAD, 1))
	instructions.add(new FieldInsnNode(Opcodes.PUTFIELD, classNode.name, fieldName, fieldDesc))
	instructions.add(new InsnNode(Opcodes.RETURN))
	instructions.add(labelNode2)
	setterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0))
	setterNode.localVariables.add(new LocalVariableNode("value", fieldDesc, null, labelNode1, labelNode2, 1))
	setterNode.maxStack = 2
	setterNode.maxLocals = 2
	methods.add(setterNode)
}

function initializeCoreMod() {
	return {
		'xaero_chunkclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.world.chunk.Chunk'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
                var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode')
                var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				fields.add(new FieldNode(Opcodes.ACC_PUBLIC, "xaero_chunkClean", "Z", null, 0))
				return classNode
			}
		},
		'xaero_clientplaynethandler_handleblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147234_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SChangeBlockPacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onBlockChange", "(Lnet/minecraft/network/play/server/SChangeBlockPacket;)V"))
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlemultiblockchange': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147287_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SMultiBlockChangePacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onMultiBlockChange", "(Lnet/minecraft/network/play/server/SMultiBlockChangePacket;)V"))
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlechunkdata': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_147263_a',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SChunkDataPacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onChunkData", "(Lnet/minecraft/network/play/server/SChunkDataPacket;)V"))
				return methodNode
			}
		},
		'xaero_clientplaynethandler_handlespawnpoint': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'func_230488_a_',
                'methodDesc' : '(Lnet/minecraft/network/play/server/SWorldSpawnChangedPacket;)V'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				clientPacketRedirectTransform(methodNode, new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onSpawn", "(Lnet/minecraft/network/play/server/SWorldSpawnChangedPacket;)V"))
				return methodNode
			}
		},
		'xaero_abstractclientplayerentity_getlocationcape': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.entity.player.AbstractClientPlayerEntity',
                'methodName': 'func_110303_q',
                'methodDesc' : '()Lnet/minecraft/util/ResourceLocation;'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
				var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
				var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
				var Label=Java.type('org.objectweb.asm.Label')
				var JumpInsnNode=Java.type('org.objectweb.asm.tree.JumpInsnNode')
				var MY_LABEL = new LabelNode(new Label())
				methodNode.maxStack += 1
				var insnToInsert = new InsnList()
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 0))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "xaero/common/core/XaeroMinimapCore", "getPlayerCape", "(Lnet/minecraft/client/entity/player/AbstractClientPlayerEntity;)Lnet/minecraft/util/ResourceLocation;"))
				insnToInsert.add(new InsnNode(Opcodes.DUP))
				insnToInsert.add(new JumpInsnNode(Opcodes.IFNULL, MY_LABEL))
				insnToInsert.add(new InsnNode(Opcodes.ARETURN))
				insnToInsert.add(MY_LABEL)
				insnToInsert.add(new InsnNode(Opcodes.POP))
				methodNode.instructions.insert(methodNode.instructions.get(0), insnToInsert)
				return methodNode
			}
		},
		'xaero_playerentity_iswearing': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.entity.player.PlayerEntity',
                'methodName': 'func_175148_a',
                'methodDesc' : '(Lnet/minecraft/entity/player/PlayerModelPart;)Z'
			},
			'transformer' : function(methodNode){
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
				var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode')
				var LabelNode=Java.type('org.objectweb.asm.tree.LabelNode')
				var Label=Java.type('org.objectweb.asm.Label')
				var JumpInsnNode=Java.type('org.objectweb.asm.tree.JumpInsnNode')
				var MY_LABEL = new LabelNode(new Label())
				var insnToInsert = new InsnList()
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 0))
				insnToInsert.add(new VarInsnNode(Opcodes.ALOAD, 1))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKESTATIC, "xaero/common/core/XaeroMinimapCore", "isWearing", "(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/entity/player/PlayerModelPart;)Ljava/lang/Boolean;"))
				insnToInsert.add(new InsnNode(Opcodes.DUP))
				insnToInsert.add(new JumpInsnNode(Opcodes.IFNULL, MY_LABEL))
				insnToInsert.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "java/lang/Boolean", "booleanValue", "()Z"))
				insnToInsert.add(new InsnNode(Opcodes.IRETURN))
				insnToInsert.add(MY_LABEL)
				insnToInsert.add(new InsnNode(Opcodes.POP))
				methodNode.instructions.insert(methodNode.instructions.get(0), insnToInsert)
				return methodNode
			}
		},
		'xaero_clientplaynethandlerclass': {
			'target' : {
				'type' : 'CLASS',
				'name' : 'net.minecraft.client.network.play.ClientPlayNetHandler'
			},
			'transformer' : function(classNode){
				var fields = classNode.fields
                var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode')
                var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				
				classNode.interfaces.add("xaero/common/core/IXaeroMinimapClientPlayNetHandler")
				fields.add(new FieldNode(Opcodes.ACC_PRIVATE, "xaero_minimapSession", "Lxaero/common/XaeroMinimapSession;", null, null))
				addGetter(classNode, "xaero_minimapSession", "Lxaero/common/XaeroMinimapSession;")
				addSetter(classNode, "xaero_minimapSession", "Lxaero/common/XaeroMinimapSession;")
				
				return classNode
			}
		},
		'xaero_clientplaynethandler_init': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': '<init>',
                'methodDesc' : '(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screen/Screen;Lnet/minecraft/network/NetworkManager;Lcom/mojang/authlib/GameProfile;)V'
			},
			'transformer' : function(methodNode){
				var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				for(var i = 0; i < methodNode.instructions.size(); i++){
					var insn = methodNode.instructions.get(i);
					if(insn.getOpcode() == Opcodes.RETURN){
						var patchList = new InsnList()
						patchList.add(new VarInsnNode(Opcodes.ALOAD, 0))
						patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', "onPlayNetHandler", "(Lnet/minecraft/client/network/play/ClientPlayNetHandler;)V"))
						methodNode.instructions.insertBefore(insn, patchList)
						break
					}
				}
				return methodNode
			}
		},
		'xaero_clientplaynethandler_cleanup': {
			'target' : {
                'type': 'METHOD',
                'class': 'net.minecraft.client.network.play.ClientPlayNetHandler',
                'methodName': 'cleanup',
                'methodDesc' : '()V'
			},
			'transformer' : function(methodNode){
				var Opcodes=Java.type('org.objectweb.asm.Opcodes')
				var InsnList=Java.type('org.objectweb.asm.tree.InsnList')
				var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode')
				var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode')
				var instructions = methodNode.instructions
				var patchList = new InsnList()
				patchList.add(new VarInsnNode(Opcodes.ALOAD, 0))
				patchList.add(new MethodInsnNode(Opcodes.INVOKESTATIC, 'xaero/common/core/XaeroMinimapCore', 
						"onPlayNetHandlerCleanup", "(Lnet/minecraft/client/network/play/ClientPlayNetHandler;)V"))
				instructions.insert(instructions.get(0), patchList)
				return methodNode
			}
		}
	}
}