/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _DEBUG_
#define _DEBUG_

/***************************************************************************
ShaderStage define variable numbering:
- gbuffers_shadow.fsh: -10
- gbuffers_opaque.fsh: -1
-       deferredX.fsh: X [0, 15]
- gbuffers_transl.vsh: 20
-      compositeX.fsh: 30 + X [30, 45]
-           final.fsh: 50

This is the primary debug file. It should be included near the top of any
shader program from which you would like to enable show() inside.

You must also include Exit.glsl, see that file for include instructions.

***************************************************************************/


//#define DEBUG
#define DEBUG_VIEW 0 // [-10 -1 0 20 30 31 32 38 39 40 50]

#if DynamicShaderStage < 0 && defined vsh
	// if in a gbuffer, set stuff up so we can receive show() data from
	// the vertex shader. Vertex shader should initialize show() to 0.
	out vec3 vDebug;
	#define Debug vDebug
#elif DynamicShaderStage < 0 && defined fsh
	// In in gbuffer, receive show() data from the vertex shader.
	in vec3 vDebug;
	vec3 Debug = vDebug;
#else
	// If not in a gbuffer, don't need to worry about vertex data.
	vec3 Debug = vec3(0.0);
#endif

void show( bool x) { Debug = vec3(float(x)); }
void show(float x) { Debug = vec3(x); }
void show( vec2 x) { Debug = vec3(x, 0.0); }
void show( vec3 x) { Debug = x; }
void show( vec4 x) { Debug = x.rgb; }


#ifndef DEBUG
	// this option will crash the game if you leave any show() in the code.
	// Helpful to find if you left any show()'s by accident.
//	#define CRASH_DANGLING_SHOW
#endif

#ifdef CRASH_DANGLING_SHOW
	#define show(x) DANGLING_SHOW
#else
	#define show(x) show(x);
#endif


#endif
