/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _PROJECTIONMATRICES_
#define _PROJECTIONMATRICES_

#ifdef FOV_OVERRIDE
    #if defined vsh
        out flat mat4 matProjection;
        out flat mat4 matProjectionInverse;

        out flat float adjustedFOV;

        #define projMatrix matProjection
        #define projInverseMatrix matProjectionInverse

        void CalculateProjectionMatrices() {
            float offset = FOV_TARGET - fov;

            adjustedFOV = fov + offset;

            matProjection = gbufferProjection;
            matProjectionInverse = gbufferProjectionInverse;

            matProjection[1].y = 1.0 / tan(radians(adjustedFOV) * 0.5);
            matProjection[0].x = matProjection[1].y * gbufferProjection[0].x / gbufferProjection[1].y;

            vec3 i = 1.0 / vec3(diagonal2(matProjection), matProjection[3].z);

            matProjectionInverse = mat4(
                i.x, 0.0, 0.0, 0.0,
                0.0, i.y, 0.0, 0.0,
                0.0, 0.0, 0.0, i.z,
                0.0, 0.0, -1.0, matProjection[2].z * i.z
            );
        }
    #elif defined fsh
        in flat mat4 matProjection;
        in flat mat4 matProjectionInverse;

        in flat float adjustedFOV;

        #define projMatrix matProjection
        #define projInverseMatrix matProjectionInverse
    #endif
#else
    #define CalculateProjectionMatrices()

    #define projMatrix gbufferProjection
    #define projInverseMatrix gbufferProjectionInverse

    #define adjustedFOV FOV_INITIAL
#endif

#endif
