/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _COLORCONVERSION_
    #define _COLORCONVERSION_

    //sRGB Conversions

    vec3 srgbToLinear(vec3 srgb) {
        const float a = 1.0 / 12.92;

        return mix(
            srgb * a,
            pow(0.947867 * srgb + 0.0521327, vec3(2.4)),
            step(0.04045, srgb)
        );
    }

    vec3 linearToSrgb(vec3 linear) {
        return mix(
            linear * 12.92,
            pow(linear, vec3(0.416666666667)) * 1.055 - 0.055,
            step(0.0031308, linear)
        );
    }

    //YUV Conversions

    vec3 fromYUV (vec3 yuv) {
        const vec2 c2 = vec2(1.8556,1.5748);
        const float c4 = 1. / .7152;
        const vec2 c5 = -vec2(.0722,.2126) * c4;
        const vec2 c1 = -.5* c2;

        vec2 br = yuv.yz * c2 + (c1 + yuv.x);
        return vec3(br.y, yuv.x * c4 + dot(c5, br), br.x);
    }

    vec3 toYUV (vec3 rgb) {
        const vec2 c2 = vec2(1.8556,1.5748);
        const vec3 c3 = vec3(.2126,.7152,.0722);
        const vec2 c6 = 1. / c2;

        float y = dot(rgb, c3);
        return vec3(y, (rgb.br - y) * c6 +.5);
    }

    vec3 hsv2rgb(vec3 c) {
        vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
        vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
        
        return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
    }

#endif
