/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _GLOBALILLUMINATION_
#define _GLOBALILLUMINATION_

vec3 CalculateGI(mat2x3 positions, vec3 normal, float dither, float skyLightMap, bool isFoliage){
    #ifdef RSM
    #endif

    #ifndef RSM 
        return vec3(0.0);
    #endif

    const int steps = RSM_QUALITY;
    const float rSteps = 1.0 / steps;

    vec3 shadowSpaceNormal = mat3(shadowModelView) * mat3(gbufferModelViewInverse) * normal;
         shadowSpaceNormal *= vec3(1.0, 1.0, -1.0);
    vec3 shadowPosition = WorldSpaceToShadowSpaceProj(positions[1]);

    vec3 totalGi = vec3(0.0);

    const float offsetSize = RSM_RADIUS * 4.0;
    const float pixelOffset = (1.0 / 2048.0) * offsetSize;

    const float falloffCompensation = 1.0 / offsetSize;
    
    for (int i = 0; i < steps; ++i) {
        vec2 offset = circlemapSq((float(i) + dither) * rSteps, 4096.0 * float(steps)) * pixelOffset;

        vec2 offsetPosition = shadowPosition.xy + offset;
        vec2 giPosition = DistortShadowSpace(offsetPosition) * 0.5 + 0.5;

        float shadow = textureLod(shadowtex1, giPosition, 0).x;

        vec3 relativeSamplePosition = vec3(offsetPosition, shadow * 8.0 - 4.0) - shadowPosition;

        if (relativeSamplePosition.z < -0.02) continue;

        vec3 sampleDirection = normalize(relativeSamplePosition);

        float sampleAngle = clamp01(dot(shadowSpaceNormal, sampleDirection));
              sampleAngle = sampleAngle * (1.0 - float(isFoliage)) + float(isFoliage);
        if (sampleAngle <= 0.0) continue;

        vec4 shadowTexture1 = textureLod(shadowcolor1, giPosition, 0);
        vec3 shadowNormal = shadowTexture1.rgb * 2.0 - 1.0;
             shadowNormal.xy = -shadowNormal.xy;

        float NoL = clamp01(dot(sampleDirection, shadowNormal));
        if (NoL <= 0.0 || shadowTexture1.a * 2.0 - 1.0 > 0.5) continue;

        float sampleDist = (length(relativeSamplePosition) + falloffCompensation) * 16.0;

        float falloffNear = 0.5 / (sampleDist * sampleDist);
        float falloffFar = 1.0 / sampleDist;
        float falloffMix = sampleDist / (sampleDist + 1.0);
        float falloff = mix(falloffNear, falloffFar, falloffMix);

        vec4 albedo = textureLod(shadowcolor, giPosition, 0);
			 albedo.rgb = pow(albedo.rgb, vec3(2.2));

        float skyLightMapShadow = albedo.a * 2.0 - 1.0;
		float bleedingMask = skyLightMapShadow - skyLightMap;
			  bleedingMask = pow2(bleedingMask);
			  bleedingMask = clamp01(exp2(-bleedingMask) * 2.2 - 1.2) ;

        totalGi += albedo.rgb * sqrt(NoL * sampleAngle) * bleedingMask * falloff;
    }

    return totalGi * rSteps * rPI;
}

#endif