/********************************************************
    © 2020 Continuum Graphics LLC. All Rights Reserved
 ********************************************************/

#if !defined _LIGHTMAPSHADING_
#define _LIGHTMAPSHADING_

vec3 CalculateBlockLightVector(vec3 flatNormal, float blockLight) {
    vec2 lmDeriv = vec2(dFdx(blockLight), dFdy(blockLight));
    mat2x3 posDeriv = mat2x3(mat3(gbufferModelViewInverse) * dFdx(viewSpacePosition), mat3(gbufferModelViewInverse) * dFdy(viewSpacePosition));

    vec3 lmVector  = posDeriv * vec2(-lmDeriv.y, lmDeriv.x);
         lmVector  = cross(lmVector, flatNormal);
         //lmVector += flatNormal * dot(posDeriv[0] + posDeriv[1], posDeriv[0] + posDeriv[1]) * 0.5 * 0.0625; // 1.0 / 16.0
    
    float len = length(lmVector);
    return len > 0.0 ? normalize(mix(lmVector, flatNormal * len, pow8(blockLight))) : flatNormal;
}

float CalculateBlockLight(vec3 normal, float blockLight) {
    /*
    vec3 lightVector = CalculateBlockLightVector(tbn[2], blockLight);

    const float lightmapLength = 15.0;
    float lightDistance = (1.0 - blockLight) * lightmapLength + 1.0;
    float atten = (blockLight) / (lightDistance * lightDistance);

    float NoL = dot(normal, lightVector);
    */
    return blockLight;// * clamp01(clamp01(NoL * 0.7) + 0.2);
}

#endif
