#if !defined _SHADOWSETTINGS_
#define _SHADOWSETTINGS_

/*******************************************************************************
 - Shadow Settings
 ******************************************************************************/

#define SHADOW_MINIMUM 2
#define SHADOW_LOW 3
#define SHADOW_MEDIUM 9
#define SHADOW_HIGH 18
#define SHADOW_ULTRA 25
#define SHADOW_CINEMATIC 81

#define SHADOW_QUALITY SHADOW_MEDIUM // [SHADOW_MINIMUM SHADOW_LOW SHADOW_MEDIUM SHADOW_HIGH SHADOW_ULTRA SHADOW_CINEMATIC]
#define SHADOW_PENUMBRA_ANGLE 8.0 // [0.0 1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0]

#define SHADOW_HARD 0
#define SHADOW_SOFT 1
#define SHADOW_PCSS 2

#define SHADOW_TYPE SHADOW_PCSS // [SHADOW_HARD SHADOW_SOFT SHADOW_PCSS]

const int shadowMapResolution = 2048; // [256 512 1024 2048 4096 8192 16384]
const float rShadowMapResolution = 1.0 / float(shadowMapResolution);
const float shadowDistance    = 120.0;

#define CAUSTICS

#endif
