/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.JsonConfig;
import xiroc.dungeoncrawl.util.IJsonConfigurable;

public class EnchantedBook
implements IJsonConfigurable {
    public static final String KEY_ENCHANTMENTS_COMMON = "common_enchantments";
    public static final String KEY_ENCHANTMENTS_NORMAL = "normal_enchantments";
    public static final String KEY_ENCHANTMENTS_RARE = "rare_enchantments";
    public static final String[] KEYS = new String[]{"common_enchantments", "normal_enchantments", "rare_enchantments"};
    public static final HashMap<String, Object> DEFAULTS = new HashMap();
    public static ResourceLocation[] ENCHANTMENTS_COMMON;
    public static ResourceLocation[] ENCHANTMENTS_NORMAL;
    public static ResourceLocation[] ENCHANTMENTS_RARE;

    @Override
    public File getFile() {
        return FMLPaths.CONFIGDIR.get().resolve("DungeonCrawl/loot/enchanted_book.json").toFile();
    }

    @Override
    public void load(JsonObject object, File file) {
        ENCHANTMENTS_COMMON = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ENCHANTMENTS_COMMON, this), String[].class));
        ENCHANTMENTS_NORMAL = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ENCHANTMENTS_NORMAL, this), String[].class));
        ENCHANTMENTS_RARE = JsonConfig.toResourceLocationArray((String[])DungeonCrawl.GSON.fromJson(JsonConfig.getOrRewrite(object, KEY_ENCHANTMENTS_RARE, this), String[].class));
    }

    @Override
    public JsonObject create(JsonObject object) {
        object.add(KEY_ENCHANTMENTS_COMMON, DungeonCrawl.GSON.toJsonTree(DEFAULTS.get(KEY_ENCHANTMENTS_COMMON)));
        object.add(KEY_ENCHANTMENTS_NORMAL, DungeonCrawl.GSON.toJsonTree(DEFAULTS.get(KEY_ENCHANTMENTS_NORMAL)));
        object.add(KEY_ENCHANTMENTS_RARE, DungeonCrawl.GSON.toJsonTree(DEFAULTS.get(KEY_ENCHANTMENTS_RARE)));
        return object;
    }

    @Override
    public HashMap<String, Object> getDefaults() {
        return DEFAULTS;
    }

    @Override
    public String[] getKeys() {
        return KEYS;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean deleteOldVersion() {
        return false;
    }

    public static Enchantment getRandomEnchantment(Random rand, int lootLevel) {
        if (rand.nextDouble() < EnchantedBook.getChance(2, lootLevel)) {
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ENCHANTMENTS_RARE[rand.nextInt(ENCHANTMENTS_RARE.length)]);
        }
        if (rand.nextDouble() < EnchantedBook.getChance(1, lootLevel)) {
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ENCHANTMENTS_NORMAL[rand.nextInt(ENCHANTMENTS_NORMAL.length)]);
        }
        return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ENCHANTMENTS_COMMON[rand.nextInt(ENCHANTMENTS_COMMON.length)]);
    }

    public static double getChance(int rarity, int lootLevel) {
        return (1.0 + (double)lootLevel - (double)rarity) / (1.0 + (double)lootLevel);
    }

    static {
        DEFAULTS.put(KEY_ENCHANTMENTS_COMMON, new String[]{Enchantments.field_185299_g.getRegistryName().toString(), Enchantments.field_180312_n.getRegistryName().toString(), Enchantments.field_185297_d.getRegistryName().toString(), Enchantments.field_180313_o.getRegistryName().toString(), Enchantments.field_180308_g.getRegistryName().toString(), Enchantments.field_77329_d.getRegistryName().toString(), Enchantments.field_180310_c.getRegistryName().toString(), Enchantments.field_185307_s.getRegistryName().toString(), Enchantments.field_185303_l.getRegistryName().toString()});
        DEFAULTS.put(KEY_ENCHANTMENTS_NORMAL, new String[]{Enchantments.field_185300_i.getRegistryName().toString(), Enchantments.field_77334_n.getRegistryName().toString(), Enchantments.field_203194_D.getRegistryName().toString(), Enchantments.field_92091_k.getRegistryName().toString(), Enchantments.field_222192_G.getRegistryName().toString(), Enchantments.field_185302_k.getRegistryName().toString(), Enchantments.field_185305_q.getRegistryName().toString(), Enchantments.field_151369_A.getRegistryName().toString(), Enchantments.field_185309_u.getRegistryName().toString(), Enchantments.field_185310_v.getRegistryName().toString(), Enchantments.field_185298_f.getRegistryName().toString()});
        DEFAULTS.put(KEY_ENCHANTMENTS_RARE, new String[]{Enchantments.field_77334_n.getRegistryName().toString(), Enchantments.field_185311_w.getRegistryName().toString(), Enchantments.field_185308_t.getRegistryName().toString(), Enchantments.field_203196_F.getRegistryName().toString(), Enchantments.field_185312_x.getRegistryName().toString(), Enchantments.field_185304_p.getRegistryName().toString(), Enchantments.field_203193_C.getRegistryName().toString(), Enchantments.field_203195_E.getRegistryName().toString(), Enchantments.field_151370_z.getRegistryName().toString(), Enchantments.field_222194_I.getRegistryName().toString(), Enchantments.field_222193_H.getRegistryName().toString(), Enchantments.field_185306_r.getRegistryName().toString(), Enchantments.field_191530_r.getRegistryName().toString()});
    }
}

