/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.command.argument.SecondaryThemeArgument;
import xiroc.dungeoncrawl.command.argument.ThemeArgument;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.piece.DungeonEntrance;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.Theme;

public class SpawnDungeonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"roguelike").requires(a -> a.m_6761_(4))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(command -> {
            BlockPos pos = Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource());
            ServerLevel world = ((CommandSourceStack)command.getSource()).m_81372_();
            ResourceLocation biomeKey = world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)world.m_7158_(pos.m_123341_() >> 2, pos.m_123342_() >> 2, pos.m_123343_() >> 2));
            String biome = biomeKey != null ? biomeKey.toString() : "minecraft:plains";
            return SpawnDungeonCommand.spawnDungeon((CommandSourceStack)command.getSource(), world, pos, Theme.randomTheme(biome, world.m_5822_()), Theme.randomSecondaryTheme(biome, world.m_5822_()));
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"theme", (ArgumentType)ThemeArgument.theme()).executes(command -> SpawnDungeonCommand.spawnDungeon((CommandSourceStack)command.getSource(), ((CommandSourceStack)command.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource()), ThemeArgument.getTheme((CommandContext<CommandSourceStack>)command, "theme"), Theme.getBuiltinDefaultSecondaryTheme()))).then(Commands.m_82129_((String)"secondary_theme", (ArgumentType)SecondaryThemeArgument.secondaryTheme()).executes(command -> SpawnDungeonCommand.spawnDungeon((CommandSourceStack)command.getSource(), ((CommandSourceStack)command.getSource()).m_81372_(), Vec3Argument.m_120849_((CommandContext)command, (String)"location").m_119568_((CommandSourceStack)command.getSource()), ThemeArgument.getTheme((CommandContext<CommandSourceStack>)command, "theme"), SecondaryThemeArgument.getSecondaryTheme((CommandContext<CommandSourceStack>)command, "secondary_theme")))))));
    }

    private static int spawnDungeon(CommandSourceStack commandSource, ServerLevel world, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme) {
        commandSource.m_81354_((Component)new TextComponent(ChatFormatting.RED + "This is an experimental feature. Please report any bugs you encounter on the issue tracker on https://github.com/XYROC/DungeonCrawl/issues."), true);
        if (world.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) > 32) {
            long seed = (long)pos.m_123341_() + (long)pos.m_123343_() << (int)(8L + world.m_7328_());
            commandSource.m_81354_((Component)new TextComponent("Dungeon Seed: " + seed), true);
            commandSource.m_81354_((Component)new TextComponent("Building a dungeon..."), true);
            DungeonBuilder builder = new DungeonBuilder(world, pos, new Random(seed));
            builder.theme = theme;
            builder.secondaryTheme = secondaryTheme;
            List<DungeonPiece> pieces = builder.build();
            pieces.forEach(piece -> {
                piece.context.heightmapType = Heightmap.Types.WORLD_SURFACE;
                piece.context.postProcessing = false;
                if (piece instanceof DungeonEntrance) {
                    Vec3i offset = piece.model.getOffset(piece.f_73379_);
                    int x = piece.x + 4 + offset.m_123341_();
                    int z = piece.z + 4 + offset.m_123343_();
                    BoundingBox bounds = new BoundingBox(x, 0, z, x + piece.model.width - 1, world.m_151558_(), z + piece.model.length - 1);
                    BlockPos vector3i = bounds.m_162394_();
                    piece.m_7832_((WorldGenLevel)world, world.m_8595_(), world.m_7726_().f_8328_, builder.rand, bounds, new ChunkPos(piece.x >> 4, piece.z >> 4), new BlockPos(vector3i.m_123341_(), bounds.m_162396_(), vector3i.m_123343_()));
                } else {
                    BoundingBox boundingBox = piece.m_73547_();
                    BlockPos vector3i = boundingBox.m_162394_();
                    piece.m_7832_((WorldGenLevel)world, world.m_8595_(), world.m_7726_().f_8328_, builder.rand, boundingBox, new ChunkPos(piece.x >> 4, piece.z >> 4), new BlockPos(vector3i.m_123341_(), boundingBox.m_162396_(), vector3i.m_123343_()));
                }
            });
            commandSource.m_81354_((Component)new TextComponent(ChatFormatting.GREEN + "Done."), true);
            return 0;
        }
        commandSource.m_81352_((Component)new TextComponent("Your current position is unfit for a dungeon."));
        return 1;
    }
}

