/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;

public class Dungeon
extends StructureFeature<NoneFeatureConfiguration> {
    public static Set<Biome.BiomeCategory> biomeCategories = ImmutableSet.builder().add((Object)Biome.BiomeCategory.DESERT).add((Object)Biome.BiomeCategory.EXTREME_HILLS).add((Object)Biome.BiomeCategory.FOREST).add((Object)Biome.BiomeCategory.ICY).add((Object)Biome.BiomeCategory.JUNGLE).add((Object)Biome.BiomeCategory.MESA).add((Object)Biome.BiomeCategory.PLAINS).add((Object)Biome.BiomeCategory.SAVANNA).add((Object)Biome.BiomeCategory.SWAMP).add((Object)Biome.BiomeCategory.TAIGA).build();
    public static ImmutableSet<String> whitelistedDimensions = ImmutableSet.of((Object)"minecraft:overworld");
    public static ImmutableSet<String> whitelistedBiomes = ImmutableSet.of();
    public static ImmutableSet<String> blacklistedBiomes = ImmutableSet.of();
    public static final String NAME = "dungeoncrawl:dungeon";
    public static final int SIZE = 15;

    public Dungeon() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    protected boolean m_5910_() {
        return false;
    }

    protected boolean isFeatureChunk(ChunkGenerator p_160455_, BiomeSource p_160456_, long p_160457_, WorldgenRandom p_160458_, ChunkPos p_160459_, Biome p_160460_, ChunkPos p_160461_, NoneFeatureConfiguration p_160462_, LevelHeightAccessor p_160463_) {
        for (Biome biome : p_160456_.m_7901_(p_160459_.f_45578_ * 16, p_160455_.m_142051_(p_160463_), p_160459_.f_45579_ * 16, 64)) {
            if (biome.m_47536_().m_47808_((StructureFeature)this)) continue;
            return false;
        }
        return true;
    }

    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return Start::new;
    }

    public String m_67098_() {
        return NAME;
    }

    public static class Start
    extends StructureStart<NoneFeatureConfiguration> {
        public Start(StructureFeature<NoneFeatureConfiguration> p_163595_, ChunkPos p_163596_, int p_163597_, long p_163598_) {
            super(p_163595_, p_163596_, p_163597_, p_163598_);
        }

        public void generatePieces(RegistryAccess registryAccess, ChunkGenerator chunkGenerator, StructureManager p_163617_, ChunkPos chunkPos, Biome p_163619_, NoneFeatureConfiguration p_163620_, LevelHeightAccessor heightAccessor) {
            DungeonBuilder builder = new DungeonBuilder(registryAccess, chunkGenerator, heightAccessor, chunkPos, (Random)this.f_73564_);
            this.f_73562_.addAll(builder.build());
            DungeonCrawl.LOGGER.debug("Created the dungeon layout for [{}, {}] with a total of {} pieces.", (Object)chunkPos.f_45578_, (Object)chunkPos.f_45579_, (Object)this.f_73562_.size());
        }

        public void m_7129_(WorldGenLevel p_230366_1_, StructureFeatureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, BoundingBox p_230366_5_, ChunkPos p_230366_6_) {
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Starting dungeon generation in chunk [{},{}]", (Object)p_230366_6_.f_45578_, (Object)p_230366_6_.f_45579_);
            }
            super.m_7129_(p_230366_1_, p_230366_2_, p_230366_3_, p_230366_4_, p_230366_5_, p_230366_6_);
            if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
                DungeonCrawl.LOGGER.debug("Finished dungeon generation in chunk [{},{}]", (Object)p_230366_6_.f_45578_, (Object)p_230366_6_.f_45579_);
            }
        }
    }
}

