/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonLayerMap;
import xiroc.dungeoncrawl.dungeon.DungeonStatTracker;
import xiroc.dungeoncrawl.dungeon.Node;
import xiroc.dungeoncrawl.dungeon.Tile;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonCorridor;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonNodeRoom;
import xiroc.dungeoncrawl.dungeon.piece.room.DungeonSecretRoom;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.Position2D;

public class DungeonLayer {
    public final Tile[][] grid;
    public Position2D start;
    public Position2D end;
    public int width;
    public int length;
    public List<Position2D> distantNodes;
    public boolean stairsPlaced;
    public DungeonStatTracker.LayerStatTracker statTracker;
    public DungeonLayerMap map;

    public DungeonLayer(int size) {
        this(size, size);
    }

    public DungeonLayer(int width, int length) {
        this.width = width;
        this.length = length;
        this.statTracker = new DungeonStatTracker.LayerStatTracker();
        this.grid = new Tile[this.width][this.length];
        this.distantNodes = Lists.newArrayList();
        this.map = new DungeonLayerMap(width, length);
    }

    public boolean isTileFree(Position2D pos) {
        return this.grid[pos.x][pos.z] == null && this.map.isPositionFree(pos.x, pos.z);
    }

    public int distance(Position2D a, Position2D b) {
        return Math.abs(a.x - b.x) + Math.abs(a.z - b.z);
    }

    public boolean canPlaceNode(Position2D center) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                Position2D currentPos = new Position2D(center.x + x, center.z + z);
                if (x == 0 && z == 0) {
                    if (!currentPos.isValid(this.width, this.length)) {
                        return false;
                    }
                    if (this.isTileFree(currentPos)) continue;
                    return false;
                }
                if (!currentPos.isValid(this.width, this.length) || this.isTileFree(currentPos)) continue;
                return false;
            }
        }
        return true;
    }

    public Tuple<Position2D, Rotation> findStarterRoomData(Position2D start, Random rand) {
        int index = rand.nextInt(4);
        for (int i = 0; i < 4; ++i) {
            index = (index + i) % 4;
            for (int j = 0; j < 2; ++j) {
                Tuple<Position2D, Rotation> data;
                Position2D current = start.shift(Orientation.HORIZONTAL_FACINGS[index], j + 1);
                if (!current.isValid(15) || this.grid[current.x][current.z] == null || this.grid[current.x][current.z].piece.getDungeonPieceType() != 0 || this.grid[current.x][current.z].piece.connectedSides >= 4 || (data = this.findSideRoomData(new Position2D(current.x, current.z), rand)) == null) continue;
                return data;
            }
        }
        return null;
    }

    public Tuple<Position2D, Rotation> findSideRoomData(Position2D base, Random rand) {
        Position2D north = base.shift(Direction.NORTH, 1);
        Position2D east = base.shift(Direction.EAST, 1);
        Position2D south = base.shift(Direction.SOUTH, 1);
        Position2D west = base.shift(Direction.WEST, 1);
        if (rand.nextBoolean()) {
            if (north.isValid(this.width, this.length) && this.isTileFree(north)) {
                return new Tuple((Object)north, (Object)Rotation.COUNTERCLOCKWISE_90);
            }
            if (east.isValid(this.width, this.length) && this.isTileFree(east)) {
                return new Tuple((Object)east, (Object)Rotation.NONE);
            }
            if (south.isValid(this.width, this.length) && this.isTileFree(south)) {
                return new Tuple((Object)south, (Object)Rotation.CLOCKWISE_90);
            }
            if (west.isValid(this.width, this.length) && this.isTileFree(west)) {
                return new Tuple((Object)west, (Object)Rotation.CLOCKWISE_180);
            }
        } else {
            if (west.isValid(this.width, this.length) && this.isTileFree(west)) {
                return new Tuple((Object)west, (Object)Rotation.CLOCKWISE_180);
            }
            if (south.isValid(this.width, this.length) && this.isTileFree(south)) {
                return new Tuple((Object)south, (Object)Rotation.CLOCKWISE_90);
            }
            if (east.isValid(this.width, this.length) && this.isTileFree(east)) {
                return new Tuple((Object)east, (Object)Rotation.NONE);
            }
            if (north.isValid(this.width, this.length) && this.isTileFree(north)) {
                return new Tuple((Object)north, (Object)Rotation.COUNTERCLOCKWISE_90);
            }
        }
        return null;
    }

    public void openSideIfPresent(Position2D position, Direction side) {
        if (position.isValid(this.width, this.length) && this.grid[position.x][position.z] != null) {
            this.grid[position.x][position.z].piece.openSide(side);
        }
    }

    public void rotatePiece(Tile placeHolder, Random rand) {
        if (placeHolder.hasFlag(Tile.Flag.FIXED_ROTATION)) {
            return;
        }
        DungeonPiece piece = placeHolder.piece;
        switch (piece.connectedSides) {
            case 1: {
                piece.setRotation(Orientation.getRotationFromFacing(DungeonPiece.getOneWayDirection(piece)));
                break;
            }
            case 2: {
                if (piece.sides[0] && piece.sides[2]) {
                    piece.setRotation(Orientation.getRotationFromFacing(rand.nextBoolean() ? Direction.NORTH : Direction.SOUTH));
                    break;
                }
                if (piece.sides[1] && piece.sides[3]) {
                    piece.setRotation(Orientation.getRotationFromFacing(rand.nextBoolean() ? Direction.EAST : Direction.WEST));
                    break;
                }
                piece.setRotation(Orientation.getRotationFromCW90DoubleFacing(DungeonPiece.getOpenSide(piece, 0), DungeonPiece.getOpenSide(piece, 1)));
                break;
            }
            case 3: {
                piece.setRotation(Orientation.getRotationFromTripleFacing(DungeonPiece.getOpenSide(piece, 0), DungeonPiece.getOpenSide(piece, 1), DungeonPiece.getOpenSide(piece, 2)));
                break;
            }
            default: {
                piece.setRotation(Rotation.m_55956_((Random)rand));
            }
        }
    }

    public void rotateNode(Tile placeHolder, Random rand) {
        if (placeHolder.hasFlag(Tile.Flag.FIXED_ROTATION)) {
            return;
        }
        DungeonNodeRoom node = (DungeonNodeRoom)placeHolder.piece;
        Rotation rotation = Node.getForNodeRoom(node).compare(new Node(node.sides[0], node.sides[1], node.sides[2], node.sides[3]), rand);
        if (rotation != null) {
            node.f_73379_ = rotation;
        } else {
            DungeonCrawl.LOGGER.error("Could not find a proper node rotation for [{} {} {} {}].", (Object)node.sides[0], (Object)node.sides[1], (Object)node.sides[2], (Object)node.sides[3]);
        }
    }

    public boolean placeSecretRoom(DungeonCorridor corridor, Position2D position, Random rand) {
        Direction direction = corridor.f_73379_ == Rotation.NONE || corridor.f_73379_ == Rotation.CLOCKWISE_180 ? (rand.nextBoolean() ? Direction.NORTH : Direction.SOUTH) : (rand.nextBoolean() ? Direction.EAST : Direction.WEST);
        Position2D pos = position.shift(direction, 2);
        if (this.attemptSecretRoomPlacement(corridor, position, direction, pos)) {
            return true;
        }
        direction = direction.m_122424_();
        pos = position.shift(direction, 2);
        return this.attemptSecretRoomPlacement(corridor, position, direction, pos);
    }

    public boolean attemptSecretRoomPlacement(DungeonCorridor corridor, Position2D corridorPos, Direction direction, Position2D outerPosition) {
        if (outerPosition.isValid(this.width, this.length)) {
            Position2D innerPosition = corridorPos.shift(direction, 1);
            if (this.isTileFree(outerPosition) && this.isTileFree(innerPosition)) {
                DungeonSecretRoom room = new DungeonSecretRoom();
                int x = Math.min(outerPosition.x, innerPosition.x);
                int z = Math.min(outerPosition.z, innerPosition.z);
                room.setGridPosition(x, z);
                room.setRotation(Orientation.getRotationFromFacing(direction));
                this.grid[x][z] = new Tile(room);
                Position2D other = DungeonLayer.getOther(x, z, direction);
                this.grid[other.x][other.z] = new Tile(room).addFlag(Tile.Flag.PLACEHOLDER);
                corridor.f_73379_ = Orientation.getRotationFromFacing(direction).m_55952_(Rotation.CLOCKWISE_90);
                corridor.model = DungeonModels.KEY_TO_MODEL.get(DungeonModels.SECRET_ROOM_ENTRANCE);
                this.grid[corridorPos.x][corridorPos.z].addFlag(Tile.Flag.FIXED_MODEL);
                return true;
            }
        }
        return false;
    }

    private static Position2D getOther(int x, int z, Direction direction) {
        return switch (direction) {
            case Direction.EAST, Direction.WEST -> new Position2D(x + 1, z);
            case Direction.SOUTH, Direction.NORTH -> new Position2D(x, z + 1);
            default -> throw new UnsupportedOperationException("Can't get other position from direction " + direction);
        };
    }
}

