/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.ModelHandler;
import xiroc.dungeoncrawl.exception.DatapackLoadException;

public class DungeonModels {
    public static final Hashtable<ResourceLocation, DungeonModel> KEY_TO_MODEL = new Hashtable();
    public static final Hashtable<Integer, DungeonModel> ID_TO_MODEL = new Hashtable();
    public static final Vec3i NO_OFFSET = new Vec3i(0, 0, 0);
    public static final ResourceLocation SECRET_ROOM_ENTRANCE = DungeonCrawl.locate("default/corridor/secret_room_entrance");
    public static final ResourceLocation STARTER_ROOM = DungeonCrawl.locate("default/room/starter_room");
    public static final ResourceLocation ROGUELIKE_TOWER = DungeonCrawl.locate("default/entrance/roguelike/rogue_tower");
    public static final ResourceLocation STAIRCASE = DungeonCrawl.locate("default/staircase");
    public static final ResourceLocation BOTTOM_STAIRS = DungeonCrawl.locate("default/stairs_bottom");
    public static final ResourceLocation BOTTOM_STAIRS_2 = DungeonCrawl.locate("default/stairs_bottom_2");
    public static final ResourceLocation TOP_STAIRS = DungeonCrawl.locate("default/stairs_top");
    public static final ResourceLocation LOOT_ROOM = DungeonCrawl.locate("default/loot_room");
    public static final ResourceLocation SECRET_ROOM = DungeonCrawl.locate("default/room/secret_room");
    private static ImmutableSet<ResourceLocation> KEYS;
    private static ImmutableSet.Builder<ResourceLocation> keySetBuilder;
    private static final String DIRECTORY = "models";

    public static synchronized void load(ResourceManager resourceManager) {
        ID_TO_MODEL.clear();
        KEY_TO_MODEL.clear();
        keySetBuilder = new ImmutableSet.Builder();
        resourceManager.m_6540_(DIRECTORY, s -> s.endsWith(".nbt")).forEach(resource -> DungeonModels.load(resource, resourceManager));
        KEYS = keySetBuilder.build();
    }

    private static void load(ResourceLocation resource, ResourceManager resourceManager) {
        DungeonModel model = DungeonModels.loadModel(resource, resourceManager);
        ResourceLocation metadata = new ResourceLocation(resource.m_135827_(), resource.m_135815_().substring(0, resource.m_135815_().indexOf(".nbt")) + ".json");
        if (resourceManager.m_7165_(metadata)) {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)metadata);
            try {
                model.loadMetadata(DungeonCrawl.JSON_PARSER.parse((Reader)new InputStreamReader(resourceManager.m_142591_(metadata).m_6679_())).getAsJsonObject(), metadata);
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load metadata for {}", (Object)resource.m_135815_());
                e.printStackTrace();
            }
        }
    }

    private static DungeonModel loadModel(ResourceLocation resource, ResourceManager resourceManager) {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)resource);
        try {
            CompoundTag nbt = NbtIo.m_128939_((InputStream)resourceManager.m_142591_(resource).m_6679_());
            ResourceLocation key = DungeonCrawl.key(resource, DIRECTORY, ".nbt");
            DungeonModel model = ModelHandler.loadModelFromNBT(nbt, resource, key);
            KEY_TO_MODEL.put(key, model);
            keySetBuilder.add((Object)key);
            if (model.hasId()) {
                ID_TO_MODEL.put(model.getId(), model);
            }
            return model;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DatapackLoadException("Failed to load " + resource);
        }
    }

    public static ImmutableSet<ResourceLocation> getKeys() {
        return KEYS;
    }
}

