/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementContext;
import xiroc.dungeoncrawl.dungeon.StructurePieceTypes;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlock;
import xiroc.dungeoncrawl.dungeon.model.DungeonModelBlockType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.theme.Theme;

public class DungeonEntrance
extends DungeonPiece {
    public DungeonEntrance() {
        super(StructurePieceTypes.ENTRANCE);
    }

    public DungeonEntrance(ServerLevel serverLevel, CompoundTag nbt) {
        super(StructurePieceTypes.ENTRANCE, nbt);
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, Random rand) {
    }

    public boolean m_7832_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        int cursorHeight;
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return true;
        }
        Vec3i offset = this.model.getOffset(this.f_73379_);
        int height = worldIn.m_6924_(this.context.heightmapType, this.x + offset.m_123341_() + 4, this.z + offset.m_123343_() + 4);
        DungeonModel staircase = DungeonModels.KEY_TO_MODEL.get(DungeonModels.STAIRCASE);
        int maxBuried = Math.min(this.model.height / 4, 4);
        for (cursorHeight = this.y; cursorHeight < height && height - cursorHeight > maxBuried; cursorHeight += 8) {
            super.build(staircase, (LevelAccessor)worldIn, structureBoundingBoxIn, new BlockPos(this.x + 2, cursorHeight, this.z + 2), this.theme, this.secondaryTheme, this.stage, this.context, true);
        }
        BlockPos pos = new BlockPos(this.x + 4, cursorHeight, this.z + 4).m_141952_(offset);
        this.build(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, this.theme, this.secondaryTheme, this.stage, this.context, true);
        this.placeFeatures((LevelAccessor)worldIn, this.context, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
        BoundingBox populationBox = this.model.createBoundingBox(pos, this.f_73379_);
        this.decorate((LevelAccessor)worldIn, pos, this.context, this.model.width, this.model.height, this.model.length, this.theme, structureBoundingBoxIn, populationBox, this.model);
        return true;
    }

    @Override
    public void setupBoundingBox() {
        if (this.model != null) {
            Vec3i offset = this.model.getOffset(this.f_73379_);
            int x = this.x + 4 + offset.m_123341_();
            int z = this.z + 4 + offset.m_123343_();
            switch (this.f_73379_) {
                case NONE: 
                case CLOCKWISE_180: {
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                    break;
                }
                case CLOCKWISE_90: 
                case COUNTERCLOCKWISE_90: {
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.length - 1, 256, z + this.model.width - 1);
                    break;
                }
                default: {
                    DungeonCrawl.LOGGER.warn("Unknown entrance rotation: {}", (Object)this.f_73379_);
                    this.f_73383_ = new BoundingBox(x, 0, z, x + this.model.width - 1, 256, z + this.model.length - 1);
                }
            }
        }
    }

    @Override
    public int getDungeonPieceType() {
        return 6;
    }

    @Override
    public void build(DungeonModel model, LevelAccessor world, BoundingBox boundsIn, BlockPos pos, Theme theme, Theme.SecondaryTheme secondaryTheme, int lootLevel, PlacementContext context, boolean fillAir) {
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
        model.blocks.forEach(block -> {
            BlockPos position = pos.m_141952_(block.position);
            if (boundsIn.m_71051_((Vec3i)position)) {
                BlockState state = block.type.blockFactory.get((DungeonModelBlock)block, this.f_73379_, world, position, theme, secondaryTheme, world.m_5822_(), this.variation, this.stage);
                if (state == null) {
                    return;
                }
                this.placeBlock((DungeonModelBlock)block, world, context, theme, secondaryTheme, lootLevel, fillAir, position, state);
                if (block.type == DungeonModelBlockType.SOLID && block.position.m_123342_() == 0 && world.m_46859_(position.m_7495_())) {
                    this.buildPillar(world, position.m_7495_());
                }
            }
        });
        if (((Boolean)Config.EXTENDED_DEBUG.get()).booleanValue()) {
            DungeonCrawl.LOGGER.debug("Finished building {} at ({} | {} | {})", (Object)model.getKey(), (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
        }
    }
}

