/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;

public class Treasure {
    public static final LootItemFunctionType ENCHANTED_BOOK = new LootItemFunctionType((Serializer)new EnchantedBook.Serializer());
    public static final LootItemFunctionType MATERIAL_BLOCKS = new LootItemFunctionType((Serializer)new MaterialBlocks.Serializer());
    public static final LootItemFunctionType RANDOM_ITEM = new LootItemFunctionType((Serializer)new RandomItem.Serializer());
    public static final LootItemFunctionType RANDOM_POTION = new LootItemFunctionType((Serializer)new RandomPotion.Serializer());
    public static final LootItemFunctionType SHIELD = new LootItemFunctionType((Serializer)new Shield.Serializer());
    public static final LootItemFunctionType SUSPICIOUS_STEW = new LootItemFunctionType((Serializer)new SuspiciousStew.Serializer());

    private static void register(ResourceLocation registryName, LootItemFunctionType type) {
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)registryName, (Object)type);
    }

    public static void init() {
        Treasure.register(DungeonCrawl.locate("enchanted_book"), ENCHANTED_BOOK);
        Treasure.register(DungeonCrawl.locate("material_blocks"), MATERIAL_BLOCKS);
        Treasure.register(DungeonCrawl.locate("random_item"), RANDOM_ITEM);
        Treasure.register(DungeonCrawl.locate("random_potion"), RANDOM_POTION);
        Treasure.register(DungeonCrawl.locate("shield"), SHIELD);
        Treasure.register(DungeonCrawl.locate("suspicious_stew"), SUSPICIOUS_STEW);
    }
}

