/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.init;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.init.ModStructureFeatures;

public class ModStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"dungeoncrawl");
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> DUNGEON = STRUCTURES.register("dungeon", Dungeon::new);

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        STRUCTURES.register(modEventBus);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(ModStructures::onWorldLoad);
        forgeEventBus.addListener(EventPriority.HIGH, ModStructures::onBiomeLoad);
    }

    public static void register() {
        if ((Integer)Config.SPACING.get() <= (Integer)Config.SEPARATION.get() || (Integer)Config.SEPARATION.get() < 0) {
            throw new RuntimeException("Invalid dungeon spacing/separation settings in the config.");
        }
        StructureFeatureConfiguration dungeonSeparationSettings = new StructureFeatureConfiguration(((Integer)Config.SPACING.get()).intValue(), ((Integer)Config.SEPARATION.get()).intValue(), 10387313);
        ModStructures.registerStructure(DUNGEON, ModStructureFeatures.CONFIGURED_DUNGEON, dungeonSeparationSettings);
    }

    private static <FC extends FeatureConfiguration> void registerStructure(RegistryObject<StructureFeature<FC>> structure, ConfiguredStructureFeature<FC, ? extends StructureFeature<FC>> configuredFeature, StructureFeatureConfiguration separationSettings) {
        ResourceLocation registryName = structure.getId();
        StructureFeature.f_67012_.put((Object)registryName.toString(), (Object)((StructureFeature)structure.get()));
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put((Object)((StructureFeature)structure.get()), (Object)separationSettings).build();
        Registry registry = BuiltinRegistries.f_123862_;
        Registry.m_122965_((Registry)registry, (ResourceLocation)registryName, configuredFeature);
        FlatLevelGeneratorSettings.f_70349_.put((StructureFeature)structure.get(), configuredFeature);
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureConfiguration = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureConfiguration instanceof ImmutableMap) {
                HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureConfiguration);
                tempMap.put((StructureFeature)structure.get(), separationSettings);
                ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
            } else {
                structureConfiguration.put((StructureFeature)structure.get(), separationSettings);
            }
        });
    }

    private static void onBiomeLoad(BiomeLoadingEvent event) {
        if (!(!Dungeon.biomeCategories.contains(event.getCategory()) && event.getName() != null && !Dungeon.whitelistedBiomes.contains((Object)event.getName().toString()) || event.getName() != null && Dungeon.blacklistedBiomes.contains((Object)event.getName().toString()))) {
            DungeonCrawl.LOGGER.debug("Generating in biome {}", (Object)event.getName());
            event.getGeneration().m_47849_(ModStructureFeatures.CONFIGURED_DUNGEON);
        } else {
            DungeonCrawl.LOGGER.debug("Ignoring biome {} with category {}", (Object)event.getName(), (Object)event.getCategory().m_47645_());
        }
    }

    private static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if (serverLevel.m_7726_().m_8481_() instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            if (!Dungeon.whitelistedDimensions.contains((Object)serverLevel.m_46472_().m_135782_().toString())) {
                return;
            }
            if (serverLevel.m_7726_().f_8328_.m_142051_((LevelHeightAccessor)serverLevel) < 32) {
                DungeonCrawl.LOGGER.info("Ignoring dimension {} because it's spawn height is too low.", (Object)serverLevel.m_46472_().m_135782_());
                return;
            }
            DungeonCrawl.LOGGER.debug("Generating in dimension: {}", (Object)serverLevel.m_46472_().m_135782_());
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(serverLevel.m_7726_().f_8328_.m_62205_().m_64590_());
            tempMap.putIfAbsent((StructureFeature)DUNGEON.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)DUNGEON.get()));
            serverLevel.m_7726_().f_8328_.m_62205_().f_64582_ = tempMap;
        }
    }
}

