/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelPools;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Updateable;

public class ResourceReloadHandler
implements PreparableReloadListener {
    public static final ArrayList<Updateable> UPDATEABLES = new ArrayList();

    public void reload(ResourceManager resourceManager) {
        DungeonCrawl.LOGGER.info("Loading data...");
        UPDATEABLES.clear();
        DungeonModels.load(resourceManager);
        ModelPools.load(resourceManager);
        DungeonType.load(resourceManager);
        Theme.loadJson(resourceManager);
        SpawnRates.loadJson(resourceManager);
        RandomItems.loadJson(resourceManager);
        RandomMonster.loadJson(resourceManager);
        RandomEquipment.loadJson(resourceManager);
        RandomPotionEffect.loadJson(resourceManager);
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            ModelBlockDefinition.loadJson(resourceManager);
        }
        DungeonCrawl.LOGGER.debug("Finishing...");
        UPDATEABLES.forEach(Updateable::update);
        UPDATEABLES.clear();
        DungeonCrawl.LOGGER.info("Done.");
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.m_7242_();
            reloadProfiler.m_6180_("listener");
            this.reload(resourceManager);
            reloadProfiler.m_7238_();
            reloadProfiler.m_7241_();
        }, gameExecutor);
    }
}

