/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gigaherz.eyes.EyesInTheDarkness;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    @Mod.EventBusSubscriber(modid="eyesinthedarkness", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class EventHandler {
        private static Collection<Biome> biomes = null;
        private static Biome.SpawnListEntry eyesEntry = null;

        private EventHandler() {
        }

        @SubscribeEvent
        public static void onLoad(ModConfig.Loading configEvent) {
            if (configEvent.getConfig().getSpec() != SERVER_SPEC) {
                return;
            }
            if (eyesEntry != null) {
                biomes.stream().map(biome -> biome.func_76747_a(EntityClassification.MONSTER)).forEach(list -> list.remove(eyesEntry));
                biomes = Collections.emptyList();
            }
            if (((Boolean)ConfigData.SERVER.EnableNaturalSpawn.get()).booleanValue()) {
                int currentWeight = (Integer)ConfigData.SERVER.OverrideWeight.get();
                if (currentWeight < 0) {
                    int daysBefore = EyesInTheDarkness.getDaysUntilNextHalloween();
                    int weightMin = 15;
                    int weightMax = 150;
                    currentWeight = weightMin + (weightMax - weightMin) * (30 - daysBefore) / 30;
                }
                if (currentWeight > 0) {
                    biomes = ForgeRegistries.BIOMES.getValues();
                    if (ConfigData.SERVER.BiomeWhitelist.get() != null && ((List)ConfigData.SERVER.BiomeWhitelist.get()).size() > 0) {
                        HashSet whitelist = Sets.newHashSet((Iterable)((Iterable)ConfigData.SERVER.BiomeWhitelist.get()));
                        biomes = biomes.stream().filter(b -> whitelist.contains(b.getRegistryName().toString())).collect(Collectors.toList());
                    } else if (ConfigData.SERVER.BiomeBlacklist.get() != null && ((List)ConfigData.SERVER.BiomeBlacklist.get()).size() > 0) {
                        HashSet blacklist = Sets.newHashSet((Iterable)((Iterable)ConfigData.SERVER.BiomeBlacklist.get()));
                        biomes = biomes.stream().filter(b -> !blacklist.contains(b.getRegistryName().toString())).collect(Collectors.toList());
                    }
                    eyesEntry = new Biome.SpawnListEntry(EyesInTheDarkness.eyes_entity, currentWeight, ((Integer)ConfigData.SERVER.MinimumPackSize.get()).intValue(), ((Integer)ConfigData.SERVER.MaximumPackSize.get()).intValue());
                    biomes.stream().map(biome -> biome.func_76747_a(EntityClassification.MONSTER)).forEach(list -> list.add(eyesEntry));
                }
            }
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue EnableNaturalSpawn;
        public final ForgeConfigSpec.IntValue OverrideWeight;
        public final ForgeConfigSpec.IntValue MinimumPackSize;
        public final ForgeConfigSpec.IntValue MaximumPackSize;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> BiomeWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> BiomeBlacklist;
        public final ForgeConfigSpec.BooleanValue Jumpscare;
        public final ForgeConfigSpec.IntValue JumpscareHurtLevel;
        public final ForgeConfigSpec.BooleanValue EyesCanAttackWhileLit;
        public final ForgeConfigSpec.BooleanValue EnableEyeAggressionEscalation;
        public final ForgeConfigSpec.BooleanValue EyeAggressionDependsOnLocalDifficulty;
        public final ForgeConfigSpec.BooleanValue EyeAggressionDependsOnLightLevel;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.EnableNaturalSpawn = builder.comment("If false, the eyes entity will not spawn naturally during the night-").define("enableNaturalSpawn", true);
            this.OverrideWeight = builder.comment("If -1, the default spawn weight will be used.").defineInRange("overrideWeight", -1, -1, Integer.MAX_VALUE);
            this.MinimumPackSize = builder.defineInRange("minimumPackSize", 1, 1, Integer.MAX_VALUE);
            this.MaximumPackSize = builder.defineInRange("maximumPackSize", 2, 1, Integer.MAX_VALUE);
            this.BiomeWhitelist = builder.comment("If not empty, this list of biomes will be used instead of all biomes. The blacklist will not take effect.").defineList("whitelist", (List)Lists.newArrayList(), o -> o instanceof String);
            this.BiomeBlacklist = builder.comment("If the whitelist is not used, this list contains biomes excluded from the list of all biomes.").defineList("blacklist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:void"}), o -> o instanceof String);
            this.Jumpscare = builder.comment("Set to false to disable the jumpscare system.").define("jumpscare", true);
            this.JumpscareHurtLevel = builder.comment("Set to a number > 0 to cause the jumpscare to apply poison the player. A value of 5 will take around half of the health. ").defineInRange("jumpscareHurtLevel", 1, 0, 6);
            this.EyesCanAttackWhileLit = builder.comment("While set to true, the eyes entity will ignore the artificial light level and will jumpscare even if it's lit. Daylight will still disable it's AI.").define("eyesCanAttackWhileLit", true);
            builder.pop();
            builder.push("eye_aggression");
            this.EnableEyeAggressionEscalation = builder.comment("While set to true, the eyes entities will progressively get more bold, and move faster, the longer they live.").define("enableEscalation", true);
            this.EyeAggressionDependsOnLocalDifficulty = builder.comment("While set to true, the eyes entities will spawn with higher aggresion levels in higher local difficulties.").define("localDifficulty", true);
            this.EyeAggressionDependsOnLightLevel = builder.comment("While set to true, the eyes entities will have higher aggression values on lower light levels.").define("lightLevel", true);
            builder.pop();
        }
    }
}

