/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.entity.EyesEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;

public class EyesRenderer
extends EntityRenderer<EyesEntity> {
    private static final ResourceLocation TEXTURE = EyesInTheDarkness.location("textures/entity/eyes1.png");

    public EyesRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(EyesEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float mixAlpha;
        BlockPos position = entity.getBlockPosEyes();
        float blockLight = entity.field_70170_p.func_175642_b(LightType.BLOCK, position);
        if (entity.field_70170_p.field_73011_w.func_191066_m()) {
            float skyLight = (float)entity.field_70170_p.func_175642_b(LightType.SKY, position) - (1.0f - entity.field_70170_p.field_73011_w.getSunBrightness(partialTicks)) * 11.0f;
            blockLight = Math.max(blockLight, skyLight);
        }
        if ((mixAlpha = MathHelper.func_76131_a((float)((8.0f - blockLight) / 8.0f), (float)0.0f, (float)1.0f)) <= 0.0f) {
            return;
        }
        this.func_110776_a(this.getEntityTexture(entity));
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.translated((double)0.0, (double)entity.func_70047_e(), (double)0.0);
        float viewerYaw = this.field_76990_c.field_78735_i;
        float viewerPitch = this.field_76990_c.field_78732_j;
        GlStateManager.rotatef((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
        float aggro = entity.getAggroLevel();
        float aggroColorAdjust = 1.0f - MathHelper.func_76131_a((float)aggro, (float)0.0f, (float)1.0f);
        GlStateManager.color4f((float)1.0f, (float)aggroColorAdjust, (float)aggroColorAdjust, (float)mixAlpha);
        Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float w = 0.5f;
        float h = 0.1923077f;
        float tw = 0.40625f;
        float th = 0.15625f;
        float hoff = 0.0f;
        if (entity.blinkingState) {
            int half_blink = 2;
            hoff = entity.blinkProgress < half_blink ? (float)MathHelper.func_76141_d((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink)) * 0.15625f : (float)Math.max(0, 8 - MathHelper.func_76141_d((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink))) * 0.15625f;
        }
        buffer.func_181662_b(-0.25, -0.09615384787321091, 0.0).func_187315_a(0.0, (double)(hoff + 0.15625f)).func_181675_d();
        buffer.func_181662_b(-0.25, 0.09615384787321091, 0.0).func_187315_a(0.0, (double)hoff).func_181675_d();
        buffer.func_181662_b(0.25, 0.09615384787321091, 0.0).func_187315_a(0.40625, (double)hoff).func_181675_d();
        buffer.func_181662_b(0.25, -0.09615384787321091, 0.0).func_187315_a(0.40625, (double)(hoff + 0.15625f)).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
        Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)240.0f, (float)240.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableLighting();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EyesEntity entity) {
        return TEXTURE;
    }
}

