/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.entity;

import gigaherz.eyes.ConfigData;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.InitiateJumpscarePacket;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkHooks;

public class EyesEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> IS_DORMANT = EntityDataManager.func_187226_a(EyesEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AGGRO = EntityDataManager.func_187226_a(EyesEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final float AGGRO_ESCALATION_PER_TICK = 1.6666666E-4f;
    private static final double SPEED_NO_AGGRO = (double)0.1f;
    private static final double SPEED_FULL_AGGRO = 0.5;
    public static final int BLINK_DURATION = 5;
    public boolean blinkingState;
    public int blinkProgress;
    private static Random RAND = new Random();

    public EyesEntity(EntityType<? extends EyesEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGGRO, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(IS_DORMANT, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.1));
        this.field_70714_bg.func_75776_a(8, (Goal)new CreepTowardPlayer(this, this::getSpeedFromAggro));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public float getAggroLevel() {
        return ((Float)this.func_184212_Q().func_187225_a(AGGRO)).floatValue();
    }

    public void setAggroLevel(float aggro) {
        this.func_184212_Q().func_187227_b(AGGRO, (Object)Float.valueOf(MathHelper.func_76131_a((float)aggro, (float)0.0f, (float)1.0f)));
    }

    public boolean getIsDormant() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_DORMANT);
    }

    public void setIsDormant(boolean value) {
        this.func_184212_Q().func_187227_b(IS_DORMANT, (Object)value);
    }

    private double getSpeedFromAggro() {
        if (this.getIsDormant()) {
            return 0.0;
        }
        return MathHelper.func_151238_b((double)this.getAggroLevel(), (double)0.1f, (double)0.5);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (((Boolean)ConfigData.SERVER.EyeAggressionDependsOnLocalDifficulty.get()).booleanValue()) {
            float difficulty = difficultyIn.func_180170_c();
            this.setAggroLevel(RAND.nextFloat() * difficulty);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean jumpScared;
        boolean bl = jumpScared = (Boolean)ConfigData.SERVER.Jumpscare.get() != false && entityIn instanceof ServerPlayerEntity;
        if (jumpScared) {
            this.jumpscare((ServerPlayerEntity)entityIn);
        }
        if ((Integer)ConfigData.SERVER.JumpscareHurtLevel.get() > 0 && entityIn instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityIn;
            living.func_195064_c(new EffectInstance(Effects.field_76436_u, 100, (Integer)ConfigData.SERVER.JumpscareHurtLevel.get() - 1));
        }
        this.disappear(!jumpScared);
        return true;
    }

    public void jumpscare(ServerPlayerEntity player) {
        EyesInTheDarkness.channel.sendTo((Object)new InitiateJumpscarePacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.getIsDormant()) {
                return;
            }
            if (!this.blinkingState) {
                if (RAND.nextFloat() < 0.02f) {
                    this.blinkingState = true;
                    this.blinkProgress = 0;
                }
            } else {
                ++this.blinkProgress;
                if (this.blinkProgress >= 5) {
                    this.blinkingState = false;
                }
            }
            return;
        }
        this.setIsDormant(this.isIlluminated((Boolean)ConfigData.SERVER.EyesCanAttackWhileLit.get()));
        if (this.getIsDormant()) {
            return;
        }
        float maxWatchDistance = 16.0f;
        Vec3d eyes = this.func_174824_e(1.0f);
        List entities = this.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB(eyes.field_72450_a - (double)maxWatchDistance, eyes.field_72448_b - (double)maxWatchDistance, eyes.field_72449_c - (double)maxWatchDistance, eyes.field_72450_a + (double)maxWatchDistance, eyes.field_72448_b + (double)maxWatchDistance, eyes.field_72449_c + (double)maxWatchDistance), player -> {
            if (player.func_174824_e(1.0f).func_72438_d(eyes) > (double)maxWatchDistance) {
                return false;
            }
            Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
            Vec3d vec3d1 = new Vec3d(this.func_226277_ct_() - player.func_226277_ct_(), this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.func_226278_cu_() + (double)player.func_70047_e()), this.func_226281_cx_() - player.func_226281_cx_());
            double d0 = vec3d1.func_72433_c();
            double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
            return d1 > 1.0 - 0.025 / d0 && player.func_70685_l((Entity)this);
        });
        if (entities.size() > 0) {
            this.disappear(true);
            return;
        }
        if (((Boolean)ConfigData.SERVER.EnableEyeAggressionEscalation.get()).booleanValue() && !this.getIsDormant()) {
            this.setAggroLevel(this.getAggroLevel() + 1.6666666E-4f);
        }
    }

    public boolean func_70662_br() {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof PlayerEntity) {
            this.disappear(true);
        }
    }

    private void disappear(boolean playDeathSound) {
        this.func_70665_d(DamageSource.field_76377_j, 1.0f);
        if (playDeathSound) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected void func_85033_bc() {
        super.func_85033_bc();
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    protected void func_70609_aI() {
        this.field_70725_aQ = 19;
        super.func_70609_aI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return EyesInTheDarkness.eyes_laugh;
    }

    protected SoundEvent func_184615_bR() {
        return EyesInTheDarkness.eyes_disappear;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return EyesInTheDarkness.eyes_disappear;
    }

    public BlockPos getBlockPosEyes() {
        return new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSunBrightness() {
        float f = this.field_70170_p.func_72826_c(1.0f);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.field_70170_p.func_72867_j(1.0f) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.field_70170_p.func_72819_i(1.0f) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    private float getLightLevel(boolean excludeDaylight) {
        BlockPos position = this.getBlockPosEyes();
        float blockLight = 0.0f;
        if (excludeDaylight) {
            if (this.field_70170_p.field_73011_w.func_191066_m()) {
                float skyLight1;
                float skyLight = (float)this.field_70170_p.func_226658_a_(LightType.SKY, position) - (1.0f - this.getSunBrightness()) * 11.0f;
                if (skyLight != (skyLight1 = (float)(this.field_70170_p.func_226658_a_(LightType.SKY, position) - this.field_70170_p.func_175657_ab()))) {
                    // empty if block
                }
                blockLight = Math.max(blockLight, skyLight);
            }
        } else {
            blockLight = this.field_70170_p.func_201696_r(position);
        }
        return blockLight;
    }

    private boolean isIlluminated(boolean excludeDaylight) {
        float blockLight = this.getLightLevel(excludeDaylight);
        return blockLight >= 8.0f;
    }

    private static class CreepTowardPlayer
    extends Goal {
        protected final CreatureEntity attacker;
        private final EyesEntity eyes;
        private final DoubleSupplier speedGetter;
        protected int attackTick;
        private Path path;
        private int delayCounter;
        private double targetX;
        private double targetY;
        private double targetZ;

        public CreepTowardPlayer(EyesEntity creature, DoubleSupplier speedGetter) {
            this.attacker = creature;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.speedGetter = speedGetter;
            this.eyes = creature;
        }

        public boolean func_75250_a() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            LivingEntity targetPlayer = this.attacker.func_70638_az();
            if (targetPlayer == null || !targetPlayer.func_70089_S()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)targetPlayer, 0);
            return this.path != null || this.isWithinRange(targetPlayer);
        }

        public void func_75249_e() {
            this.attacker.func_70661_as().func_75484_a(this.path, this.speedGetter.getAsDouble());
            this.attacker.func_213395_q(true);
            this.delayCounter = 0;
        }

        public boolean func_75253_b() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            if (this.isPlayerLookingInMyGeneralDirection()) {
                return false;
            }
            LivingEntity livingentity = this.attacker.func_70638_az();
            if (livingentity == null || !livingentity.func_70089_S()) {
                return false;
            }
            return !this.attacker.func_70661_as().func_75500_f();
        }

        private boolean isWithinRange(LivingEntity targetPlayer) {
            return this.getAttackReachSqr(targetPlayer) >= this.attacker.func_70092_e(targetPlayer.func_226277_ct_(), targetPlayer.func_174813_aQ().field_72338_b, targetPlayer.func_226281_cx_());
        }

        private boolean isPlayerLookingInMyGeneralDirection() {
            if (this.eyes.getIsDormant()) {
                return false;
            }
            Vec3d selfPos = this.eyes.func_213303_ch();
            LivingEntity target = this.eyes.func_70638_az();
            if (target == null) {
                return false;
            }
            Vec3d playerPos = target.func_213303_ch();
            Vec3d lookVec = target.func_70040_Z();
            Vec3d playerLook = new Vec3d(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
            playerLook.func_72432_b();
            playerPos.func_178788_d(selfPos);
            playerPos.func_72432_b();
            return playerLook.func_72430_b(playerPos) < 0.0;
        }

        public void func_75251_c() {
            LivingEntity livingentity = this.attacker.func_70638_az();
            if (!EntityPredicates.field_188444_d.test(livingentity)) {
                this.attacker.func_70624_b(null);
            }
            this.attacker.func_213395_q(false);
            this.attacker.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            LivingEntity targetPlayer = this.attacker.func_70638_az();
            this.attacker.func_70671_ap().func_75651_a((Entity)targetPlayer, 30.0f, 30.0f);
            double distanceSquared = this.attacker.func_70092_e(targetPlayer.func_226277_ct_(), targetPlayer.func_174813_aQ().field_72338_b, targetPlayer.func_226281_cx_());
            --this.delayCounter;
            if (this.attacker.func_70635_at().func_75522_a((Entity)targetPlayer) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || targetPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
                this.targetX = targetPlayer.func_226277_ct_();
                this.targetY = targetPlayer.func_174813_aQ().field_72338_b;
                this.targetZ = targetPlayer.func_226281_cx_();
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                if (distanceSquared > 1024.0) {
                    this.delayCounter += 10;
                } else if (distanceSquared > 256.0) {
                    this.delayCounter += 5;
                }
                if (!this.attacker.func_70661_as().func_75497_a((Entity)targetPlayer, this.speedGetter.getAsDouble())) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            this.checkAndPerformAttack(targetPlayer, distanceSquared);
        }

        protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
            double reachSqr = this.getAttackReachSqr(enemy);
            if (distToEnemySqr <= reachSqr && this.attackTick <= 0) {
                this.attackTick = 20;
                this.attacker.func_184609_a(Hand.MAIN_HAND);
                this.attacker.func_70652_k((Entity)enemy);
            }
        }

        protected double getAttackReachSqr(LivingEntity attackTarget) {
            return this.attacker.func_213311_cf() * 2.0f * this.attacker.func_213311_cf() * 2.0f + attackTarget.func_213311_cf();
        }
    }
}

