/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes;

import gigaherz.eyes.ConfigData;
import gigaherz.eyes.InitiateJumpscarePacket;
import gigaherz.eyes.entity.EyesEntity;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="eyesinthedarkness")
public class EyesInTheDarkness {
    public static final String MODID = "eyesinthedarkness";
    public static final Logger LOGGER = LogManager.getLogger((String)"eyesinthedarkness");
    @ObjectHolder(value="eyesinthedarkness:eyes_laugh")
    public static SoundEvent eyes_laugh;
    @ObjectHolder(value="eyesinthedarkness:eyes_disappear")
    public static SoundEvent eyes_disappear;
    @ObjectHolder(value="eyesinthedarkness:eyes_jumpscare")
    public static SoundEvent eyes_jumpscare;
    private static final NonNullLazy<EntityType<EyesEntity>> eyesInit;
    private static final String CHANNEL = "main";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public EyesInTheDarkness() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(SoundEvent.class, this::registerSounds);
        modEventBus.addGenericListener(EntityType.class, this::registerEntities);
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addListener(this::commonSetup);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigData.CLIENT_SPEC);
        MinecraftForge.EVENT_BUS.addListener(this::entityInit);
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.laugh")).setRegistryName(EyesInTheDarkness.location("eyes_laugh")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.disappear")).setRegistryName(EyesInTheDarkness.location("eyes_disappear")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.jumpscare")).setRegistryName(EyesInTheDarkness.location("eyes_jumpscare"))});
    }

    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{(EntityType)((EntityType)eyesInit.get()).setRegistryName("eyesinthedarkness:eyes")});
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)eyesInit.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ConfigData::canEyesSpawnAt);
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new SpawnEggItem((EntityType)eyesInit.get(), 0, 0x7F0000, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(EyesInTheDarkness.location("eyes_spawn_egg"))});
    }

    public static int getDaysUntilNextHalloween() {
        Calendar nextHalloween;
        Calendar now = Calendar.getInstance();
        if (now.after(nextHalloween = new Calendar.Builder().setDate(now.get(1), 9, 31).setTimeOfDay(23, 59, 59, 999).build())) {
            nextHalloween.add(1, 1);
        }
        return (int)Math.min(ChronoUnit.DAYS.between(now.toInstant(), nextHalloween.toInstant()), 30L);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, InitiateJumpscarePacket.class, InitiateJumpscarePacket::encode, InitiateJumpscarePacket::new, InitiateJumpscarePacket::handle);
        LOGGER.debug("Final message number: " + messageNumber);
        GlobalEntityTypeAttributes.put(EyesEntity.TYPE, (AttributeModifierMap)EyesEntity.prepareAttributes().func_233813_a_());
    }

    public void entityInit(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        if (e instanceof WolfEntity) {
            WolfEntity wolf = (WolfEntity)e;
            wolf.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)wolf, EyesEntity.class, false));
        }
        if (e instanceof OcelotEntity) {
            OcelotEntity cat = (OcelotEntity)e;
            cat.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)cat, EyesEntity.class, 6.0f, 1.0, 1.2));
        }
    }

    public static ResourceLocation location(String location) {
        return new ResourceLocation(MODID, location);
    }

    static {
        eyesInit = NonNullLazy.of(() -> EntityType.Builder.func_220322_a(EyesEntity::new, (EntityClassification)EyesEntity.CLASSIFICATION).setTrackingRange(80).setUpdateInterval(3).setCustomClientFactory((ent, world) -> (EyesEntity)EyesEntity.TYPE.func_200721_a(world)).setShouldReceiveVelocityUpdates(true).func_206830_a("eyesinthedarkness:eyes"));
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)EyesInTheDarkness.location(CHANNEL)).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

