/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gigaherz.eyes.EyesInTheDarkness;
import gigaherz.eyes.entity.EyesEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.LightType;

public class EyesRenderer
extends EntityRenderer<EyesEntity> {
    private static final ResourceLocation TEXTURE = EyesInTheDarkness.location("textures/entity/eyes1.png");
    private final RenderType renderType = RenderType.func_228644_e_((ResourceLocation)TEXTURE);

    public EyesRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(EyesEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float mixAlpha;
        BlockPos position = entity.getBlockPosEyes();
        float blockLight = entity.field_70170_p.func_226658_a_(LightType.BLOCK, position);
        if (entity.field_70170_p.func_230315_m_().func_218272_d()) {
            float skyLight = (float)entity.field_70170_p.func_226658_a_(LightType.SKY, position) - (1.0f - ((ClientWorld)entity.field_70170_p).func_228326_g_(partialTicks)) * 11.0f;
            blockLight = Math.max(blockLight, skyLight);
        }
        if ((mixAlpha = MathHelper.func_76131_a((float)((8.0f - blockLight) / 8.0f), (float)0.0f, (float)1.0f)) <= 0.0f) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)entity.func_70047_e(), 0.0);
        matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        float aggro = entity.getAggroLevel();
        float aggroColorAdjust = 1.0f - MathHelper.func_76131_a((float)aggro, (float)0.0f, (float)1.0f);
        float w = 0.25f;
        float h = 0.09615385f;
        float tw = 0.40625f;
        float th = 0.15625f;
        float hoff = this.getBlinkState(entity, partialTicks, 0.15625f);
        int packedOverlayCoords = OverlayTexture.field_229196_a_;
        int packedLightmapCoords = 0xF000F0;
        IVertexBuilder buffer = bufferIn.getBuffer(this.renderType);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, -0.25f, -0.09615385f, 0.0f).func_227885_a_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).func_225583_a_(0.0f, hoff + 0.15625f).func_227891_b_(packedOverlayCoords).func_227886_a_(packedLightmapCoords).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, -0.25f, 0.09615385f, 0.0f).func_227885_a_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).func_225583_a_(0.0f, hoff).func_227891_b_(packedOverlayCoords).func_227886_a_(packedLightmapCoords).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, 0.25f, 0.09615385f, 0.0f).func_227885_a_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).func_225583_a_(0.40625f, hoff).func_227891_b_(packedOverlayCoords).func_227886_a_(packedLightmapCoords).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, 0.25f, -0.09615385f, 0.0f).func_227885_a_(1.0f, aggroColorAdjust, aggroColorAdjust, mixAlpha).func_225583_a_(0.40625f, hoff + 0.15625f).func_227891_b_(packedOverlayCoords).func_227886_a_(packedLightmapCoords).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, bufferIn, packedLightIn);
    }

    private float getBlinkState(EyesEntity entity, float partialTicks, float th) {
        float hoff = 0.0f;
        if (entity.blinkingState) {
            int half_blink = 2;
            hoff = entity.blinkProgress < half_blink ? (float)MathHelper.func_76141_d((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink)) * th : (float)Math.max(0, 8 - MathHelper.func_76141_d((float)(((float)entity.blinkProgress + partialTicks) * 4.0f / (float)half_blink))) * th;
        }
        return hoff;
    }

    @Nullable
    public ResourceLocation getEntityTexture(EyesEntity entity) {
        return TEXTURE;
    }
}

