/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="giantspawn")
@Config.LangKey(value="Giant Spawn Config")
public class ModConfig {
    @Config.Comment(value={"The chance a zombie spawn is a giant."})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double chanceSurfaceZombieIsGiant = 0.025;
    @Config.Comment(value={"If enabled, burns giants when daylight shines upon them."})
    public static boolean shouldBurnGiantsInDaylight = true;
    @Config.Comment(value={"If enabled, a giant will only spawn on the surface."})
    public static boolean onlySpawnGiantOnSurface = true;

    @Mod.EventBusSubscriber(modid="giantspawn")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("giantspawn")) {
                ConfigManager.sync((String)"giantspawn", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

