/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn.events;

import com.natamus.giantspawn.config.ModConfig;
import com.natamus.giantspawn.util.Util;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class GiantEvent {
    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof EntityZombie)) {
            return;
        }
        Set tags = entity.func_184216_O();
        if (tags.contains("giantspawn")) {
            return;
        }
        double num = Math.random();
        if (num <= ModConfig.chanceSurfaceZombieIsGiant) {
            if (ModConfig.onlySpawnGiantOnSurface) {
                Boolean onsurface = true;
                BlockPos epos = entity.func_180425_c();
                for (int x = epos.func_177956_o(); x <= 255; ++x) {
                    BlockPos cp = epos.func_185334_h().func_177981_b(x - epos.func_177956_o());
                    Block block = world.func_180495_p(cp).func_177230_c();
                    if (Util.isSurfaceBlock(block).booleanValue()) continue;
                    onsurface = false;
                    break;
                }
                if (!onsurface.booleanValue()) {
                    return;
                }
            }
            Vec3d zvec = entity.func_174791_d();
            EntityGiantZombie giant = new EntityGiantZombie(world);
            giant.func_70107_b(zvec.field_72450_a, zvec.field_72448_b, zvec.field_72449_c);
            world.func_72838_d((Entity)giant);
            entity.func_70106_y();
        }
        entity.func_184211_a("giantspawn");
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (!ModConfig.shouldBurnGiantsInDaylight) {
            return;
        }
        World world = e.world;
        if (world.field_72995_K) {
            return;
        }
        if (!world.func_72935_r()) {
            return;
        }
        for (Entity entity : world.field_72996_f) {
            if (!(entity instanceof EntityGiantZombie) || entity.func_70090_H()) continue;
            entity.func_70015_d(1);
        }
    }
}

