/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn.events;

import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.giantspawn.ai.GiantAttackGoal;
import com.natamus.giantspawn.ai.GiantAttackTurtleEggGoal;
import com.natamus.giantspawn.config.ConfigHandler;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GiantEvent {
    private static CopyOnWriteArrayList<Entity> giants = new CopyOnWriteArrayList();
    int currentticks = 1;

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof GiantEntity)) {
            return;
        }
        if (!giants.contains(entity)) {
            giants.add(entity);
        }
        GiantEntity giant = (GiantEntity)entity;
        giant.field_70714_bg.func_75776_a(4, (Goal)new GiantAttackTurtleEggGoal((CreatureEntity)giant, 2.0, 3));
        giant.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)giant, PlayerEntity.class, 8.0f));
        giant.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)giant));
        giant.field_70714_bg.func_75776_a(2, (Goal)new GiantAttackGoal(giant, 2.0, false));
        giant.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)giant, 2.0));
        giant.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, PlayerEntity.class, true));
        giant.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, AbstractVillagerEntity.class, false));
        giant.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, IronGolemEntity.class, true));
        giant.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
        giant.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        giant.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f * (Double)ConfigHandler.GENERAL.giantMovementSpeedModifier.get());
        giant.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0 * (Double)ConfigHandler.GENERAL.giantAttackDamageModifier.get());
        giant.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (this.currentticks % 20 != 0) {
            ++this.currentticks;
            return;
        }
        this.currentticks = 1;
        if (!((Boolean)ConfigHandler.GENERAL.shouldBurnGiantsInDaylight.get()).booleanValue()) {
            return;
        }
        if (!world.func_72935_r()) {
            return;
        }
        for (Entity giant : giants) {
            if (giant.func_70089_S()) {
                BlockPos epos;
                if (giant.func_203008_ap() || !BlockPosFunctions.isOnSurface((World)world, (BlockPos)(epos = giant.func_180425_c())).booleanValue()) continue;
                giant.func_70015_d(3);
                continue;
            }
            giants.remove(giant);
        }
    }
}

