/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigHandler {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class General {
        public final ForgeConfigSpec.ConfigValue<Double> chanceSurfaceZombieIsGiant;
        public final ForgeConfigSpec.ConfigValue<Boolean> shouldBurnGiantsInDaylight;
        public final ForgeConfigSpec.ConfigValue<Boolean> onlySpawnGiantOnSurface;
        public final ForgeConfigSpec.ConfigValue<Double> giantMovementSpeedModifier;
        public final ForgeConfigSpec.ConfigValue<Double> giantAttackDamageModifier;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.chanceSurfaceZombieIsGiant = builder.comment("The chance a zombie that has spawned on the surface is a giant.").defineInRange("chanceSurfaceZombieIsGiant", 0.05, 0.0, 1.0);
            this.shouldBurnGiantsInDaylight = builder.comment("If enabled, burns giants when daylight shines upon them.").define("shouldBurnGiantsInDaylight", true);
            this.onlySpawnGiantOnSurface = builder.comment("If enabled, a giant will only spawn on the surface.").define("onlySpawnGiantOnSurface", true);
            this.giantMovementSpeedModifier = builder.comment("The giant movement speed modifier relative to the base zombie movement speed.").defineInRange("giantMovementSpeedModifier", 1.0, 0.0, 20.0);
            this.giantAttackDamageModifier = builder.comment("The giant attack damage modifier relative to the base zombie attack damage.").defineInRange("giantAttackDamageModifier", 2.0, 0.0, 20.0);
            builder.pop();
        }
    }
}

