/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn.events;

import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.giantspawn.ai.GiantAttackGoal;
import com.natamus.giantspawn.ai.GiantAttackTurtleEggGoal;
import com.natamus.giantspawn.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GiantEvent {
    private static List<Entity> giants = new ArrayList<Entity>();

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof GiantEntity)) {
            return;
        }
        if (!giants.contains(entity)) {
            giants.add(entity);
        }
        GiantEntity giant = (GiantEntity)entity;
        giant.field_70714_bg.func_75776_a(4, (Goal)new GiantAttackTurtleEggGoal((CreatureEntity)giant, 2.0, 3));
        giant.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)giant, PlayerEntity.class, 8.0f));
        giant.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)giant));
        giant.field_70714_bg.func_75776_a(2, (Goal)new GiantAttackGoal(giant, 2.0, false));
        giant.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)giant, 2.0));
        giant.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, PlayerEntity.class, true));
        giant.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, AbstractVillagerEntity.class, false));
        giant.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, IronGolemEntity.class, true));
        giant.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)giant, TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
        giant.func_110148_a(Attributes.field_233819_b_).func_111128_a(35.0);
        giant.func_110148_a(Attributes.field_233821_d_).func_111128_a((double)0.23f * (Double)ConfigHandler.GENERAL.giantMovementSpeedModifier.get());
        giant.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0 * (Double)ConfigHandler.GENERAL.giantAttackDamageModifier.get());
        giant.func_110148_a(Attributes.field_233826_i_).func_111128_a(2.0);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)ConfigHandler.GENERAL.shouldBurnGiantsInDaylight.get()).booleanValue()) {
            return;
        }
        if (!world.func_72935_r()) {
            return;
        }
        Iterator<Entity> iterator = giants.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity.func_70089_S()) {
                BlockPos epos;
                if (entity.func_203008_ap() || !BlockPosFunctions.isOnSurface((World)world, (BlockPos)(epos = entity.func_233580_cy_())).booleanValue()) continue;
                entity.func_70015_d(3);
                continue;
            }
            iterator.remove();
        }
    }
}

