/*
 * Decompiled with CFR 0.152.
 */
package moderncreater.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moderncreater.CollisionHelper;
import moderncreater.Register;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Bathroom
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB SIDE_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB BOTTOM = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final AxisAlignedBB TOP_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BOTTOM_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    EnumFacing enumfacing = EnumFacing.NORTH;

    public Bathroom(String unlocalizedName) {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("moderncreater", unlocalizedName));
        this.func_149672_a(SoundType.field_185853_f);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Register.itembox);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.func_180495_p(pos).func_177230_c().equals(Register.bathroomTopBlock)) {
            worldIn.func_175656_a(pos, Register.bathroomWorkTopBlock.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
        }
        if (worldIn.func_180495_p(pos).func_177230_c().equals(Register.bathroomBotBlock)) {
            if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c().equals(Register.bathroomTopBlock)) {
                worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), Register.bathroomWorkTopBlock.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
            } else if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c().equals(Register.bathroomWorkTopBlock)) {
                worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), Register.bathroomTopBlock.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
            }
        }
        return true;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() == Register.bathroomTopBlock) {
            worldIn.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        }
        if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c() == Register.bathroomBotBlock) {
            worldIn.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
        }
        if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() == Register.bathroomWorkTopBlock) {
            worldIn.func_175698_g(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177230_c() == Register.bathroomTopBlock ? TOP_BOUNDING_BOX : BOTTOM_BOUNDING_BOX;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177230_c() == Register.bathroomBotBlock) {
            list.add(BOTTOM);
        }
        if (facing != EnumFacing.NORTH) {
            list.add(SIDE_SOUTH);
        }
        if (facing != EnumFacing.SOUTH) {
            list.add(SIDE_NORTH);
        }
        if (facing != EnumFacing.EAST) {
            list.add(SIDE_WEST);
        }
        if (facing != EnumFacing.WEST) {
            list.add(SIDE_EAST);
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> boxes = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos), worldIn, pos);
        for (AxisAlignedBB box2 : boxes) {
            Bathroom.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box2);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos), world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = this.enumfacing;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.enumfacing = EnumFacing.SOUTH;
        }
        if (l == 1) {
            this.enumfacing = EnumFacing.WEST;
        }
        if (l == 2) {
            this.enumfacing = EnumFacing.NORTH;
        }
        if (l == 3) {
            this.enumfacing = EnumFacing.EAST;
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

