/*
 * Decompiled with CFR 0.152.
 */
package moderncreator.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Random;
import moderncreator.Register;
import moderncreator.extra.VoxelShapeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class HomeRinger
extends Block {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public HomeRinger(String unlocalizedName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(4.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName(unlocalizedName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return true;
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_184133_a(player, pos, Register.door_bell, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.updateNeighbors(state, worldIn, pos);
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return false;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            worldIn.func_175646_b(pos, worldIn.func_175625_s(pos));
        }
    }

    private void updateNeighbors(BlockState p_196368_1_, World p_196368_2_, BlockPos p_196368_3_) {
        p_196368_2_.func_195593_d(p_196368_3_, (Block)this);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] Main = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)7.2, (double)6.4, (double)0.0, (double)10.4, (double)11.2, (double)1.6), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(Main[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)POWERED, this.func_176223_P().func_177229_b((IProperty)POWERED));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)))).func_206870_a((IProperty)POWERED, this.func_176223_P().func_177229_b((IProperty)POWERED));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING))).func_206870_a((IProperty)POWERED, this.func_176223_P().func_177229_b((IProperty)POWERED));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HORIZONTAL_FACING});
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

