/*
 * Decompiled with CFR 0.152.
 */
package moderncreator.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Random;
import moderncreator.Register;
import moderncreator.extra.VoxelShapeHelper;
import moderncreator.tileentity.TileEntityRefrigerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class Refrigerator
extends ContainerBlock {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

    public Refrigerator(String unlocalizedName) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(5.0f).func_200947_a(SoundType.field_185858_k));
        this.setRegistryName(unlocalizedName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_180495_p(pos).func_177230_c() == Register.refrigeratorTopBlock) {
                if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c() == Register.refrigeratorBotBlock) {
                    this.interactWith(worldIn, new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), player);
                }
            } else if (worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() == Register.refrigeratorTopBlock) {
                this.interactWith(worldIn, pos, player);
            }
        }
        return true;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) != worldIn.func_175640_z(pos)) {
            if (flag) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)LIT), 2);
            }
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)LIT), 2);
        }
    }

    protected void interactWith(World worldIn, BlockPos pos, PlayerEntity player) {
        TileEntityRefrigerator tileentity = (TileEntityRefrigerator)worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRefrigerator) {
            player.func_213829_a((INamedContainerProvider)tileentity);
            player.func_195066_a(Stats.field_188061_aa);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        if (world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())).func_177230_c() == Register.refrigeratorTopBlock) {
            world.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), Blocks.field_150350_a.func_176223_P());
        }
        if (world.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())).func_177230_c() == Register.refrigeratorBotBlock) {
            world.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), Blocks.field_150350_a.func_176223_P());
        }
        return false;
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] B = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)0.0, (double)0.0, (double)2.4, (double)16.0, (double)16.0, (double)13.6), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(B[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HORIZONTAL_FACING});
        builder.func_206894_a(new IProperty[]{LIT});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRefrigerator();
    }
}

