/*
 * Decompiled with CFR 0.152.
 */
package moderncreator.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import moderncreator.Register;
import moderncreator.extra.VoxelShapeHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LampSide
extends Block {
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public final ImmutableMap<BlockState, VoxelShape> isWalln;
    public final ImmutableMap<BlockState, VoxelShape> isTablen;
    VoxelShape isfull = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public LampSide(String unlocalizedName, int l) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.3f).func_200947_a(SoundType.field_185853_f).func_235838_a_(level -> l).func_226896_b_());
        this.setRegistryName(unlocalizedName);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.isWalln = this.generateShapesisWalln((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
        this.isTablen = this.generateShapesisTablen((ImmutableList<BlockState>)this.func_176194_O().func_177619_a());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!world.field_72995_K) {
            if (this == Register.lampwallBlock) {
                world.func_180501_a(pos, (BlockState)Register.lampwallonBlock.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, world.func_180495_p(pos).func_177229_b((Property)HORIZONTAL_FACING)), 3);
            } else if (this == Register.lampwallonBlock) {
                world.func_180501_a(pos, (BlockState)Register.lampwallBlock.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, world.func_180495_p(pos).func_177229_b((Property)HORIZONTAL_FACING)), 3);
            }
            if (this == Register.lamptableBlock) {
                world.func_180501_a(pos, (BlockState)Register.lamptableonBlock.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, world.func_180495_p(pos).func_177229_b((Property)HORIZONTAL_FACING)), 3);
            } else if (this == Register.lamptableonBlock) {
                world.func_180501_a(pos, (BlockState)Register.lamptableBlock.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, world.func_180495_p(pos).func_177229_b((Property)HORIZONTAL_FACING)), 3);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapesisWalln(ImmutableList<BlockState> states) {
        VoxelShape[] isWalln = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)4.8, (double)2.88, (double)0.0, (double)11.2, (double)16.0, (double)12.8), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(isWalln[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapesisTablen(ImmutableList<BlockState> states) {
        VoxelShape[] isTablen = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.func_208617_a((double)4.8, (double)0.0, (double)1.6, (double)11.2, (double)11.52, (double)11.36), Direction.NORTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(isTablen[direction.func_176736_b()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        if (this == Register.lampwallBlock || this == Register.lampwallonBlock) {
            return (VoxelShape)this.isWalln.get((Object)state);
        }
        if (this == Register.lamptableBlock || this == Register.lamptableonBlock) {
            return (VoxelShape)this.isTablen.get((Object)state);
        }
        return this.isfull;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader reader, BlockPos pos) {
        if (this == Register.lampwallBlock || this == Register.lampwallonBlock) {
            return (VoxelShape)this.isWalln.get((Object)state);
        }
        if (this == Register.lamptableBlock || this == Register.lamptableonBlock) {
            return (VoxelShape)this.isTablen.get((Object)state);
        }
        return this.isfull;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING});
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

