/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CustomColors {
    private static String paletteFormatDefault = "vanilla";
    private static CustomColormap waterColors = null;
    private static CustomColormap foliagePineColors = null;
    private static CustomColormap foliageBirchColors = null;
    private static CustomColormap swampFoliageColors = null;
    private static CustomColormap swampGrassColors = null;
    private static CustomColormap[] colorsBlockColormaps = null;
    private static CustomColormap[][] blockColormaps = null;
    private static CustomColormap skyColors = null;
    private static CustomColorFader skyColorFader = new CustomColorFader();
    private static CustomColormap fogColors = null;
    private static CustomColorFader fogColorFader = new CustomColorFader();
    private static CustomColormap underwaterColors = null;
    private static CustomColorFader underwaterColorFader = new CustomColorFader();
    private static CustomColormap underlavaColors = null;
    private static CustomColorFader underlavaColorFader = new CustomColorFader();
    private static LightMapPack[] lightMapPacks = null;
    private static int lightmapMinDimensionId = 0;
    private static CustomColormap redstoneColors = null;
    private static CustomColormap xpOrbColors = null;
    private static int xpOrbTime = -1;
    private static CustomColormap durabilityColors = null;
    private static CustomColormap stemColors = null;
    private static CustomColormap stemMelonColors = null;
    private static CustomColormap stemPumpkinColors = null;
    private static CustomColormap myceliumParticleColors = null;
    private static boolean useDefaultGrassFoliageColors = true;
    private static int particleWaterColor = -1;
    private static int particlePortalColor = -1;
    private static int lilyPadColor = -1;
    private static int expBarTextColor = -1;
    private static int bossTextColor = -1;
    private static int signTextColor = -1;
    private static bcb fogColorNether = null;
    private static bcb fogColorEnd = null;
    private static bcb skyColorEnd = null;
    private static int[] spawnEggPrimaryColors = null;
    private static int[] spawnEggSecondaryColors = null;
    private static float[][] wolfCollarColors = null;
    private static float[][] sheepColors = null;
    private static int[] textColors = null;
    private static int[] mapColorsOriginal = null;
    private static int[] potionColors = null;
    private static final ars BLOCK_STATE_DIRT = akg.d.u();
    private static final ars BLOCK_STATE_WATER = akg.j.u();
    public static Random random = new Random();
    private static final IColorizer COLORIZER_GRASS = new IColorizer(){

        @Override
        public int getColor(ars blockState, aih blockAccess, cm blockPos) {
            aiq biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampGrassColors != null && biome == aiv.h) {
                return swampGrassColors.getColor(biome, blockPos);
            }
            return biome.b(blockPos);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE = new IColorizer(){

        @Override
        public int getColor(ars blockState, aih blockAccess, cm blockPos) {
            aiq biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (swampFoliageColors != null && biome == aiv.h) {
                return swampFoliageColors.getColor(biome, blockPos);
            }
            return biome.c(blockPos);
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_PINE = new IColorizer(){

        @Override
        public int getColor(ars blockState, aih blockAccess, cm blockPos) {
            if (foliagePineColors != null) {
                return foliagePineColors.getColor(blockAccess, blockPos);
            }
            return ahz.a();
        }

        @Override
        public boolean isColorConstant() {
            return foliagePineColors == null;
        }
    };
    private static final IColorizer COLORIZER_FOLIAGE_BIRCH = new IColorizer(){

        @Override
        public int getColor(ars blockState, aih blockAccess, cm blockPos) {
            if (foliageBirchColors != null) {
                return foliageBirchColors.getColor(blockAccess, blockPos);
            }
            return ahz.b();
        }

        @Override
        public boolean isColorConstant() {
            return foliageBirchColors == null;
        }
    };
    private static final IColorizer COLORIZER_WATER = new IColorizer(){

        @Override
        public int getColor(ars blockState, aih blockAccess, cm blockPos) {
            aiq biome = CustomColors.getColorBiome(blockAccess, blockPos);
            if (waterColors != null) {
                return waterColors.getColor(biome, blockPos);
            }
            if (Reflector.ForgeBiome_getWaterColorMultiplier.exists()) {
                return Reflector.callInt(biome, Reflector.ForgeBiome_getWaterColorMultiplier, new Object[0]);
            }
            return biome.o();
        }

        @Override
        public boolean isColorConstant() {
            return false;
        }
    };

    public static void update() {
        paletteFormatDefault = "vanilla";
        waterColors = null;
        foliageBirchColors = null;
        foliagePineColors = null;
        swampGrassColors = null;
        swampFoliageColors = null;
        skyColors = null;
        fogColors = null;
        underwaterColors = null;
        underlavaColors = null;
        redstoneColors = null;
        xpOrbColors = null;
        xpOrbTime = -1;
        durabilityColors = null;
        stemColors = null;
        myceliumParticleColors = null;
        lightMapPacks = null;
        particleWaterColor = -1;
        particlePortalColor = -1;
        lilyPadColor = -1;
        expBarTextColor = -1;
        bossTextColor = -1;
        signTextColor = -1;
        fogColorNether = null;
        fogColorEnd = null;
        skyColorEnd = null;
        colorsBlockColormaps = null;
        blockColormaps = null;
        useDefaultGrassFoliageColors = true;
        spawnEggPrimaryColors = null;
        spawnEggSecondaryColors = null;
        wolfCollarColors = null;
        sheepColors = null;
        textColors = null;
        CustomColors.setMapColors(mapColorsOriginal);
        potionColors = null;
        paletteFormatDefault = CustomColors.getValidProperty("mcpatcher/color.properties", "palette.format", CustomColormap.FORMAT_STRINGS, "vanilla");
        String mcpColormap = "mcpatcher/colormap/";
        String[] waterPaths = new String[]{"water.png", "watercolorX.png"};
        waterColors = CustomColors.getCustomColors(mcpColormap, waterPaths, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
        if (!Config.isCustomColors()) {
            return;
        }
        String[] pinePaths = new String[]{"pine.png", "pinecolor.png"};
        foliagePineColors = CustomColors.getCustomColors(mcpColormap, pinePaths, 256, 256);
        String[] birchPaths = new String[]{"birch.png", "birchcolor.png"};
        foliageBirchColors = CustomColors.getCustomColors(mcpColormap, birchPaths, 256, 256);
        String[] swampGrassPaths = new String[]{"swampgrass.png", "swampgrasscolor.png"};
        swampGrassColors = CustomColors.getCustomColors(mcpColormap, swampGrassPaths, 256, 256);
        String[] swampFoliagePaths = new String[]{"swampfoliage.png", "swampfoliagecolor.png"};
        swampFoliageColors = CustomColors.getCustomColors(mcpColormap, swampFoliagePaths, 256, 256);
        String[] sky0Paths = new String[]{"sky0.png", "skycolor0.png"};
        skyColors = CustomColors.getCustomColors(mcpColormap, sky0Paths, 256, 256);
        String[] fog0Paths = new String[]{"fog0.png", "fogcolor0.png"};
        fogColors = CustomColors.getCustomColors(mcpColormap, fog0Paths, 256, 256);
        String[] underwaterPaths = new String[]{"underwater.png", "underwatercolor.png"};
        underwaterColors = CustomColors.getCustomColors(mcpColormap, underwaterPaths, 256, 256);
        String[] underlavaPaths = new String[]{"underlava.png", "underlavacolor.png"};
        underlavaColors = CustomColors.getCustomColors(mcpColormap, underlavaPaths, 256, 256);
        String[] redstonePaths = new String[]{"redstone.png", "redstonecolor.png"};
        redstoneColors = CustomColors.getCustomColors(mcpColormap, redstonePaths, 16, 1);
        xpOrbColors = CustomColors.getCustomColors(mcpColormap + "xporb.png", -1, -1);
        durabilityColors = CustomColors.getCustomColors(mcpColormap + "durability.png", -1, -1);
        String[] stemPaths = new String[]{"stem.png", "stemcolor.png"};
        stemColors = CustomColors.getCustomColors(mcpColormap, stemPaths, 8, 1);
        stemPumpkinColors = CustomColors.getCustomColors(mcpColormap + "pumpkinstem.png", 8, 1);
        stemMelonColors = CustomColors.getCustomColors(mcpColormap + "melonstem.png", 8, 1);
        String[] myceliumPaths = new String[]{"myceliumparticle.png", "myceliumparticlecolor.png"};
        myceliumParticleColors = CustomColors.getCustomColors(mcpColormap, myceliumPaths, -1, -1);
        Pair<LightMapPack[], Integer> lightMaps = CustomColors.parseLightMapPacks();
        lightMapPacks = (LightMapPack[])lightMaps.getLeft();
        lightmapMinDimensionId = (Integer)lightMaps.getRight();
        CustomColors.readColorProperties("mcpatcher/color.properties");
        blockColormaps = CustomColors.readBlockColormaps(new String[]{mcpColormap + "custom/", mcpColormap + "blocks/"}, colorsBlockColormaps, 256, 256);
        CustomColors.updateUseDefaultGrassFoliageColors();
    }

    private static String getValidProperty(String fileName, String key, String[] validValues, String valDef) {
        try {
            kn loc = new kn(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return valDef;
            }
            Properties props = new Properties();
            props.load(in);
            in.close();
            String val = props.getProperty(key);
            if (val == null) {
                return valDef;
            }
            List<String> listValidValues = Arrays.asList(validValues);
            if (!listValidValues.contains(val)) {
                CustomColors.warn("Invalid value: " + key + "=" + val);
                CustomColors.warn("Expected values: " + Config.arrayToString(validValues));
                return valDef;
            }
            CustomColors.dbg("" + key + "=" + val);
            return val;
        }
        catch (FileNotFoundException e) {
            return valDef;
        }
        catch (IOException e) {
            e.printStackTrace();
            return valDef;
        }
    }

    private static Pair<LightMapPack[], Integer> parseLightMapPacks() {
        String lightmapPrefix = "mcpatcher/lightmap/world";
        String lightmapSuffix = ".png";
        String[] pathsLightmap = ResUtils.collectFiles(lightmapPrefix, lightmapSuffix);
        HashMap<Integer, String> mapLightmaps = new HashMap<Integer, String>();
        for (int i = 0; i < pathsLightmap.length; ++i) {
            String path = pathsLightmap[i];
            String dimIdStr = StrUtils.removePrefixSuffix(path, lightmapPrefix, lightmapSuffix);
            int dimId = Config.parseInt(dimIdStr, Integer.MIN_VALUE);
            if (dimId == Integer.MIN_VALUE) {
                CustomColors.warn("Invalid dimension ID: " + dimIdStr + ", path: " + path);
                continue;
            }
            mapLightmaps.put(dimId, path);
        }
        Set setDimIds = mapLightmaps.keySet();
        Object[] dimIds = setDimIds.toArray(new Integer[setDimIds.size()]);
        Arrays.sort(dimIds);
        if (dimIds.length <= 0) {
            return new ImmutablePair(null, (Object)0);
        }
        int minDimId = (Integer)dimIds[0];
        int maxDimId = (Integer)dimIds[dimIds.length - 1];
        int countDim = maxDimId - minDimId + 1;
        CustomColormap[] colormaps = new CustomColormap[countDim];
        for (int i = 0; i < dimIds.length; ++i) {
            Object dimId = dimIds[i];
            String path = (String)mapLightmaps.get(dimId);
            CustomColormap colors = CustomColors.getCustomColors(path, -1, -1);
            if (colors == null) continue;
            if (colors.getWidth() < 16) {
                CustomColors.warn("Invalid lightmap width: " + colors.getWidth() + ", path: " + path);
                continue;
            }
            int lightmapIndex = (Integer)dimId - minDimId;
            colormaps[lightmapIndex] = colors;
        }
        LightMapPack[] lmps = new LightMapPack[colormaps.length];
        for (int i = 0; i < colormaps.length; ++i) {
            LightMapPack lmp;
            CustomColormap cm2 = colormaps[i];
            if (cm2 == null) continue;
            String name = cm2.name;
            String basePath = cm2.basePath;
            CustomColormap cmRain = CustomColors.getCustomColors(basePath + "/" + name + "_rain.png", -1, -1);
            CustomColormap cmThunder = CustomColors.getCustomColors(basePath + "/" + name + "_thunder.png", -1, -1);
            LightMap lm = new LightMap(cm2);
            LightMap lmRain = cmRain != null ? new LightMap(cmRain) : null;
            LightMap lmThunder = cmThunder != null ? new LightMap(cmThunder) : null;
            lmps[i] = lmp = new LightMapPack(lm, lmRain, lmThunder);
        }
        return new ImmutablePair((Object)lmps, (Object)minDimId);
    }

    private static int getTextureHeight(String path, int defHeight) {
        try {
            InputStream in = Config.getResourceStream(new kn(path));
            if (in == null) {
                return defHeight;
            }
            BufferedImage bi = ImageIO.read(in);
            in.close();
            if (bi == null) {
                return defHeight;
            }
            return bi.getHeight();
        }
        catch (IOException e) {
            return defHeight;
        }
    }

    private static void readColorProperties(String fileName) {
        try {
            kn loc = new kn(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            CustomColors.dbg("Loading " + fileName);
            Properties props = new Properties();
            props.load(in);
            in.close();
            particleWaterColor = CustomColors.readColor(props, new String[]{"particle.water", "drop.water"});
            particlePortalColor = CustomColors.readColor(props, "particle.portal");
            lilyPadColor = CustomColors.readColor(props, "lilypad");
            expBarTextColor = CustomColors.readColor(props, "text.xpbar");
            bossTextColor = CustomColors.readColor(props, "text.boss");
            signTextColor = CustomColors.readColor(props, "text.sign");
            fogColorNether = CustomColors.readColorVec3(props, "fog.nether");
            fogColorEnd = CustomColors.readColorVec3(props, "fog.end");
            skyColorEnd = CustomColors.readColorVec3(props, "sky.end");
            colorsBlockColormaps = CustomColors.readCustomColormaps(props, fileName);
            spawnEggPrimaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.shell.", "Spawn egg shell");
            spawnEggSecondaryColors = CustomColors.readSpawnEggColors(props, fileName, "egg.spots.", "Spawn egg spot");
            wolfCollarColors = CustomColors.readDyeColors(props, fileName, "collar.", "Wolf collar");
            sheepColors = CustomColors.readDyeColors(props, fileName, "sheep.", "Sheep");
            textColors = CustomColors.readTextColors(props, fileName, "text.code.", "Text");
            int[] mapColors = CustomColors.readMapColors(props, fileName, "map.", "Map");
            if (mapColors != null) {
                if (mapColorsOriginal == null) {
                    mapColorsOriginal = CustomColors.getMapColors();
                }
                CustomColors.setMapColors(mapColors);
            }
            potionColors = CustomColors.readPotionColors(props, fileName, "potion.", "Potion");
            xpOrbTime = Config.parseInt(props.getProperty("xporb.time"), -1);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CustomColormap[] readCustomColormaps(Properties props, String fileName) {
        void var7_9;
        ArrayList<CustomColormap> list = new ArrayList<CustomColormap>();
        String palettePrefix = "palette.block.";
        HashMap<String, String> map = new HashMap<String, String>();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(palettePrefix)) continue;
            map.put(string, value);
        }
        String[] propNames = map.keySet().toArray(new String[map.size()]);
        boolean bl = false;
        while (var7_9 < propNames.length) {
            String name = propNames[var7_9];
            String value = props.getProperty(name);
            CustomColors.dbg("Block palette: " + name + " = " + value);
            String path = name.substring(palettePrefix.length());
            String basePath = TextureUtils.getBasePath(fileName);
            path = TextureUtils.fixResourcePath(path, basePath);
            CustomColormap colors = CustomColors.getCustomColors(path, 256, 256);
            if (colors == null) {
                CustomColors.warn("Colormap not found: " + path);
            } else {
                ConnectedParser cp = new ConnectedParser("CustomColors");
                MatchBlock[] mbs = cp.parseMatchBlocks(value);
                if (mbs == null || mbs.length <= 0) {
                    CustomColors.warn("Invalid match blocks: " + value);
                } else {
                    for (int m2 = 0; m2 < mbs.length; ++m2) {
                        MatchBlock mb = mbs[m2];
                        colors.addMatchBlock(mb);
                    }
                    list.add(colors);
                }
            }
            ++var7_9;
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomColormap[] customColormapArray = list.toArray(new CustomColormap[list.size()]);
        return customColormapArray;
    }

    private static CustomColormap[][] readBlockColormaps(String[] basePaths, CustomColormap[] basePalettes, int width, int height) {
        int i;
        Object[] paths = ResUtils.collectFiles(basePaths, new String[]{".properties"});
        Arrays.sort(paths);
        ArrayList blockList = new ArrayList();
        for (i = 0; i < paths.length; ++i) {
            Object path = paths[i];
            CustomColors.dbg("Block colormap: " + (String)path);
            try {
                kn locFile = new kn("minecraft", (String)path);
                InputStream in = Config.getResourceStream(locFile);
                if (in == null) {
                    CustomColors.warn("File not found: " + (String)path);
                    continue;
                }
                Properties props = new Properties();
                props.load(in);
                CustomColormap cm2 = new CustomColormap(props, (String)path, width, height, paletteFormatDefault);
                if (!cm2.isValid((String)path) || !cm2.isValidMatchBlocks((String)path)) continue;
                CustomColors.addToBlockList(cm2, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                CustomColors.warn("File not found: " + (String)path);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (basePalettes != null) {
            for (i = 0; i < basePalettes.length; ++i) {
                CustomColormap cm3 = basePalettes[i];
                CustomColors.addToBlockList(cm3, blockList);
            }
        }
        if (blockList.size() <= 0) {
            return null;
        }
        CustomColormap[][] cmArr = CustomColors.blockListToArray(blockList);
        return cmArr;
    }

    private static void addToBlockList(CustomColormap cm2, List blockList) {
        int[] ids = cm2.getMatchBlockIds();
        if (ids == null || ids.length <= 0) {
            CustomColors.warn("No match blocks: " + Config.arrayToString(ids));
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            int blockId = ids[i];
            if (blockId < 0) {
                CustomColors.warn("Invalid block ID: " + blockId);
                continue;
            }
            CustomColors.addToList(cm2, blockList, blockId);
        }
    }

    private static void addToList(CustomColormap cm2, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomColormap> subList = (ArrayList<CustomColormap>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomColormap>();
            list.set(id, subList);
        }
        subList.add(cm2);
    }

    private static CustomColormap[][] blockListToArray(List list) {
        CustomColormap[][] colArr = new CustomColormap[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomColormap[] subArr = subList.toArray(new CustomColormap[subList.size()]);
            colArr[i] = subArr;
        }
        return colArr;
    }

    private static int readColor(Properties props, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            int col = CustomColors.readColor(props, name);
            if (col < 0) continue;
            return col;
        }
        return -1;
    }

    private static int readColor(Properties props, String name) {
        String str = props.getProperty(name);
        if (str == null) {
            return -1;
        }
        int color = CustomColors.parseColor(str = str.trim());
        if (color < 0) {
            CustomColors.warn("Invalid color: " + name + " = " + str);
            return color;
        }
        CustomColors.dbg(name + " = " + str);
        return color;
    }

    private static int parseColor(String str) {
        if (str == null) {
            return -1;
        }
        str = str.trim();
        try {
            int val = Integer.parseInt(str, 16) & 0xFFFFFF;
            return val;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static bcb readColorVec3(Properties props, String name) {
        int col = CustomColors.readColor(props, name);
        if (col < 0) {
            return null;
        }
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        return new bcb((double)redF, (double)greenF, (double)blueF);
    }

    private static CustomColormap getCustomColors(String basePath, String[] paths, int width, int height) {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            path = basePath + path;
            CustomColormap cols = CustomColors.getCustomColors(path, width, height);
            if (cols == null) continue;
            return cols;
        }
        return null;
    }

    public static CustomColormap getCustomColors(String pathImage, int width, int height) {
        try {
            kn loc = new kn(pathImage);
            if (!Config.hasResource(loc)) {
                return null;
            }
            CustomColors.dbg("Colormap " + pathImage);
            Properties props = new Properties();
            String pathProps = StrUtils.replaceSuffix(pathImage, ".png", ".properties");
            kn locProps = new kn(pathProps);
            if (Config.hasResource(locProps)) {
                InputStream in = Config.getResourceStream(locProps);
                props.load(in);
                in.close();
                CustomColors.dbg("Colormap properties: " + pathProps);
            } else {
                props.put("format", paletteFormatDefault);
                props.put("source", pathImage);
                pathProps = pathImage;
            }
            CustomColormap cm2 = new CustomColormap(props, pathProps, width, height, paletteFormatDefault);
            if (!cm2.isValid(pathProps)) {
                return null;
            }
            return cm2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateUseDefaultGrassFoliageColors() {
        useDefaultGrassFoliageColors = foliageBirchColors == null && foliagePineColors == null && swampGrassColors == null && swampFoliageColors == null && Config.isSwampColors() && Config.isSmoothBiomes();
    }

    public static int getColorMultiplier(boy quad, ars blockState, aih blockAccess, cm blockPos, RenderEnv renderEnv) {
        IColorizer colorizer;
        akf block = blockState.t();
        ars bs = renderEnv.getBlockState();
        if (blockColormaps != null) {
            CustomColormap cm2;
            if (!quad.c()) {
                if (block == akg.c) {
                    bs = BLOCK_STATE_DIRT;
                }
                if (block == akg.af) {
                    return -1;
                }
            }
            if (block == akg.cF && renderEnv.getMetadata() >= 8) {
                blockPos = blockPos.b();
                bs = blockAccess.o(blockPos);
            }
            if ((cm2 = CustomColors.getBlockColormap(bs)) != null) {
                if (Config.isSmoothBiomes() && !cm2.isColorConstant()) {
                    return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, cm2, renderEnv.getColorizerBlockPosM());
                }
                return cm2.getColor(blockAccess, blockPos);
            }
        }
        if (!quad.c()) {
            return -1;
        }
        if (block == akg.bx) {
            return CustomColors.getLilypadColorMultiplier(blockAccess, blockPos);
        }
        if (block == akg.af) {
            return CustomColors.getRedstoneColor(renderEnv.getBlockState());
        }
        if (block instanceof apk) {
            return CustomColors.getStemColorMultiplier(block, blockAccess, blockPos, renderEnv);
        }
        if (useDefaultGrassFoliageColors) {
            return -1;
        }
        int metadata = renderEnv.getMetadata();
        if (block == akg.c || block == akg.H || block == akg.cF) {
            colorizer = COLORIZER_GRASS;
        } else if (block == akg.cF) {
            colorizer = COLORIZER_GRASS;
            if (metadata >= 8) {
                blockPos = blockPos.b();
            }
        } else if (block == akg.t) {
            switch (metadata & 3) {
                case 0: {
                    colorizer = COLORIZER_FOLIAGE;
                    break;
                }
                case 1: {
                    colorizer = COLORIZER_FOLIAGE_PINE;
                    break;
                }
                case 2: {
                    colorizer = COLORIZER_FOLIAGE_BIRCH;
                    break;
                }
                default: {
                    colorizer = COLORIZER_FOLIAGE;
                    break;
                }
            }
        } else if (block == akg.u) {
            colorizer = COLORIZER_FOLIAGE;
        } else if (block == akg.bn) {
            colorizer = COLORIZER_FOLIAGE;
        } else {
            return -1;
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(bs, blockAccess, blockPos);
    }

    protected static aiq getColorBiome(aih blockAccess, cm blockPos) {
        aiq biome = blockAccess.b(blockPos);
        if (biome == aiv.h && !Config.isSwampColors()) {
            biome = aiv.c;
        }
        return biome;
    }

    private static CustomColormap getBlockColormap(ars blockState) {
        if (blockColormaps == null) {
            return null;
        }
        if (!(blockState instanceof arp)) {
            return null;
        }
        arp bs = (arp)blockState;
        int blockId = bs.getBlockId();
        if (blockId < 0 || blockId >= blockColormaps.length) {
            return null;
        }
        CustomColormap[] cms = blockColormaps[blockId];
        if (cms == null) {
            return null;
        }
        for (int i = 0; i < cms.length; ++i) {
            CustomColormap cm2 = cms[i];
            if (!cm2.matchesBlock(bs)) continue;
            return cm2;
        }
        return null;
    }

    private static int getSmoothColorMultiplier(ars blockState, aih blockAccess, cm blockPos, IColorizer colorizer, BlockPosM blockPosM) {
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int x = blockPos.p();
        int y = blockPos.q();
        int z = blockPos.r();
        BlockPosM posM = blockPosM;
        for (int ix = x - 1; ix <= x + 1; ++ix) {
            for (int iz = z - 1; iz <= z + 1; ++iz) {
                posM.setXyz(ix, y, iz);
                int col = colorizer.getColor(blockState, blockAccess, posM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
            }
        }
        int r = sumRed / 9;
        int g = sumGreen / 9;
        int b2 = sumBlue / 9;
        return r << 16 | g << 8 | b2;
    }

    public static int getFluidColor(aih blockAccess, ars blockState, cm blockPos, RenderEnv renderEnv) {
        akf block = blockState.t();
        IColorizer colorizer = CustomColors.getBlockColormap(blockState);
        if (colorizer == null && blockState.a() == axx.h) {
            colorizer = COLORIZER_WATER;
        }
        if (colorizer == null) {
            return CustomColors.getBlockColors().a(blockState, blockAccess, blockPos, 0);
        }
        if (Config.isSmoothBiomes() && !colorizer.isColorConstant()) {
            return CustomColors.getSmoothColorMultiplier(blockState, blockAccess, blockPos, colorizer, renderEnv.getColorizerBlockPosM());
        }
        return colorizer.getColor(blockState, blockAccess, blockPos);
    }

    public static bdg getBlockColors() {
        return bcx.z().ak();
    }

    public static void updatePortalFX(bmr fx) {
        if (particlePortalColor < 0) {
            return;
        }
        int col = particlePortalColor;
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    public static void updateMyceliumFX(bmr fx) {
        if (myceliumParticleColors == null) {
            return;
        }
        int col = myceliumParticleColors.getColorRandom();
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneColor(ars blockState) {
        if (redstoneColors == null) {
            return -1;
        }
        int level = CustomColors.getRedstoneLevel(blockState, 15);
        int col = redstoneColors.getColor(level);
        return col;
    }

    public static void updateReddustFX(bmr fx, aih blockAccess, double x, double y, double z) {
        if (redstoneColors == null) {
            return;
        }
        ars state = blockAccess.o(new cm(x, y, z));
        int level = CustomColors.getRedstoneLevel(state, 15);
        int col = redstoneColors.getColor(level);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        fx.a(redF, greenF, blueF);
    }

    private static int getRedstoneLevel(ars state, int def) {
        akf block = state.t();
        if (!(block instanceof aol)) {
            return def;
        }
        Comparable val = state.c((asi)aol.e);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static float getXpOrbTimer(float timer) {
        if (xpOrbTime <= 0) {
            return timer;
        }
        float kt = 628.0f / (float)xpOrbTime;
        return timer * kt;
    }

    public static int getXpOrbColor(float timer) {
        if (xpOrbColors == null) {
            return -1;
        }
        int index = (int)Math.round((double)((op.a((float)timer) + 1.0f) * (float)(xpOrbColors.getLength() - 1)) / 2.0);
        int col = xpOrbColors.getColor(index);
        return col;
    }

    public static int getDurabilityColor(int dur255) {
        if (durabilityColors == null) {
            return -1;
        }
        int index = dur255 * durabilityColors.getLength() / 255;
        int col = durabilityColors.getColor(index);
        return col;
    }

    public static void updateWaterFX(bmr fx, aih blockAccess, double x, double y, double z, RenderEnv renderEnv) {
        if (waterColors == null && blockColormaps == null) {
            return;
        }
        cm blockPos = new cm(x, y, z);
        renderEnv.reset(blockAccess, BLOCK_STATE_WATER, blockPos);
        int col = CustomColors.getFluidColor(blockAccess, BLOCK_STATE_WATER, blockPos, renderEnv);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        if (particleWaterColor >= 0) {
            int redDrop = particleWaterColor >> 16 & 0xFF;
            int greenDrop = particleWaterColor >> 8 & 0xFF;
            int blueDrop = particleWaterColor & 0xFF;
            redF *= (float)redDrop / 255.0f;
            greenF *= (float)greenDrop / 255.0f;
            blueF *= (float)blueDrop / 255.0f;
        }
        fx.a(redF, greenF, blueF);
    }

    private static int getLilypadColorMultiplier(aih blockAccess, cm blockPos) {
        if (lilyPadColor < 0) {
            return CustomColors.getBlockColors().a(akg.bx.u(), blockAccess, blockPos, 0);
        }
        return lilyPadColor;
    }

    private static bcb getFogColorNether(bcb col) {
        if (fogColorNether == null) {
            return col;
        }
        return fogColorNether;
    }

    private static bcb getFogColorEnd(bcb col) {
        if (fogColorEnd == null) {
            return col;
        }
        return fogColorEnd;
    }

    private static bcb getSkyColorEnd(bcb col) {
        if (skyColorEnd == null) {
            return col;
        }
        return skyColorEnd;
    }

    public static bcb getSkyColor(bcb skyColor3d, aih blockAccess, double x, double y, double z) {
        if (skyColors == null) {
            return skyColor3d;
        }
        int col = skyColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)skyColor3d.b / 0.5f;
        float cGreen = (float)skyColor3d.c / 0.66275f;
        float cBlue = (float)skyColor3d.d;
        bcb newCol = skyColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    private static bcb getFogColor(bcb fogColor3d, aih blockAccess, double x, double y, double z) {
        if (fogColors == null) {
            return fogColor3d;
        }
        int col = fogColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        float cRed = (float)fogColor3d.b / 0.753f;
        float cGreen = (float)fogColor3d.c / 0.8471f;
        float cBlue = (float)fogColor3d.d;
        bcb newCol = fogColorFader.getColor(redF *= cRed, greenF *= cGreen, blueF *= cBlue);
        return newCol;
    }

    public static bcb getUnderwaterColor(aih blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x, y, z, underwaterColors, underwaterColorFader);
    }

    public static bcb getUnderlavaColor(aih blockAccess, double x, double y, double z) {
        return CustomColors.getUnderFluidColor(blockAccess, x, y, z, underlavaColors, underlavaColorFader);
    }

    public static bcb getUnderFluidColor(aih blockAccess, double x, double y, double z, CustomColormap underFluidColors, CustomColorFader underFluidColorFader) {
        if (underFluidColors == null) {
            return null;
        }
        int col = underFluidColors.getColorSmooth(blockAccess, x, y, z, 3);
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        float redF = (float)red / 255.0f;
        float greenF = (float)green / 255.0f;
        float blueF = (float)blue / 255.0f;
        bcb newCol = underFluidColorFader.getColor(redF, greenF, blueF);
        return newCol;
    }

    private static int getStemColorMultiplier(akf blockStem, aih blockAccess, cm blockPos, RenderEnv renderEnv) {
        CustomColormap colors = stemColors;
        if (blockStem == akg.bl && stemPumpkinColors != null) {
            colors = stemPumpkinColors;
        }
        if (blockStem == akg.bm && stemMelonColors != null) {
            colors = stemMelonColors;
        }
        if (colors == null) {
            return -1;
        }
        int level = renderEnv.getMetadata();
        return colors.getColor(level);
    }

    public static boolean updateLightmap(aid world, float torchFlickerX, int[] lmColors, boolean nightvision, float partialTicks) {
        if (world == null) {
            return false;
        }
        if (lightMapPacks == null) {
            return false;
        }
        int dimensionId = world.s.p().a();
        int lightMapIndex = dimensionId - lightmapMinDimensionId;
        if (lightMapIndex < 0 || lightMapIndex >= lightMapPacks.length) {
            return false;
        }
        LightMapPack lightMapPack = lightMapPacks[lightMapIndex];
        if (lightMapPack == null) {
            return false;
        }
        return lightMapPack.updateLightmap(world, torchFlickerX, lmColors, nightvision, partialTicks);
    }

    public static bcb getWorldFogColor(bcb fogVec, aid world, rw renderViewEntity, float partialTicks) {
        atm worldType = world.s.p();
        switch (worldType) {
            case b: {
                fogVec = CustomColors.getFogColorNether(fogVec);
                break;
            }
            case a: {
                bcx mc = bcx.z();
                fogVec = CustomColors.getFogColor(fogVec, (aih)mc.f, renderViewEntity.p, renderViewEntity.q + 1.0, renderViewEntity.r);
                break;
            }
            case c: {
                fogVec = CustomColors.getFogColorEnd(fogVec);
            }
        }
        return fogVec;
    }

    public static bcb getWorldSkyColor(bcb skyVec, aid world, rw renderViewEntity, float partialTicks) {
        atm worldType = world.s.p();
        switch (worldType) {
            case a: {
                bcx mc = bcx.z();
                skyVec = CustomColors.getSkyColor(skyVec, (aih)mc.f, renderViewEntity.p, renderViewEntity.q + 1.0, renderViewEntity.r);
                break;
            }
            case c: {
                skyVec = CustomColors.getSkyColorEnd(skyVec);
            }
        }
        return skyVec;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] readSpawnEggColors(Properties props, String fileName, String prefix, String logName) {
        void var8_10;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Set<Object> keys = props.keySet();
        int countColors = 0;
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int id = EntityUtils.getEntityId(name);
            int color = CustomColors.parseColor(value);
            if (id < 0 || color < 0) {
                CustomColors.warn("Invalid spawn egg color: " + string + " = " + value);
                continue;
            }
            while (list.size() <= id) {
                list.add(-1);
            }
            list.set(id, color);
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        int[] colors = new int[list.size()];
        boolean bl = false;
        while (var8_10 < colors.length) {
            colors[var8_10] = (Integer)list.get((int)var8_10);
            ++var8_10;
        }
        return colors;
    }

    private static int getSpawnEggColor(afd item, adz itemStack, int layer, int color) {
        int[] eggColors;
        dr nbt = itemStack.o();
        if (nbt == null) {
            return color;
        }
        dr tag = nbt.o("EntityTag");
        if (tag == null) {
            return color;
        }
        String name = tag.l("id");
        int id = EntityUtils.getEntityId(name);
        int[] nArray = eggColors = layer == 0 ? spawnEggPrimaryColors : spawnEggSecondaryColors;
        if (eggColors == null) {
            return color;
        }
        if (id < 0 || id >= eggColors.length) {
            return color;
        }
        int eggColor = eggColors[id];
        if (eggColor < 0) {
            return color;
        }
        return eggColor;
    }

    public static int getColorFromItemStack(adz itemStack, int layer, int color) {
        if (itemStack == null) {
            return color;
        }
        adx item = itemStack.b();
        if (item == null) {
            return color;
        }
        if (item instanceof afd) {
            return CustomColors.getSpawnEggColor((afd)item, itemStack, layer, color);
        }
        return color;
    }

    private static float[][] readDyeColors(Properties props, String fileName, String prefix, String logName) {
        adc[] dyeValues = adc.values();
        HashMap<String, adc> mapDyes = new HashMap<String, adc>();
        for (int i = 0; i < dyeValues.length; ++i) {
            adc dye = dyeValues[i];
            mapDyes.put(dye.m(), dye);
        }
        float[][] colors = new float[dyeValues.length][];
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            if (name.equals("lightBlue")) {
                name = "light_blue";
            }
            adc dye = (adc)mapDyes.get(name);
            int color = CustomColors.parseColor(value);
            if (dye == null || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            colors[dye.ordinal()] = rgb;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static float[] getDyeColors(adc dye, float[][] dyeColors, float[] colors) {
        if (dyeColors == null) {
            return colors;
        }
        if (dye == null) {
            return colors;
        }
        float[] customColors = dyeColors[dye.ordinal()];
        if (customColors == null) {
            return colors;
        }
        return customColors;
    }

    public static float[] getWolfCollarColors(adc dye, float[] colors) {
        return CustomColors.getDyeColors(dye, wolfCollarColors, colors);
    }

    public static float[] getSheepColors(adc dye, float[] colors) {
        return CustomColors.getDyeColors(dye, sheepColors, colors);
    }

    private static int[] readTextColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[32];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int code = Config.parseInt(name, -1);
            int color = CustomColors.parseColor(value);
            if (code < 0 || code >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[code] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    public static int getTextColor(int index, int color) {
        if (textColors == null) {
            return color;
        }
        if (index < 0 || index >= textColors.length) {
            return color;
        }
        int customColor = textColors[index];
        if (customColor < 0) {
            return color;
        }
        return customColor;
    }

    private static int[] readMapColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[axy.a.length];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = StrUtils.removePrefix(string, prefix);
            int index = CustomColors.getMapColorIndex(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int[] readPotionColors(Properties props, String fileName, String prefix, String logName) {
        int[] colors = new int[CustomColors.getMaxPotionId()];
        Arrays.fill(colors, -1);
        int countColors = 0;
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            String name = string;
            int index = CustomColors.getPotionId(name);
            int color = CustomColors.parseColor(value);
            if (index < 0 || index >= colors.length || color < 0) {
                CustomColors.warn("Invalid color: " + string + " = " + value);
                continue;
            }
            colors[index] = color;
            ++countColors;
        }
        if (countColors <= 0) {
            return null;
        }
        CustomColors.dbg(logName + " colors: " + countColors);
        return colors;
    }

    private static int getMaxPotionId() {
        int maxId = 0;
        Set keys = rp.b.c();
        for (kn rl : keys) {
            rp potion = (rp)rp.b.c((Object)rl);
            int id = rp.a((rp)potion);
            if (id <= maxId) continue;
            maxId = id;
        }
        return maxId;
    }

    private static int getPotionId(String name) {
        if (name.equals("potion.water")) {
            return 0;
        }
        name = StrUtils.replacePrefix(name, "potion.", "effect.");
        Set keys = rp.b.c();
        for (kn rl : keys) {
            rp potion = (rp)rp.b.c((Object)rl);
            if (!potion.a().equals(name)) continue;
            return rp.a((rp)potion);
        }
        return -1;
    }

    public static int getPotionColor(rp potion, int color) {
        int potionId = 0;
        if (potion != null) {
            potionId = rp.a((rp)potion);
        }
        return CustomColors.getPotionColor(potionId, color);
    }

    public static int getPotionColor(int potionId, int color) {
        if (potionColors == null) {
            return color;
        }
        if (potionId < 0 || potionId >= potionColors.length) {
            return color;
        }
        int potionColor = potionColors[potionId];
        if (potionColor < 0) {
            return color;
        }
        return potionColor;
    }

    private static int getMapColorIndex(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals("air")) {
            return axy.b.M;
        }
        if (name.equals("grass")) {
            return axy.c.M;
        }
        if (name.equals("sand")) {
            return axy.d.M;
        }
        if (name.equals("cloth")) {
            return axy.e.M;
        }
        if (name.equals("tnt")) {
            return axy.f.M;
        }
        if (name.equals("ice")) {
            return axy.g.M;
        }
        if (name.equals("iron")) {
            return axy.h.M;
        }
        if (name.equals("foliage")) {
            return axy.i.M;
        }
        if (name.equals("clay")) {
            return axy.k.M;
        }
        if (name.equals("dirt")) {
            return axy.l.M;
        }
        if (name.equals("stone")) {
            return axy.m.M;
        }
        if (name.equals("water")) {
            return axy.n.M;
        }
        if (name.equals("wood")) {
            return axy.o.M;
        }
        if (name.equals("quartz")) {
            return axy.p.M;
        }
        if (name.equals("gold")) {
            return axy.F.M;
        }
        if (name.equals("diamond")) {
            return axy.G.M;
        }
        if (name.equals("lapis")) {
            return axy.H.M;
        }
        if (name.equals("emerald")) {
            return axy.I.M;
        }
        if (name.equals("podzol")) {
            return axy.J.M;
        }
        if (name.equals("netherrack")) {
            return axy.K.M;
        }
        if (name.equals("snow") || name.equals("white")) {
            return axy.j.M;
        }
        if (name.equals("adobe") || name.equals("orange")) {
            return axy.q.M;
        }
        if (name.equals("magenta")) {
            return axy.r.M;
        }
        if (name.equals("light_blue") || name.equals("lightBlue")) {
            return axy.s.M;
        }
        if (name.equals("yellow")) {
            return axy.t.M;
        }
        if (name.equals("lime")) {
            return axy.u.M;
        }
        if (name.equals("pink")) {
            return axy.v.M;
        }
        if (name.equals("gray")) {
            return axy.w.M;
        }
        if (name.equals("silver")) {
            return axy.x.M;
        }
        if (name.equals("cyan")) {
            return axy.y.M;
        }
        if (name.equals("purple")) {
            return axy.z.M;
        }
        if (name.equals("blue")) {
            return axy.A.M;
        }
        if (name.equals("brown")) {
            return axy.B.M;
        }
        if (name.equals("green")) {
            return axy.C.M;
        }
        if (name.equals("red")) {
            return axy.D.M;
        }
        if (name.equals("black")) {
            return axy.E.M;
        }
        return -1;
    }

    private static int[] getMapColors() {
        axy[] mapColors = axy.a;
        int[] colors = new int[mapColors.length];
        Arrays.fill(colors, -1);
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            axy mapColor = mapColors[i];
            if (mapColor == null) continue;
            colors[i] = mapColor.L;
        }
        return colors;
    }

    private static void setMapColors(int[] colors) {
        if (colors == null) {
            return;
        }
        axy[] mapColors = axy.a;
        boolean changed = false;
        for (int i = 0; i < mapColors.length && i < colors.length; ++i) {
            int color;
            axy mapColor = mapColors[i];
            if (mapColor == null || (color = colors[i]) < 0 || mapColor.L == color) continue;
            mapColor.L = color;
            changed = true;
        }
        if (changed) {
            bcx.z().N().reloadBannerTextures();
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    public static int getExpBarTextColor(int color) {
        if (expBarTextColor < 0) {
            return color;
        }
        return expBarTextColor;
    }

    public static int getBossTextColor(int color) {
        if (bossTextColor < 0) {
            return color;
        }
        return bossTextColor;
    }

    public static int getSignTextColor(int color) {
        if (signTextColor < 0) {
            return color;
        }
        return signTextColor;
    }

    public static interface IColorizer {
        public int getColor(ars var1, aih var2, cm var3);

        public boolean isColorConstant();
    }
}

