/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static ddm spriteGrass = null;
    private static ddm spriteGrassSide = null;
    private static ddm spriteGrassPath = null;
    private static ddm spriteGrassPathSide = null;
    private static ddm spriteMycelium = null;
    private static ddm spritePodzol = null;
    private static ddm spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static dez modelCubeGrass = null;
    private static dez modelGrassPath = null;
    private static dez modelCubeGrassPath = null;
    private static dez modelCubeMycelium = null;
    private static dez modelCubePodzol = null;
    private static dez modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/grass_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/grass_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(ddl textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            dez modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("grass_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(ddl textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new pc(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new pc(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new pc(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new pc(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new pc(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new pc(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new pc(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            pc locFile = new pc(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static ddm registerSprite(Properties props, String key, String textureDefault, ddl textureMap) {
        pc locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new pc("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        pc locSprite = new pc(texture);
        ddm sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        if (facing == eq.b || facing == eq.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bcs block = blockState.c();
        if (block instanceof bgb) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bfd) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bct.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bct.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof bfc) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        boolean snowy;
        bcs blockUp = blockAccess.a_(blockPos.a()).c();
        boolean bl = snowy = blockUp == bct.cS || blockUp == bct.cQ;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bct.cQ) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == bct.dV) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == bct.if) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        boolean snowy;
        bcs blockTop = BetterGrass.getBlockAt(blockPos, eq.b, blockAccess);
        boolean bl = snowy = blockTop == bct.cS || blockTop == bct.cQ;
        if (Config.isBetterGrassFancy()) {
            el posSide;
            blc stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bct.cQ) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.a_(posSide = blockPos.b().a(facing))).c() == bct.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        bcs blockTop = BetterGrass.getBlockAt(blockPos, eq.b, blockAccess);
        if (blockTop == bct.if && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bct.if) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(aye blockAccess, blc blockState, el blockPos, eq facing, List quads) {
        boolean snowy;
        bcs blockUp = blockAccess.a_(blockPos.a()).c();
        boolean bl = snowy = blockUp == bct.cS || blockUp == bct.cQ;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bct.cQ) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == bct.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bcs getBlockAt(el blockPos, eq facing, aye blockAccess) {
        el pos = blockPos.a(facing);
        bcs block = blockAccess.a_(pos).c();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

