/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private aer entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<el> setLitChunkPos = new HashSet<el>();
    private el.a blockPosMutable = new el.a();

    public DynamicLight(aer entity) {
        this.entity = entity;
        this.offsetY = entity.bF();
    }

    public void update(cue renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.q - 0.5;
        double posY = this.entity.r - 0.5 + this.offsetY;
        double posZ = this.entity.s - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<el> setNewPos = new HashSet<el>();
        if (lightLevel > 0) {
            eq dirX = (xq.c((double)posX) & 0xF) >= 8 ? eq.f : eq.e;
            eq dirY = (xq.c((double)posY) & 0xF) >= 8 ? eq.b : eq.a;
            eq dirZ = (xq.c((double)posZ) & 0xF) >= 8 ? eq.d : eq.c;
            el chunkPos = new el(posX, posY, posZ);
            cwt chunk = renderGlobal.getRenderChunk(chunkPos);
            el chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            cwt chunkX = renderGlobal.getRenderChunk(chunkPosX);
            el chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            cwt chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            el chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            cwt chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            el chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            cwt chunkY = renderGlobal.getRenderChunk(chunkPosY);
            el chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            cwt chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            el chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            cwt chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            el chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            cwt chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private el getChunkPos(cwt renderChunk, el pos, eq facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(cwt renderChunk, Set<el> setPrevPos, Set<el> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        cwr compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        el pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(cue renderGlobal) {
        for (el posOld : this.setLitChunkPos) {
            cwt chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public aer getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

