/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;

public class ReflectorMethod {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName) {
        this(reflectorClass, targetMethodName, null, reflectorClass.isLazyResolve());
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes) {
        this(reflectorClass, targetMethodName, targetMethodParameterTypes, reflectorClass.isLazyResolve());
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes, boolean lazyResolve) {
        this.reflectorClass = reflectorClass;
        this.targetMethodName = targetMethodName;
        this.targetMethodParameterTypes = targetMethodParameterTypes;
        if (!lazyResolve) {
            Method method = this.getTargetMethod();
        }
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class cls2 = this.reflectorClass.getTargetClass();
        if (cls2 == null) {
            return null;
        }
        try {
            if (this.targetMethodParameterTypes == null) {
                Method[] ms = ReflectorMethod.getMethods(cls2, this.targetMethodName);
                if (ms.length <= 0) {
                    Config.log("(Reflector) Method not present: " + cls2.getName() + "." + this.targetMethodName);
                    return null;
                }
                if (ms.length > 1) {
                    Config.warn("(Reflector) More than one method found: " + cls2.getName() + "." + this.targetMethodName);
                    for (int i2 = 0; i2 < ms.length; ++i2) {
                        Method m2 = ms[i2];
                        Config.warn("(Reflector)  - " + m2);
                    }
                    return null;
                }
                this.targetMethod = ms[0];
            } else {
                this.targetMethod = ReflectorMethod.getMethod(cls2, this.targetMethodName, this.targetMethodParameterTypes);
            }
            if (this.targetMethod == null) {
                Config.log("(Reflector) Method not present: " + cls2.getName() + "." + this.targetMethodName);
                return null;
            }
            this.targetMethod.setAccessible(true);
            return this.targetMethod;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        if (this.checked) {
            return this.targetMethod != null;
        }
        return this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method tm = this.getTargetMethod();
        if (tm == null) {
            return null;
        }
        return tm.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }

    public Object call(Object ... params) {
        return Reflector.call(this, params);
    }

    public static Method getMethod(Class cls2, String methodName, Class[] paramTypes) {
        Method[] ms = cls2.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Class[] types;
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName) || !Reflector.matchesTypes(paramTypes, types = m2.getParameterTypes())) continue;
            return m2;
        }
        return null;
    }

    public static Method[] getMethods(Class cls2, String methodName) {
        ArrayList<Method> listMethods = new ArrayList<Method>();
        Method[] ms = cls2.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName)) continue;
            listMethods.add(m2);
        }
        Method[] methods = listMethods.toArray(new Method[listMethods.size()]);
        return methods;
    }
}

