/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import net.optifine.expr.IExpressionBool;

public enum ShaderParameterBool implements IExpressionBool
{
    IS_ALIVE("is_alive"),
    IS_BURNING("is_burning"),
    IS_CHILD("is_child"),
    IS_GLOWING("is_glowing"),
    IS_HURT("is_hurt"),
    IS_IN_LAVA("is_in_lava"),
    IS_IN_WATER("is_in_water"),
    IS_INVISIBLE("is_invisible"),
    IS_ON_GROUND("is_on_ground"),
    IS_RIDDEN("is_ridden"),
    IS_RIDING("is_riding"),
    IS_SNEAKING("is_sneaking"),
    IS_SPRINTING("is_sprinting"),
    IS_WET("is_wet");

    private String name;
    private dsa renderManager;
    private static final ShaderParameterBool[] VALUES;

    private ShaderParameterBool(String name) {
        this.name = name;
        this.renderManager = cyc.u().V();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean eval() {
        aio entityGeneral = cyc.u().T();
        if (entityGeneral instanceof aix) {
            aix entity = (aix)entityGeneral;
            switch (this) {
                case IS_ALIVE: {
                    return entity.aL();
                }
                case IS_BURNING: {
                    return entity.bc();
                }
                case IS_CHILD: {
                    return entity.v_();
                }
                case IS_GLOWING: {
                    return entity.bm();
                }
                case IS_HURT: {
                    return entity.ax > 0;
                }
                case IS_IN_LAVA: {
                    return entity.aD();
                }
                case IS_IN_WATER: {
                    return entity.as();
                }
                case IS_INVISIBLE: {
                    return entity.bn();
                }
                case IS_ON_GROUND: {
                    return entity.w;
                }
                case IS_RIDDEN: {
                    return entity.be();
                }
                case IS_RIDING: {
                    return entity.bd();
                }
                case IS_SNEAKING: {
                    return entity.bg();
                }
                case IS_SPRINTING: {
                    return entity.bi();
                }
                case IS_WET: {
                    return entity.at();
                }
            }
        }
        return false;
    }

    public static ShaderParameterBool parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < VALUES.length; ++i) {
            ShaderParameterBool type = VALUES[i];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = ShaderParameterBool.values();
    }
}

