/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(bvt blockStateIn, bhb blockReaderIn, ew blockPosIn, fb facingIn, RenderEnv renderEnv) {
        ew posNeighbour = blockPosIn.a(facingIn);
        bvt stateNeighbour = blockReaderIn.e_(posNeighbour);
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.o()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(bvt blockStateIn, bhb blockReaderIn, ew blockPosIn, fb facingIn, RenderEnv renderEnv, bvt stateNeighbourIn, ew posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        ctc voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        ctc voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.d());
        boolean flag = csz.c((ctc)voxelshape, (ctc)voxelshape1, (csm)csm.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bmv block) {
        return fn.j.a((Object)block);
    }

    public static bmv getBlock(qv loc) {
        if (!fn.j.c(loc)) {
            return null;
        }
        return (bmv)fn.j.a(loc);
    }

    public static int getMetadata(bvt blockState) {
        bmv block = blockState.d();
        bvu stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bmv block) {
        bvu stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static bvt getBlockState(bmv block, int metadata) {
        bvu stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        bvt blockState = (bvt)validStates.get(metadata);
        return blockState;
    }

    public static List<bvt> getBlockStates(bmv block) {
        bvu stateContainer = block.n();
        ImmutableList validStates = stateContainer.a();
        return validStates;
    }

    public static boolean isFullCube(bvt stateIn, bhb blockReaderIn, ew posIn) {
        return bmv.a((ctc)stateIn.i(blockReaderIn, posIn));
    }

    public static Collection<bww> getProperties(bvt blockState) {
        return blockState.a();
    }

    public static final class RenderSideCacheKey {
        private bvt blockState1;
        private bvt blockState2;
        private fb facing;
        private int hashCode;

        private RenderSideCacheKey(bvt blockState1In, bvt blockState2In, fb facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(bvt blockState1In, bvt blockState2In, fb facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

