/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;

public class FieldLocatorName
implements IFieldLocator {
    private ReflectorClass reflectorClass = null;
    private String targetFieldName = null;

    public FieldLocatorName(ReflectorClass reflectorClass, String targetFieldName) {
        this.reflectorClass = reflectorClass;
        this.targetFieldName = targetFieldName;
    }

    @Override
    public Field getField() {
        Class cls = this.reflectorClass.getTargetClass();
        if (cls == null) {
            return null;
        }
        try {
            Field targetField = cls.getDeclaredField(this.targetFieldName);
            targetField.setAccessible(true);
            return targetField;
        }
        catch (NoSuchFieldException e) {
            Config.log("(Reflector) Field not present: " + cls.getName() + "." + this.targetFieldName);
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

