/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import net.optifine.entity.model.anim.ParseException;
import net.optifine.entity.model.anim.Token;
import net.optifine.entity.model.anim.TokenType;

public class TokenParser {
    public static Token[] parse(String str) throws IOException, ParseException {
        int i;
        StringReader r = new StringReader(str);
        PushbackReader pr = new PushbackReader(r);
        ArrayList<Token> list = new ArrayList<Token>();
        while ((i = pr.read()) >= 0) {
            char ch = (char)i;
            if (Character.isWhitespace(ch)) continue;
            TokenType type = TokenType.getTypeByFirstChar(ch);
            if (type == null) {
                throw new ParseException("Invalid character: '" + ch + "', in: " + str);
            }
            Token token = TokenParser.readToken(ch, type, pr);
            list.add(token);
        }
        Token[] tokens = list.toArray(new Token[list.size()]);
        return tokens;
    }

    private static Token readToken(char chFirst, TokenType type, PushbackReader pr) throws IOException {
        int i;
        StringBuffer sb2 = new StringBuffer();
        sb2.append(chFirst);
        while ((i = pr.read()) >= 0) {
            char ch = (char)i;
            if (!type.hasCharNext(ch)) {
                pr.unread(ch);
                break;
            }
            sb2.append(ch);
        }
        return new Token(type, sb2.toString());
    }
}

