/*
 * Decompiled with CFR 0.152.
 */
package locusway.overpoweredarmorbar.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import locusway.overpoweredarmorbar.Configs;
import locusway.overpoweredarmorbar.overlay.ArmorBar;
import locusway.overpoweredarmorbar.overlay.ArmorIcon;
import locusway.overpoweredarmorbar.overlay.ArmorIconColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayEventHandler {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private Minecraft mc = Minecraft.func_71410_x();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.blit(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int scaledWidth = this.mc.field_195558_d.func_198107_o();
        int scaledHeight = this.mc.field_195558_d.func_198087_p();
        this.renderArmorBar(scaledWidth, scaledHeight);
        event.setCanceled(true);
    }

    private int calculateArmorValue() {
        int currentArmorValue = this.mc.field_71439_g.func_70658_aO();
        return currentArmorValue;
    }

    public void renderArmorBar(int screenWidth, int screenHeight) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yStart = screenHeight - 39;
        double playerHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
        if (!((Boolean)Configs.ClientConfig.offset.get()).booleanValue() && playerHealth > 20.0) {
            playerHealth = 20.0;
        }
        float absorptionAmount = MathHelper.func_76123_f((float)player.func_110139_bj());
        if (!((Boolean)Configs.ClientConfig.offset.get()).booleanValue() && absorptionAmount > 20.0f) {
            absorptionAmount = 20.0f;
        }
        int numberOfHealthBars = (int)Math.ceil(playerHealth / 20.0) + (int)Math.ceil(absorptionAmount / 20.0f);
        int i2 = Math.max(10 - (numberOfHealthBars - 2), 3);
        int yPosition = yStart - (numberOfHealthBars - 1) * i2 - 10;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    GlStateManager.color4f((float)color.Red, (float)color.Green, (float)color.Blue, (float)color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!((Boolean)Configs.ClientConfig.showEmptyArmorIcons.get()).booleanValue() || !((Boolean)Configs.ClientConfig.alwaysShowArmorBar.get()).booleanValue() && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    GlStateManager.color4f((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 25, 9, 5, 9);
                    GlStateManager.color4f((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    GlStateManager.color4f((float)fullColor.Red, (float)fullColor.Green, (float)fullColor.Blue, (float)fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }
}

