/*
 * Decompiled with CFR 0.152.
 */
package locusway.overpoweredarmorbar.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import locusway.overpoweredarmorbar.Configs;
import locusway.overpoweredarmorbar.overlay.ArmorBar;
import locusway.overpoweredarmorbar.overlay.ArmorIcon;
import locusway.overpoweredarmorbar.overlay.ArmorIconColor;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayEventHandler {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private Minecraft mc = Minecraft.func_71410_x();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.blit(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int scaledWidth = this.mc.func_228018_at_().func_198107_o();
        int scaledHeight = this.mc.func_228018_at_().func_198087_p();
        this.renderArmorBar(scaledWidth, scaledHeight);
        event.setCanceled(true);
    }

    private int calculateArmorValue() {
        int currentArmorValue = this.mc.field_71439_g.func_70658_aO();
        return currentArmorValue;
    }

    public void renderArmorBar(int screenWidth, int screenHeight) {
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yPosition = screenHeight - ForgeIngameGui.left_height;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        GlStateManager.func_227626_N_();
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(color.Red, color.Green, color.Blue, color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!((Boolean)Configs.ClientConfig.showEmptyArmorIcons.get()).booleanValue() || !((Boolean)Configs.ClientConfig.alwaysShowArmorBar.get()).booleanValue() && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    OverlayEventHandler.color4f(firstHalfColor.Red, firstHalfColor.Green, firstHalfColor.Blue, firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 25, 9, 5, 9);
                    OverlayEventHandler.color4f(secondHalfColor.Red, secondHalfColor.Green, secondHalfColor.Blue, secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(fullColor.Red, fullColor.Green, fullColor.Blue, fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        OverlayEventHandler.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_227627_O_();
    }

    private static void color4f(float r, float g, float b, float a) {
        GlStateManager.func_227702_d_((float)r, (float)g, (float)b, (float)a);
    }
}

