/*
 * Decompiled with CFR 0.152.
 */
package tfar.overpoweredarmorbar;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean alwaysShowAmorBar;
    private boolean showEmptyArmorIcons;
    private String colorValues;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("Overloaded Armor Bar")) {
            this.loadConfig();
        }
    }

    public void onConfigChanging(ConfigChangedEvent.OnConfigChangingEvent event) {
        if (event.getModID().equals("Overloaded Armor Bar")) {
            switch (event.getItem()) {
                case "overloadedarmorbar.config.alwaysshow": {
                    this.alwaysShowAmorBar = (Boolean)event.getNewValue();
                    break;
                }
                case "overloadedarmorbar.config.showempty": {
                    this.showEmptyArmorIcons = (Boolean)event.getNewValue();
                    break;
                }
                case "overloadedarmorbar.config.colorlist": {
                    this.colorValues = (String)event.getNewValue();
                }
            }
        }
    }

    private void loadConfig() {
        this.alwaysShowAmorBar = this.config.getBoolean("overloadedarmorbar.config.alwaysshow", 0, false, "overloadedarmorbar.config.tt.alwaysshow");
        this.showEmptyArmorIcons = this.config.getBoolean("overloadedarmorbar.config.showempty", 0, false, "overloadedarmorbar.config.tt.showempty");
        this.colorValues = this.config.getString("overloadedarmorbar.config.colors", 0, "#FFFFFF #FF5500 #FFC747 #27FFE3 #00FF00 #7F00FF", "overloadedarmorbar.config.tt.colors");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static boolean alwaysShowArmorBar() {
        return ConfigurationHandler.getInstance().alwaysShowAmorBar;
    }

    public static boolean showEmptyArmorIcons() {
        return ConfigurationHandler.getInstance().showEmptyArmorIcons;
    }

    public static List<String> colorValues() {
        return Arrays.asList(ConfigurationHandler.getInstance().colorValues.split(" "));
    }
}

